/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.math.BoundingBox;
import artofillusion.math.FastMath;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.Photon;
import artofillusion.raytracer.PhotonList;
import artofillusion.raytracer.PhotonMapContext;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.raytracer.RaytracerRenderer;
import artofillusion.raytracer.RenderWorkspace;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;
import java.util.ArrayList;
import java.util.Random;

public class PhotonMap {
    private Raytracer rt;
    private RaytracerRenderer renderer;
    private ArrayList<Photon> photonList;
    private Photon[] photon;
    private Photon[] workspace;
    private int numWanted;
    private int filter;
    private int numEstimate;
    private BoundingBox bounds;
    private Vec3[] direction;
    private boolean includeCaustics;
    private boolean includeDirect;
    private boolean includeIndirect;
    private boolean includeVolume;
    private double lightScale;
    private float cutoffDist2;
    public Random random;

    public PhotonMap(int totalPhotons, int numEstimate, boolean includeCaustics, boolean includeDirect, boolean includeIndirect, boolean includeVolume, Raytracer raytracer, RaytracerRenderer renderer, BoundingBox bounds, int filter, PhotonMap shared) {
        this.numWanted = totalPhotons;
        this.bounds = bounds;
        this.includeCaustics = includeCaustics;
        this.includeDirect = includeDirect;
        this.includeIndirect = includeIndirect;
        this.includeVolume = includeVolume;
        this.filter = filter;
        this.numEstimate = numEstimate;
        this.rt = raytracer;
        this.renderer = renderer;
        this.direction = shared != null ? shared.direction : new Vec3[65536];
        this.random = new Random(1L);
    }

    public Raytracer getRaytracer() {
        return this.rt;
    }

    public RaytracerRenderer getRenderer() {
        return this.renderer;
    }

    public RenderWorkspace getWorkspace() {
        return this.renderer.getWorkspace();
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public int getNumToEstimate() {
        return this.numEstimate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePhotons(PhotonSource[] source) {
        Thread currentThread = Thread.currentThread();
        double totalIntensity = 0.0;
        double totalRequested = 0.0;
        double[] sourceIntensity = new double[source.length];
        double totalSourceIntensity = 0.0;
        for (int i = 0; i < source.length; ++i) {
            sourceIntensity[i] = source[i].getTotalIntensity();
            totalSourceIntensity += sourceIntensity[i];
        }
        double currentIntensity = 0.1 * (double)this.numWanted;
        this.photonList = new ArrayList((int)(1.1 * (double)this.numWanted));
        int iteration = 0;
        ThreadManager threads = new ThreadManager();
        try {
            while (this.photonList.size() < this.numWanted) {
                for (int i = 0; i < source.length; ++i) {
                    if (this.renderer.renderThread != currentThread) {
                        return;
                    }
                    source[i].generatePhotons(this, currentIntensity * sourceIntensity[i] / totalSourceIntensity, threads);
                    totalRequested += currentIntensity * sourceIntensity[i] / totalSourceIntensity;
                }
                if ((double)this.photonList.size() >= (double)this.numWanted * 0.9) {
                    break;
                }
                if (this.photonList.isEmpty() && currentIntensity > 5.0 && iteration > 2) {
                    break;
                }
                currentIntensity = this.photonList.size() < 10 ? (currentIntensity *= 10.0) : (double)(this.numWanted - this.photonList.size()) * (totalIntensity += currentIntensity) / (double)this.photonList.size();
                ++iteration;
            }
        }
        finally {
            threads.finish();
        }
        this.lightScale = totalSourceIntensity / totalRequested;
        if (this.filter == 2) {
            this.lightScale *= 3.0;
        } else if (this.filter == 1) {
            this.lightScale *= 1.5;
        }
        int numPhotons = this.photonList.size();
        this.workspace = this.photonList.toArray(new Photon[numPhotons]);
        this.photonList = null;
        this.photon = new Photon[numPhotons];
        this.buildTree(0, numPhotons - 1, 0);
        this.workspace = null;
        PhotonList nearbyPhotons = new PhotonList(this.numEstimate);
        RGBColor tempColor = new RGBColor();
        nearbyPhotons.init(0.0f);
        for (int i = 0; i < this.photon.length; ++i) {
            tempColor.setERGB(this.photon[i].ergb);
            float intensity = -(tempColor.getRed() + tempColor.getGreen() + tempColor.getBlue());
            if (!(intensity <= nearbyPhotons.cutoff2)) continue;
            nearbyPhotons.addPhoton(this.photon[i], intensity);
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (int i = 0; i < nearbyPhotons.numFound; ++i) {
            tempColor.setERGB(nearbyPhotons.photon[i].ergb);
            red += tempColor.getRed();
            green += tempColor.getGreen();
            blue += tempColor.getBlue();
        }
        float max = Math.max(Math.max(red, green), blue);
        double cutoff1 = this.includeVolume ? Math.pow((double)max * this.lightScale / 0.41887902047863906, 0.3333333333333333) : Math.sqrt((double)max * this.lightScale / 0.3141592653589793);
        double volume = (this.bounds.maxx - this.bounds.minx) * (this.bounds.maxy - this.bounds.miny) * (this.bounds.maxz - this.bounds.minz);
        double cutoff2 = Math.pow(0.5 * volume * (double)nearbyPhotons.photon.length / (double)this.photon.length, 0.3333333333333333);
        this.cutoffDist2 = (float)(cutoff1 < cutoff2 ? cutoff1 * cutoff1 : cutoff2 * cutoff2);
    }

    public void spawnPhoton(Ray r, RGBColor color, boolean indirect) {
        if (!r.intersects(this.bounds)) {
            return;
        }
        OctreeNode node = this.rt.getRootNode().findNode(r.getOrigin());
        if (node == null) {
            node = this.rt.getRootNode().findFirstNode(r);
        }
        if (node == null) {
            return;
        }
        color = color.duplicate();
        RTObject materialObject = this.renderer.getMaterialAtPoint(this.getWorkspace(), r.getOrigin(), node);
        if (materialObject == null) {
            this.tracePhoton(r, color, 0, node, SurfaceIntersection.NO_INTERSECTION, null, null, null, null, 0.0, indirect, false);
        } else {
            this.tracePhoton(r, color, 0, node, SurfaceIntersection.NO_INTERSECTION, materialObject.getMaterialMapping(), null, materialObject.toLocal(), null, 0.0, indirect, false);
        }
    }

    private void tracePhoton(Ray r, RGBColor color, int treeDepth, OctreeNode node, SurfaceIntersection first, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, double totalDist, boolean diffuse, boolean caustic) {
        double d;
        Vec3 temp;
        double texSmoothing;
        OctreeNode nextNode;
        SurfaceIntersection second = SurfaceIntersection.NO_INTERSECTION;
        double n = 1.0;
        double beta = 0.0;
        RenderWorkspace workspace = this.getWorkspace();
        Vec3 intersectionPoint = workspace.pos[treeDepth];
        Vec3 norm = workspace.normal[treeDepth];
        Vec3 trueNorm = workspace.trueNormal[treeDepth];
        TextureSpec spec = workspace.surfSpec[treeDepth];
        Mat4 oldMatTrans = null;
        SurfaceIntersection intersect = SurfaceIntersection.NO_INTERSECTION;
        if (first != SurfaceIntersection.NO_INTERSECTION) {
            intersect = r.findIntersection(first.getObject());
        }
        if (intersect != SurfaceIntersection.NO_INTERSECTION) {
            intersect.intersectionPoint(0, intersectionPoint);
            nextNode = this.rt.getRootNode().findNode(intersectionPoint);
        } else {
            nextNode = this.rt.traceRay(r, node, workspace.context.intersect);
            if (nextNode == null) {
                return;
            }
            first = workspace.context.intersect.getFirst();
            second = workspace.context.intersect.getSecond();
            intersect = first;
            intersect.intersectionPoint(0, intersectionPoint);
        }
        double dist = intersect.intersectionDist(0);
        totalDist += dist;
        intersect.trueNormal(trueNorm);
        double truedot = trueNorm.dot(r.getDirection());
        double d2 = texSmoothing = diffuse ? this.renderer.smoothScale * this.renderer.extraGISmoothing : this.renderer.smoothScale;
        if (truedot > 0.0) {
            intersect.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 + truedot), this.rt.getTime());
        } else {
            intersect.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 - truedot), this.rt.getTime());
        }
        if (currentMaterial != null) {
            if (this.includeVolume && currentMaterial.isScattering()) {
                this.propagateRay(r, nextNode, second, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, color, treeDepth, totalDist, caustic, diffuse);
            } else {
                RGBColor emissive = new RGBColor();
                workspace.rt.propagateRay(workspace, r, nextNode, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, emissive, color, treeDepth, totalDist);
            }
        } else if (this.renderer.fog) {
            color.scale((float)Math.exp(-dist / this.renderer.fogDist));
        }
        if (color.getRed() + color.getGreen() + color.getBlue() < this.renderer.minRayIntensity) {
            return;
        }
        if (!this.includeVolume && (this.includeDirect && treeDepth == 0 || this.includeIndirect && diffuse || this.includeCaustics && caustic) && spec.diffuse.getRed() + spec.diffuse.getGreen() + spec.diffuse.getBlue() + spec.hilight.getRed() + spec.hilight.getGreen() + spec.hilight.getBlue() > this.renderer.minRayIntensity) {
            this.addPhoton(intersectionPoint, r.getDirection(), color);
        }
        if (treeDepth == this.renderer.maxRayDepth - 1) {
            return;
        }
        boolean spawnSpecular = false;
        boolean spawnTransmitted = false;
        boolean spawnDiffuse = false;
        if ((this.includeCaustics || this.includeVolume) && spec.specular.getRed() + spec.specular.getGreen() + spec.specular.getBlue() > this.renderer.minRayIntensity) {
            spawnSpecular = true;
        }
        if ((this.includeCaustics || this.includeVolume) && spec.transparent.getRed() + spec.transparent.getGreen() + spec.transparent.getBlue() > this.renderer.minRayIntensity) {
            spawnTransmitted = true;
        }
        if (this.includeIndirect && !this.includeVolume && spec.diffuse.getRed() + spec.diffuse.getGreen() + spec.diffuse.getBlue() > this.renderer.minRayIntensity) {
            spawnDiffuse = true;
        }
        double dot = norm.dot(r.getDirection());
        RGBColor col = workspace.rayIntensity[treeDepth + 1];
        boolean totalReflect = false;
        if (spawnTransmitted) {
            MaterialMapping oldMaterial;
            Mat4 nextMatTrans;
            MaterialMapping nextMaterial;
            col.copy(color);
            col.multiply(spec.transparent);
            workspace.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            temp = workspace.ray[treeDepth + 1].getDirection();
            RTObject hitObject = first.getObject();
            if (hitObject.getMaterialMapping() == null) {
                temp.set(r.getDirection());
                nextMaterial = currentMaterial;
                nextMatTrans = currentMatTrans;
                oldMaterial = prevMaterial;
                oldMatTrans = prevMatTrans;
            } else if (dot < 0.0) {
                nextMaterial = hitObject.getMaterialMapping();
                nextMatTrans = hitObject.toLocal();
                oldMaterial = currentMaterial;
                oldMatTrans = currentMatTrans;
                n = currentMaterial == null ? nextMaterial.indexOfRefraction() / 1.0 : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                beta = -(dot + Math.sqrt(n * n - 1.0 + dot * dot));
                temp.set(norm);
                temp.scale(beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            } else {
                if (currentMaterial == hitObject.getMaterialMapping()) {
                    nextMaterial = prevMaterial;
                    nextMatTrans = prevMatTrans;
                    oldMaterial = null;
                    n = nextMaterial == null ? 1.0 / currentMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                } else {
                    nextMaterial = currentMaterial;
                    nextMatTrans = currentMatTrans;
                    if (prevMaterial == hitObject.getMaterialMapping()) {
                        oldMaterial = null;
                    } else {
                        oldMaterial = prevMaterial;
                        oldMatTrans = prevMatTrans;
                    }
                    n = 1.0;
                }
                beta = dot - Math.sqrt(n * n - 1.0 + dot * dot);
                temp.set(norm);
                temp.scale(-beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            }
            if (Double.isNaN(beta)) {
                totalReflect = true;
            } else {
                double d3 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
                if (d < 0.0) {
                    temp.x -= (d += 1.0E-12) * trueNorm.x;
                    temp.y -= d * trueNorm.y;
                    temp.z -= d * trueNorm.z;
                    temp.normalize();
                }
                workspace.ray[treeDepth + 1].newID();
                if (this.renderer.gloss) {
                    this.randomizeDirection(temp, norm, spec.cloudiness);
                }
                boolean newCaustic = caustic || n != 1.0;
                this.tracePhoton(workspace.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, nextMaterial, oldMaterial, nextMatTrans, oldMatTrans, totalDist, diffuse, newCaustic);
            }
        }
        if (spawnSpecular || totalReflect) {
            col.copy(spec.specular);
            if (totalReflect) {
                col.add(spec.transparent.getRed(), spec.transparent.getGreen(), spec.transparent.getBlue());
            }
            col.multiply(color);
            temp = workspace.ray[treeDepth + 1].getDirection();
            temp.set(norm);
            temp.scale(-2.0 * dot);
            temp.add(r.getDirection());
            double d4 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
            if (d >= 0.0) {
                temp.x += (d += 1.0E-12) * trueNorm.x;
                temp.y += d * trueNorm.y;
                temp.z += d * trueNorm.z;
                temp.normalize();
            }
            workspace.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            workspace.ray[treeDepth + 1].newID();
            if (this.renderer.gloss) {
                this.randomizeDirection(temp, norm, spec.roughness);
            }
            this.tracePhoton(workspace.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, totalDist, diffuse, true);
        }
        if (spawnDiffuse) {
            col.copy(spec.diffuse);
            col.multiply(color);
            temp = workspace.ray[treeDepth + 1].getDirection();
            do {
                temp.set(0.0, 0.0, 0.0);
                this.randomizePoint(temp, 1.0);
                temp.normalize();
                d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
            } while (this.random.nextDouble() > (d < 0.0 ? -d : d));
            if (d > 0.0) {
                temp.scale(-1.0);
            }
            workspace.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            workspace.ray[treeDepth + 1].newID();
            this.tracePhoton(workspace.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, totalDist, true, caustic);
        }
    }

    void propagateRay(Ray r, OctreeNode node, SurfaceIntersection first, double dist, MaterialMapping material, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, RGBColor color, int treeDepth, double totalDist, boolean caustic, boolean scattered) {
        RenderWorkspace workspace = this.getWorkspace();
        MaterialSpec matSpec = workspace.matSpec;
        Vec3 v = workspace.ray[treeDepth + 1].origin;
        Vec3 origin = r.origin;
        Vec3 direction = r.direction;
        double x = 0.0;
        double distToScreen = this.renderer.theCamera.getDistToScreen();
        v.set(origin);
        currentMatTrans.transform(v);
        double origx = v.x;
        double origy = v.y;
        double origz = v.z;
        v.set(direction);
        currentMatTrans.transformDirection(v);
        double dirx = v.x;
        double diry = v.y;
        double dirz = v.z;
        double step = this.renderer.stepSize * material.getStepSize();
        do {
            double newx;
            double dx = step * (1.5 * workspace.context.random.nextDouble());
            if (this.rt.isAdaptive() && totalDist > distToScreen) {
                dx *= totalDist / distToScreen;
            }
            if ((newx = x + dx) > dist) {
                dx = dist - x;
                x = dist;
            } else {
                x = newx;
            }
            totalDist += dx;
            v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
            material.getMaterialSpec(v, matSpec, dx, this.rt.getTime());
            RGBColor trans = matSpec.transparency;
            RGBColor scat = matSpec.scattering;
            float rt = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), dx);
            float gt = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), dx);
            float bt = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), dx);
            float averageTrans = (rt + gt + bt) / 3.0f;
            if (!(this.random.nextFloat() < averageTrans)) {
                float scatProb = (scat.getRed() + scat.getGreen() + scat.getBlue()) / 3.0f;
                if (scatProb > 0.98f) {
                    scatProb = 0.98f;
                }
                if (this.random.nextFloat() < scatProb && treeDepth < this.renderer.maxRayDepth - 1) {
                    if (treeDepth < this.renderer.maxRayDepth - 1) {
                        RGBColor rayIntensity = workspace.rayIntensity[treeDepth + 1];
                        rayIntensity.copy(color);
                        rayIntensity.multiply(matSpec.scattering);
                        rayIntensity.scale(1.0f / scatProb);
                        if (rayIntensity.getMaxComponent() > this.renderer.minRayIntensity) {
                            v.set(origin.x + direction.x * x, origin.y + direction.y * x, origin.z + direction.z * x);
                            while (node != null && !node.contains(v)) {
                                OctreeNode nextNode;
                                node = nextNode = node.findNextNode(r);
                            }
                            if (node == null) break;
                            double g = matSpec.eccentricity;
                            Vec3 newdir = workspace.ray[treeDepth + 1].getDirection();
                            if (g > 0.01 || g < -0.01) {
                                double theta = Math.acos((1.0 + g * g - Math.pow((1.0 - g * g) / (1.0 - g + 2.0 * g * this.random.nextDouble()), 2.0)) / Math.abs(2.0 * g));
                                double phi = Math.PI * 2 * this.random.nextDouble();
                                newdir.set(Math.sin(theta) * Math.cos(phi), Math.sin(theta) * Math.sin(phi), Math.cos(theta));
                                Mat4 m = Mat4.objectTransform((Vec3)new Vec3(), (Vec3)direction, (Vec3)(Math.abs(direction.y) > 0.9 ? Vec3.vx() : Vec3.vy()));
                                m.transformDirection(newdir);
                            } else {
                                newdir.set(0.0, 0.0, 0.0);
                                this.randomizePoint(newdir, 1.0);
                                newdir.normalize();
                            }
                            this.tracePhoton(workspace.ray[treeDepth + 1], rayIntensity, treeDepth + 1, node, first, material, prevMaterial, currentMatTrans, prevMatTrans, totalDist, true, caustic);
                        }
                    }
                    color.setRGB(0.0, 0.0, 0.0);
                    break;
                }
                color.scale(1.0 / (1.0 - (double)scatProb));
                if ((this.includeDirect || scattered) && color.getMaxComponent() > this.renderer.minRayIntensity) {
                    this.addPhoton(v, direction, color);
                }
                color.setRGB(0.0, 0.0, 0.0);
                break;
            }
            color.multiply(rt / averageTrans, gt / averageTrans, bt / averageTrans);
        } while (x < dist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPhoton(Vec3 pos, Vec3 dir, RGBColor color) {
        Photon p = new Photon(pos, dir, color);
        PhotonMap photonMap = this;
        synchronized (photonMap) {
            this.photonList.add(p);
        }
        if (this.direction[p.direction & 0xFFFF] == null) {
            int i = p.direction >> 8 & 0xFF;
            int j = p.direction & 0xFF;
            double phi = (double)i * Math.PI / 128.0;
            double theta = (double)j * Math.PI / 256.0;
            double sphi = Math.sin(phi);
            double cphi = Math.cos(phi);
            double stheta = Math.sin(theta);
            double ctheta = Math.cos(theta);
            this.direction[p.direction & 0xFFFF] = new Vec3(cphi * stheta, ctheta, sphi * stheta);
        }
    }

    void randomizePoint(Vec3 pos, double size) {
        double z;
        double y;
        double x;
        if (size == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble() - 0.5) * x + (y = this.random.nextDouble() - 0.5) * y + (z = this.random.nextDouble() - 0.5) * z > 0.25) {
        }
        pos.x += 2.0 * size * x;
        pos.y += 2.0 * size * y;
        pos.z += 2.0 * size * z;
    }

    void randomizeDirection(Vec3 dir, Vec3 norm, double roughness) {
        double z;
        double y;
        double x;
        if (roughness == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble() - 0.5) * x + (y = this.random.nextDouble() - 0.5) * y + (z = this.random.nextDouble() - 0.5) * z > 0.25) {
        }
        double scale = Math.pow(roughness, 1.7) * 0.5;
        double dot1 = dir.dot(norm);
        dir.x += 2.0 * scale * x;
        dir.y += 2.0 * scale * y;
        dir.z += 2.0 * scale * z;
        double dot2 = 2.0 * dir.dot(norm);
        if (dot1 < 0.0 && dot2 > 0.0) {
            dir.x -= dot2 * norm.x;
            dir.y -= dot2 * norm.y;
            dir.z -= dot2 * norm.z;
        } else if (dot1 > 0.0 && dot2 < 0.0) {
            dir.x += dot2 * norm.x;
            dir.y += dot2 * norm.y;
            dir.z += dot2 * norm.z;
        }
        dir.normalize();
    }

    private void buildTree(int start, int end, int root) {
        if (start == end) {
            this.photon[root] = this.workspace[start];
        }
        if (start >= end) {
            return;
        }
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float minz = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        float maxz = -3.4028235E38f;
        for (int i = start; i <= end; ++i) {
            Photon p = this.workspace[i];
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (p.z < minz) {
                minz = p.z;
            }
            if (p.x > maxx) {
                maxx = p.x;
            }
            if (p.y > maxy) {
                maxy = p.y;
            }
            if (!(p.z > maxz)) continue;
            maxz = p.z;
        }
        float xsize = maxx - minx;
        float ysize = maxy - miny;
        float zsize = maxz - minz;
        int axis = xsize > ysize && xsize > zsize ? 0 : (ysize > zsize ? 1 : 2);
        int size = end - start + 1;
        int medianPos = 1;
        while (4 * medianPos <= size) {
            medianPos += medianPos;
        }
        medianPos = 3 * medianPos <= size ? 2 * medianPos + start - 1 : end - medianPos + 1;
        this.medianSplit(start, end, medianPos, axis);
        this.photon[root] = this.workspace[medianPos];
        this.photon[root].axis = (short)axis;
        this.buildTree(start, medianPos - 1, 2 * root + 1);
        this.buildTree(medianPos + 1, end, 2 * root + 2);
    }

    private void medianSplit(int start, int end, int medianPos, int axis) {
        if (start == end) {
            return;
        }
        if (end - start == 1) {
            if (this.axisPosition(start, axis) > this.axisPosition(end, axis)) {
                this.swap(start, end);
            }
            return;
        }
        while (start < end) {
            float a = this.axisPosition(start, axis);
            float b = this.axisPosition(start + 1, axis);
            float c = this.axisPosition(end, axis);
            float medianEstimate = a > b ? (a > c ? (b > c ? b : c) : a) : (b > c ? (a > c ? a : c) : b);
            int i = start;
            int j = end;
            while (true) {
                if (i < end && this.axisPosition(i, axis) < medianEstimate) {
                    ++i;
                    continue;
                }
                while (this.axisPosition(j, axis) > medianEstimate) {
                    --j;
                }
                if (i >= j) break;
                this.swap(i, j);
                ++i;
                --j;
            }
            this.swap(i, end);
            if (i > medianPos) {
                end = i - 1;
            }
            if (i > medianPos) continue;
            start = i;
        }
    }

    private float axisPosition(int index, int axis) {
        switch (axis) {
            case 0: {
                return this.workspace[index].x;
            }
            case 1: {
                return this.workspace[index].y;
            }
        }
        return this.workspace[index].z;
    }

    private void swap(int first, int second) {
        Photon temp = this.workspace[first];
        this.workspace[first] = this.workspace[second];
        this.workspace[second] = temp;
    }

    public void getLight(Vec3 pos, TextureSpec spec, Vec3 normal, Vec3 viewDir, boolean front, RGBColor light, PhotonMapContext pmc) {
        light.setRGB(0.0f, 0.0f, 0.0f);
        if (this.photon.length == 0) {
            return;
        }
        PhotonList nearbyPhotons = pmc.nearbyPhotons;
        RGBColor tempColor = pmc.tempColor;
        RGBColor tempColor2 = pmc.tempColor2;
        Vec3 tempVec = pmc.tempVec;
        float startCutoff2 = (float)(Math.sqrt(pmc.lastCutoff2) + pos.distance(pmc.lastPos));
        if ((startCutoff2 *= startCutoff2) > this.cutoffDist2) {
            startCutoff2 = this.cutoffDist2;
        }
        nearbyPhotons.init(startCutoff2);
        this.findPhotons(pos, 0, pmc);
        pmc.lastPos.set(pos);
        pmc.lastCutoff2 = nearbyPhotons.cutoff2;
        if (nearbyPhotons.numFound == 0) {
            return;
        }
        float r2inv = 1.0f / nearbyPhotons.cutoff2;
        boolean hilight = false;
        if (spec.hilight.getMaxComponent() > this.renderer.minRayIntensity) {
            hilight = true;
            tempColor2.setRGB(0.0f, 0.0f, 0.0f);
        }
        for (int i = 0; i < nearbyPhotons.numFound; ++i) {
            double viewDot;
            Photon p = nearbyPhotons.photon[i];
            Vec3 dir = this.direction[p.direction & 0xFFFF];
            double dot = normal.dot(dir);
            if (!(front && dot < -1.0E-10) && (front || !(dot > 1.0E-10))) continue;
            tempColor.setERGB(p.ergb);
            float x = nearbyPhotons.dist2[i] * r2inv;
            if (this.filter == 2) {
                tempColor.scale(x * (x - 2.0f) + 1.0f);
            } else if (this.filter == 1) {
                tempColor.scale(1.0f - x * x);
            }
            light.add(tempColor);
            if (!hilight) continue;
            tempVec.set(dir);
            tempVec.add(viewDir);
            tempVec.normalize();
            double d = viewDot = front ? -tempVec.dot(normal) : tempVec.dot(normal);
            if (!(viewDot > 0.0)) continue;
            float scale = (float)FastMath.pow((double)viewDot, (int)((int)((1.0 - spec.roughness) * 128.0) + 1));
            tempColor2.add(tempColor.getRed() * scale, tempColor.getGreen() * scale, tempColor.getBlue() * scale);
        }
        light.multiply(spec.diffuse);
        if (hilight) {
            tempColor2.multiply(spec.hilight);
            light.add(tempColor2);
        }
        light.scale(this.lightScale / (Math.PI * (double)nearbyPhotons.cutoff2));
    }

    public void getVolumeLight(Vec3 pos, MaterialSpec spec, Vec3 viewDir, RGBColor light, PhotonMapContext pmc) {
        light.setRGB(0.0f, 0.0f, 0.0f);
        if (this.photon.length == 0) {
            return;
        }
        PhotonList nearbyPhotons = pmc.nearbyPhotons;
        RGBColor tempColor = pmc.tempColor;
        float startCutoff2 = pmc.lastCutoff2 + (float)pos.distance2(pmc.lastPos);
        if (startCutoff2 > this.cutoffDist2) {
            startCutoff2 = this.cutoffDist2;
        }
        nearbyPhotons.init(startCutoff2);
        this.findPhotons(pos, 0, pmc);
        pmc.lastPos.set(pos);
        pmc.lastCutoff2 = nearbyPhotons.cutoff2;
        if (nearbyPhotons.numFound == 0) {
            return;
        }
        double eccentricity = spec.eccentricity;
        double ec2 = eccentricity * eccentricity;
        for (int i = 0; i < nearbyPhotons.numFound; ++i) {
            Photon p = nearbyPhotons.photon[i];
            tempColor.setERGB(p.ergb);
            if (eccentricity != 0.0) {
                Vec3 dir = this.direction[p.direction & 0xFFFF];
                double dot = dir.dot(viewDir);
                double fatt = (1.0 - ec2) / Math.pow(1.0 + ec2 + 2.0 * eccentricity * dot, 1.5);
                tempColor.scale(fatt);
            }
            light.add(tempColor);
        }
        light.scale(this.lightScale / (4.1887902047863905 * Math.pow(nearbyPhotons.cutoff2, 1.5)));
    }

    private void findPhotons(Vec3 pos, int index, PhotonMapContext pmc) {
        float delta;
        Photon p = this.photon[index];
        float dx = p.x - (float)pos.x;
        float dy = p.y - (float)pos.y;
        float dz = p.z - (float)pos.z;
        float dist2 = dx * dx + dy * dy + dz * dz;
        switch (p.axis) {
            case 0: {
                delta = dx;
                break;
            }
            case 1: {
                delta = dy;
                break;
            }
            default: {
                delta = dz;
            }
        }
        if (delta > 0.0f) {
            int child = (index << 1) + 1;
            if (child < this.photon.length) {
                this.findPhotons(pos, child, pmc);
                delta *= delta;
                if (++child < this.photon.length && delta < pmc.nearbyPhotons.cutoff2) {
                    this.findPhotons(pos, child, pmc);
                }
            }
        } else {
            int child = (index << 1) + 2;
            if (child < this.photon.length) {
                this.findPhotons(pos, child, pmc);
            }
            delta *= delta;
            if (--child < this.photon.length && delta < pmc.nearbyPhotons.cutoff2) {
                this.findPhotons(pos, child, pmc);
            }
        }
        if (dist2 < pmc.nearbyPhotons.cutoff2) {
            pmc.nearbyPhotons.addPhoton(p, dist2);
        }
    }

    private void validateTree(int pos) {
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateLowerBranch(child1, this.photon[pos].axis, this.median(pos, this.photon[pos].axis));
            this.validateTree(child1);
        }
        if (child2 < this.photon.length) {
            this.validateUpperBranch(child2, this.photon[pos].axis, this.median(pos, this.photon[pos].axis));
            this.validateTree(child2);
        }
    }

    private void validateLowerBranch(int pos, int axis, float median) {
        float value = this.median(pos, axis);
        if (value > median) {
            System.out.println("error!");
        }
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateLowerBranch(child1, axis, median);
        }
        if (child2 < this.photon.length) {
            this.validateLowerBranch(child2, axis, median);
        }
    }

    private void validateUpperBranch(int pos, int axis, float median) {
        float value = this.median(pos, axis);
        if (value < median) {
            System.out.println("error!");
        }
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateUpperBranch(child1, axis, median);
        }
        if (child2 < this.photon.length) {
            this.validateUpperBranch(child2, axis, median);
        }
    }

    private float median(int index, int axis) {
        switch (axis) {
            case 0: {
                return this.photon[index].x;
            }
            case 1: {
                return this.photon[index].y;
            }
        }
        return this.photon[index].z;
    }
}

