/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cylinder;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTCylinder
extends RTObject {
    Cylinder theCylinder;
    Vec3 topNormal;
    Vec3 bottomNormal;
    double rx;
    double rz;
    double height;
    double halfh;
    double rx2;
    double rz2;
    double toprx2;
    double cx;
    double cy;
    double cz;
    double sy;
    double sz;
    double[] param;
    boolean bumpMapped;
    boolean cone;
    boolean transform;
    boolean uniform;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int SIDE = 2;

    public RTCylinder(Cylinder cylinder, Mat4 fromLocal, Mat4 toLocal, double[] param) {
        double ratio = cylinder.getRatio();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theCylinder = cylinder;
        this.param = param;
        Vec3 size = cylinder.getBounds().getSize();
        this.uniform = cylinder.getTextureMapping() instanceof UniformMapping;
        this.cone = false;
        this.transform = true;
        if (vy.y == 1.0) {
            if (vx.x == 1.0 || vx.x == -1.0) {
                this.rx = size.x / 2.0;
                this.rz = size.z / 2.0;
                this.transform = false;
            } else if (vx.z == 1.0 || vx.z == -1.0) {
                this.rx = size.z / 2.0;
                this.rz = size.x / 2.0;
                this.transform = false;
            }
            if (!this.transform && ratio == 0.0) {
                this.cone = true;
            }
        } else if (vy.y == -1.0 && ratio != 0.0) {
            if (vx.x == 1.0 || vx.x == -1.0) {
                this.rx = size.x / 2.0;
                this.rz = size.z / 2.0;
                this.transform = false;
            } else if (vx.z == 1.0 || vx.z == -1.0) {
                this.rx = size.z / 2.0;
                this.rz = size.x / 2.0;
                this.transform = false;
            }
            if (!this.transform) {
                this.rx *= ratio;
                this.rz *= ratio;
                ratio = 1.0 / ratio;
            }
        }
        this.height = size.y;
        this.halfh = this.height / 2.0;
        if (this.transform) {
            this.rx = size.x / 2.0;
            this.rz = size.z / 2.0;
            if (ratio == 0.0) {
                this.cone = true;
            }
            this.fromLocal = fromLocal;
        }
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.rx2 = this.rx * this.rx;
        this.rz2 = this.rz * this.rz;
        this.toprx2 = this.rx2 * ratio * ratio;
        this.sz = this.rx2 / this.rz2;
        this.sy = this.rx * (ratio - 1.0) / this.height;
        this.bottomNormal = fromLocal.timesDirection(Vec3.vy()).times(-1.0);
        if (!this.cone) {
            this.topNormal = this.bottomNormal.times(-1.0);
        }
        this.bumpMapped = cylinder.getTexture().hasComponent(5);
        this.toLocal = toLocal;
    }

    @Override
    public final MaterialMapping getMaterialMapping() {
        return this.theCylinder.getMaterialMapping();
    }

    @Override
    public final TextureMapping getTextureMapping() {
        return this.theCylinder.getTextureMapping();
    }

    @Override
    public SurfaceIntersection checkIntersection(Ray r) {
        int intersections;
        double e;
        double c;
        double temp2;
        double b;
        double a;
        double temp1;
        Vec3 orig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        Vec3 v1 = r.tempVec1;
        Vec3 v2 = r.tempVec2;
        Vec3 dir = r.tempVec3;
        int hit = -1;
        if (this.transform) {
            v1.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
            this.toLocal.transformDirection(v1);
            v1.y -= this.halfh;
            dir.set(rdir);
            this.toLocal.transformDirection(dir);
        } else {
            v1.set(this.cx - orig.x, this.cy - orig.y - this.halfh, this.cz - orig.z);
            if (this.uniform) {
                dir = rdir;
            } else {
                dir.set(rdir);
            }
        }
        double mint = Double.MAX_VALUE;
        if (dir.y != 0.0) {
            temp1 = v1.y / dir.y;
            if (temp1 > 1.0E-12 && (a = temp1 * dir.x - v1.x) * a + this.sz * (b = temp1 * dir.z - v1.z) * b < this.rx2) {
                hit = 1;
                mint = temp1;
            }
            if (!this.cone && (temp1 = (v1.y + this.height) / dir.y) > 1.0E-12 && (a = temp1 * dir.x - v1.x) * a + this.sz * (b = temp1 * dir.z - v1.z) * b < this.toprx2) {
                if (mint < Double.MAX_VALUE) {
                    double dist2;
                    double dist1;
                    int intersections2 = 2;
                    if (temp1 < mint) {
                        hit = 0;
                        dist1 = temp1;
                        dist2 = mint;
                    } else {
                        dist1 = mint;
                        dist2 = temp1;
                    }
                    v1.set(orig.x + dist1 * rdir.x, orig.y + dist1 * rdir.y, orig.z + dist1 * rdir.z);
                    v2.set(orig.x + dist2 * rdir.x, orig.y + dist2 * rdir.y, orig.z + dist2 * rdir.z);
                    return new CylinderIntersection(this, intersections2, hit, v1, v2, dist1, dist2);
                }
                hit = 0;
                mint = temp1;
            }
        }
        if (this.sy == 0.0) {
            temp1 = this.sz * dir.z;
            temp2 = 0.0;
            double d = this.rx;
            b = dir.x * v1.x + temp1 * v1.z;
            c = v1.x * v1.x + this.sz * v1.z * v1.z - d * d;
        } else {
            temp1 = this.sz * dir.z;
            temp2 = this.sy * dir.y;
            double d = this.rx - this.sy * v1.y;
            b = dir.x * v1.x + d * this.sy * dir.y + temp1 * v1.z;
            c = v1.x * v1.x + this.sz * v1.z * v1.z - d * d;
        }
        double dist1 = Double.MAX_VALUE;
        double dist2 = mint;
        if (c > 1.0E-12) {
            double e2;
            if (b > 0.0 && (e2 = b * b - (a = dir.x * dir.x + temp1 * dir.z - temp2 * temp2) * c) >= 0.0) {
                temp1 = Math.sqrt(e2);
                dist1 = (b - temp1) / a;
                if (dist2 == Double.MAX_VALUE) {
                    dist2 = (b + temp1) / a;
                }
            }
        } else if (c < -1.0E-12) {
            a = dir.x * dir.x + temp1 * dir.z - temp2 * temp2;
            double e3 = b * b - a * c;
            if (e3 >= 0.0) {
                dist1 = (b + Math.sqrt(e3)) / a;
            }
        } else if (b > 0.0 && (e = b * b - (a = dir.x * dir.x + temp1 * dir.z - temp2 * temp2) * c) >= 0.0) {
            dist1 = (b + Math.sqrt(e)) / a;
        }
        if (dist1 < mint && (a = dist1 * dir.y - v1.y) > 0.0 && a < this.height) {
            hit = 2;
            mint = dist1;
        }
        if (mint == Double.MAX_VALUE) {
            return SurfaceIntersection.NO_INTERSECTION;
        }
        if (dist2 < mint) {
            temp1 = dist2;
            dist2 = mint;
            mint = temp1;
        }
        dist1 = mint;
        v1.set(orig.x + dist1 * rdir.x, orig.y + dist1 * rdir.y, orig.z + dist1 * rdir.z);
        if (hit == 2) {
            this.projectPoint(v1);
        }
        if (dist2 == Double.MAX_VALUE) {
            intersections = 1;
        } else {
            intersections = 2;
            v2.set(orig.x + dist2 * rdir.x, orig.y + dist2 * rdir.y, orig.z + dist2 * rdir.z);
        }
        return new CylinderIntersection(this, intersections, hit, v1, v2, dist1, dist2);
    }

    private void projectPoint(Vec3 pos) {
        if (this.transform) {
            this.toLocal.transform(pos);
            double r = this.rx + this.sy * (pos.y + this.halfh);
            double scale = r / Math.sqrt(pos.x * pos.x + this.sz * pos.z * pos.z);
            pos.set(pos.x * scale, pos.y, pos.z * scale);
            this.fromLocal.transform(pos);
        } else {
            double dx = pos.x - this.cx;
            double dz = pos.z - this.cz;
            double r = this.rx + this.sy * (pos.y - this.cy + this.halfh);
            double scale = r / Math.sqrt(dx * dx + this.sz * dz * dz);
            pos.set(this.cx + dx * scale, pos.y, this.cz + dz * scale);
        }
    }

    @Override
    public BoundingBox getBounds() {
        if (this.transform) {
            return new BoundingBox(-this.rx, this.rx, -this.halfh, this.halfh, -this.rz, this.rz).transformAndOutset(this.fromLocal);
        }
        if (this.toprx2 > this.rx2) {
            double xrad = Math.sqrt(this.toprx2);
            double zrad = Math.sqrt(this.rz2 * this.toprx2 / this.rx2);
            return new BoundingBox(this.cx - xrad, this.cx + xrad, this.cy - this.halfh, this.cy + this.halfh, this.cz - zrad, this.cz + zrad);
        }
        return new BoundingBox(this.cx - this.rx, this.cx + this.rx, this.cy - this.halfh, this.cy + this.halfh, this.cz - this.rz, this.cz + this.rz);
    }

    @Override
    public boolean intersectsNode(OctreeNode node) {
        double maxrad2;
        BoundingBox bb = node.getBounds();
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
            if (bb.miny > this.halfh || bb.maxy < -this.halfh) {
                return false;
            }
            double x = 0.0;
            double z = 0.0;
            if (bb.minx > 0.0) {
                x = bb.minx;
            } else if (bb.maxx < 0.0) {
                x = bb.maxx;
            }
            if (bb.minz > 0.0) {
                z = bb.minz;
            } else if (bb.maxz < 0.0) {
                z = bb.maxz;
            }
            return !(x * x + this.sz * z * z > this.rx2);
        }
        if (bb.miny > this.cy + this.halfh || bb.maxy < this.cy - this.halfh) {
            return false;
        }
        double x = this.cx;
        double z = this.cz;
        if (this.cx < bb.minx) {
            x = bb.minx;
        } else if (this.cx > bb.maxx) {
            x = bb.maxx;
        }
        if (this.cz < bb.minz) {
            z = bb.minz;
        } else if (this.cz > bb.maxz) {
            z = bb.maxz;
        }
        double d = maxrad2 = this.rx2 > this.toprx2 ? this.rx2 : this.toprx2;
        return !((x - this.cx) * (x - this.cx) + this.sz * (z - this.cz) * (z - this.cz) > maxrad2);
    }

    @Override
    public Mat4 toLocal() {
        return this.toLocal;
    }

    private static class CylinderIntersection
    implements SurfaceIntersection {
        private RTCylinder cylinder;
        private int numIntersections;
        private int hit;
        private double dist1;
        private double dist2;
        private double r1x;
        private double r1y;
        private double r1z;
        private double r2x;
        private double r2y;
        private double r2z;
        private boolean trueNormValid;
        private Vec3 trueNorm;
        private Vec3 pos;

        public CylinderIntersection(RTCylinder cylinder, int numIntersections, int hit, Vec3 point1, Vec3 point2, double dist1, double dist2) {
            this.cylinder = cylinder;
            this.numIntersections = numIntersections;
            this.hit = hit;
            this.dist1 = dist1;
            this.dist2 = dist2;
            this.r1x = point1.x;
            this.r1y = point1.y;
            this.r1z = point1.z;
            this.r2x = point2.x;
            this.r2y = point2.y;
            this.r2z = point2.z;
            this.trueNorm = new Vec3();
            this.pos = new Vec3();
        }

        @Override
        public RTObject getObject() {
            return this.cylinder;
        }

        @Override
        public int numIntersections() {
            return this.numIntersections;
        }

        @Override
        public void intersectionPoint(int n, Vec3 p) {
            if (n == 0) {
                p.set(this.r1x, this.r1y, this.r1z);
            } else {
                p.set(this.r2x, this.r2y, this.r2z);
            }
        }

        @Override
        public double intersectionDist(int n) {
            if (n == 0) {
                return this.dist1;
            }
            return this.dist2;
        }

        @Override
        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
            TextureMapping map = this.cylinder.theCylinder.getTextureMapping();
            this.pos.set(this.r1x, this.r1y, this.r1z);
            if (this.cylinder.uniform) {
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.cylinder.param);
            } else {
                this.cylinder.toLocal.transform(this.pos);
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.cylinder.param);
            }
            if (this.cylinder.bumpMapped) {
                if (this.cylinder.transform) {
                    this.cylinder.fromLocal.transformDirection(spec.bumpGrad);
                }
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        @Override
        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            TextureMapping map = this.cylinder.theCylinder.getTextureMapping();
            if (n == 0) {
                this.pos.set(this.r1x, this.r1y, this.r1z);
            } else {
                this.pos.set(this.r2x, this.r2y, this.r2z);
            }
            if (this.cylinder.uniform) {
                map.getTransparency(this.pos, trans, angle, size, time, this.cylinder.param);
            } else {
                this.cylinder.toLocal.transform(this.pos);
                map.getTransparency(this.pos, trans, angle, size, time, this.cylinder.param);
            }
        }

        @Override
        public void trueNormal(Vec3 n) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
        }

        private void calcTrueNorm() {
            if (this.trueNormValid) {
                return;
            }
            this.trueNormValid = true;
            if (this.hit == 0) {
                this.trueNorm.set(this.cylinder.topNormal);
            } else if (this.hit == 1) {
                this.trueNorm.set(this.cylinder.bottomNormal);
            } else {
                if (this.cylinder.transform) {
                    this.trueNorm.set(this.r1x - this.cylinder.cx, this.r1y - this.cylinder.cy, this.r1z - this.cylinder.cz);
                    this.cylinder.toLocal.transformDirection(this.trueNorm);
                    this.trueNorm.set(this.trueNorm.x, -(this.cylinder.rx + this.cylinder.sy * (this.trueNorm.y + this.cylinder.halfh)) * this.cylinder.sy, this.trueNorm.z * this.cylinder.sz);
                    this.cylinder.fromLocal.transformDirection(this.trueNorm);
                } else {
                    this.trueNorm.set(this.r1x - this.cylinder.cx, -(this.cylinder.rx + this.cylinder.sy * (this.r1y - this.cylinder.cy + this.cylinder.halfh)) * this.cylinder.sy, (this.r1z - this.cylinder.cz) * this.cylinder.sz);
                }
                this.trueNorm.normalize();
            }
        }
    }
}

