/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.PointLight;
import artofillusion.object.SpotLight;
import artofillusion.raytracer.RTLight;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerRenderer;

public class RTSphericalLight
extends RTLight {
    private final double radius;

    public RTSphericalLight(PointLight light, CoordinateSystem coords, boolean softShadows) {
        super((Light)light, coords);
        this.radius = softShadows ? light.getRadius() : 0.0;
    }

    public RTSphericalLight(SpotLight light, CoordinateSystem coords, boolean softShadows) {
        super((Light)light, coords);
        this.radius = softShadows ? light.getRadius() : 0.0;
    }

    @Override
    public double findRayToLight(Vec3 origin, Ray ray, RaytracerRenderer renderer, int rayNumber) {
        ray.getOrigin().set(origin);
        Vec3 dir = ray.getDirection();
        dir.set(this.getCoords().getOrigin());
        if (rayNumber != -1) {
            renderer.randomizePoint(dir, ray.rt.random, this.radius, rayNumber);
        }
        dir.subtract(origin);
        double distToLight = dir.length();
        dir.normalize();
        return distToLight;
    }

    @Override
    public boolean getSoftShadows() {
        return this.radius != 0.0 && this.getLight().getType() == 0;
    }
}

