/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialSpec;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMapContext;
import artofillusion.raytracer.PixelInfo;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerContext;
import artofillusion.raytracer.RaytracerRenderer;
import artofillusion.texture.TextureSpec;

public class RenderWorkspace {
    public RaytracerRenderer rt;
    public RaytracerContext context;
    public RTObject firstObjectHit;
    public RTObject materialAtCamera;
    public boolean materialAtCameraIsFixed;
    public Ray[] ray;
    public RGBColor[] color;
    public RGBColor[] rayIntensity;
    public RGBColor tempColor;
    public RGBColor tempColor2;
    public Vec3[] pos;
    public Vec3[] normal;
    public Vec3[] trueNormal;
    public double[] transparency;
    public RaytracerRenderer.MaterialIntersection[] matChange;
    public TextureSpec[] surfSpec;
    public MaterialSpec matSpec;
    public PixelInfo tempPixel;
    public PhotonMapContext globalMap;
    public PhotonMapContext causticsMap;
    public PhotonMapContext volumeMap;

    public RenderWorkspace(RaytracerRenderer rt, RaytracerContext context) {
        int i;
        this.rt = rt;
        this.context = context;
        int maxRayDepth = rt.maxRayDepth;
        this.ray = new Ray[maxRayDepth + 1];
        this.color = new RGBColor[maxRayDepth + 1];
        this.transparency = new double[maxRayDepth + 1];
        this.rayIntensity = new RGBColor[maxRayDepth + 1];
        this.surfSpec = new TextureSpec[maxRayDepth + 1];
        this.pos = new Vec3[maxRayDepth + 1];
        this.normal = new Vec3[maxRayDepth + 1];
        this.trueNormal = new Vec3[maxRayDepth + 1];
        for (i = 0; i < maxRayDepth + 1; ++i) {
            this.ray[i] = new Ray(context);
            this.color[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.rayIntensity[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.surfSpec[i] = new TextureSpec();
            this.pos[i] = new Vec3();
            this.normal[i] = new Vec3();
            this.trueNormal[i] = new Vec3();
        }
        this.matSpec = new MaterialSpec();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.matChange = new RaytracerRenderer.MaterialIntersection[16];
        for (i = 0; i < this.matChange.length; ++i) {
            this.matChange[i] = new RaytracerRenderer.MaterialIntersection();
        }
        this.tempPixel = new PixelInfo();
        if (rt.globalMap != null) {
            this.globalMap = new PhotonMapContext(rt.globalMap);
        }
        if (rt.causticsMap != null) {
            this.causticsMap = new PhotonMapContext(rt.causticsMap);
        }
        if (rt.volumeMap != null) {
            this.volumeMap = new PhotonMapContext(rt.volumeMap);
        }
    }

    public RaytracerContext getContext() {
        return this.context;
    }

    public void increaseMaterialChangeLength() {
        RaytracerRenderer.MaterialIntersection[] newMatChange = new RaytracerRenderer.MaterialIntersection[this.matChange.length * 2];
        System.arraycopy(this.matChange, 0, newMatChange, 0, this.matChange.length);
        for (int i = this.matChange.length; i < newMatChange.length; ++i) {
            newMatChange[i] = new RaytracerRenderer.MaterialIntersection();
        }
        this.matChange = newMatChange;
    }

    public void cleanup() {
        this.matChange = null;
        this.tempPixel = null;
        this.globalMap = null;
        this.causticsMap = null;
        this.volumeMap = null;
    }
}

