/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.mp3;

import ch.randelshofer.media.mp3.MP3ElementaryInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class MP3AudioInputStream
extends AudioInputStream {
    private MP3ElementaryInputStream in;

    public MP3AudioInputStream(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public MP3AudioInputStream(InputStream in) throws IOException {
        super(null, new AudioFormat(MP3ElementaryInputStream.MP3, 44100.0f, 16, 2, 626, 38.28125f, true), -1L);
        this.in = new MP3ElementaryInputStream(in);
        if (this.in.getNextFrame() == null) {
            throw new IOException("Stream is not an MP3 elementary stream");
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public AudioFormat getFormat() {
        return this.in.getFormat();
    }

    @Override
    public long getFrameLength() {
        return -1L;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        throw new IOException("cannot read a single byte if frame size > 1");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in.getFrame() == null && this.in.getNextFrame() == null) {
            return -1;
        }
        if (this.in.getStreamPosition() != this.in.getFrame().getFrameOffset() && this.in.getNextFrame() == null) {
            return -1;
        }
        int bytesRead = 0;
        int frameSize = this.in.getFrame().getFrameSize();
        while (len >= frameSize) {
            this.in.readFully(b, off, frameSize);
            len -= frameSize;
            bytesRead += frameSize;
            off += frameSize;
            if (this.in.getNextFrame() == null) break;
            frameSize = this.in.getFrame().getFrameSize();
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

