/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.quicktime;

import ch.randelshofer.io.SeekableByteArrayOutputStream;
import ch.randelshofer.media.quicktime.DataAtomOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AppleRLEEncoder {
    private SeekableByteArrayOutputStream tmpSeek = new SeekableByteArrayOutputStream();
    private DataAtomOutputStream tmp = new DataAtomOutputStream(this.tmpSeek);

    public void writeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.tmpSeek.reset();
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        this.tmp.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            this.tmp.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                short v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount != 127) continue;
                    this.tmp.write(literalCount);
                    this.tmp.writeShorts(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    this.tmp.write(literalCount);
                    this.tmp.writeShorts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                this.tmp.write(-repeatCount);
                this.tmp.writeShort(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeShorts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }

    public void writeDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        this.tmpSeek.reset();
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            this.tmp.writeInt(4);
            this.tmpSeek.toOutputStream(out);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            this.tmp.writeShort(0);
        } else {
            this.tmp.writeShort(8);
            this.tmp.writeShort(ymin / scanlineStride);
            this.tmp.writeShort(0);
            this.tmp.writeShort((ymax - ymin + 1) / scanlineStride);
            this.tmp.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                this.tmp.write(1);
                this.tmp.write(-1);
                continue;
            }
            this.tmp.write(Math.min(255, skipCount + 1));
            if (skipCount > 254) {
                skipCount -= 254;
                while (skipCount > 254) {
                    this.tmp.write(0);
                    this.tmp.write(255);
                    skipCount -= 254;
                }
                this.tmp.write(0);
                this.tmp.write(skipCount + 1);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                short v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 2 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        this.tmp.write(literalCount);
                        this.tmp.writeShorts(data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        this.tmp.write(literalCount);
                        this.tmp.writeShorts(data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 254) {
                            this.tmp.write(0);
                            this.tmp.write(255);
                            xy2 += 254;
                            skipCount -= 254;
                        }
                        this.tmp.write(0);
                        this.tmp.write(skipCount + 1);
                        xy2 += skipCount - 1;
                    } else {
                        this.tmp.write(-repeatCount);
                        this.tmp.writeShort(v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeShorts(data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }

    public void writeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.tmpSeek.reset();
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        this.tmp.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            this.tmp.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount <= 126) continue;
                    this.tmp.write(literalCount);
                    this.tmp.writeInts24(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    this.tmp.write(literalCount);
                    this.tmp.writeInts24(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                this.tmp.write(-repeatCount);
                this.tmp.writeInt24(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeInts24(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }

    public void writeDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        this.tmpSeek.reset();
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            this.tmp.writeInt(4);
            this.tmpSeek.toOutputStream(out);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            this.tmp.writeShort(0);
        } else {
            this.tmp.writeShort(8);
            this.tmp.writeShort(ymin / scanlineStride);
            this.tmp.writeShort(0);
            this.tmp.writeShort((ymax - ymin + 1) / scanlineStride);
            this.tmp.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                this.tmp.write(1);
                this.tmp.write(-1);
                continue;
            }
            this.tmp.write(Math.min(255, skipCount + 1));
            if (skipCount > 254) {
                skipCount -= 254;
                while (skipCount > 254) {
                    this.tmp.write(0);
                    this.tmp.write(255);
                    skipCount -= 254;
                }
                this.tmp.write(0);
                this.tmp.write(skipCount + 1);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                int v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 1 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        this.tmp.write(literalCount);
                        this.tmp.writeInts24(data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        this.tmp.write(literalCount);
                        this.tmp.writeInts24(data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 254) {
                            this.tmp.write(0);
                            this.tmp.write(255);
                            xy2 += 254;
                            skipCount -= 254;
                        }
                        this.tmp.write(0);
                        this.tmp.write(skipCount + 1);
                        xy2 += skipCount - 1;
                    } else {
                        this.tmp.write(-repeatCount);
                        this.tmp.writeInt24(v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeInts24(data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }

    public void writeKey32(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        this.tmpSeek.reset();
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        this.tmp.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            this.tmp.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount <= 126) continue;
                    this.tmp.write(literalCount);
                    this.tmp.writeInts(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    this.tmp.write(literalCount);
                    this.tmp.writeInts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                this.tmp.write(-repeatCount);
                this.tmp.writeInt(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeInts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }

    public void writeDelta32(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        this.tmpSeek.reset();
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            this.tmp.writeInt(4);
            this.tmpSeek.toOutputStream(out);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = this.tmpSeek.getStreamPosition();
        this.tmp.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            this.tmp.writeShort(0);
        } else {
            this.tmp.writeShort(8);
            this.tmp.writeShort(ymin / scanlineStride);
            this.tmp.writeShort(0);
            this.tmp.writeShort((ymax - ymin + 1) / scanlineStride);
            this.tmp.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                this.tmp.write(1);
                this.tmp.write(-1);
                continue;
            }
            this.tmp.write(Math.min(255, skipCount + 1));
            if (skipCount > 254) {
                skipCount -= 254;
                while (skipCount > 254) {
                    this.tmp.write(0);
                    this.tmp.write(255);
                    skipCount -= 254;
                }
                this.tmp.write(0);
                this.tmp.write(skipCount + 1);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                int v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 1 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        this.tmp.write(literalCount);
                        this.tmp.writeInts(data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        this.tmp.write(literalCount);
                        this.tmp.writeInts(data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 254) {
                            this.tmp.write(0);
                            this.tmp.write(255);
                            xy2 += 254;
                            skipCount -= 254;
                        }
                        this.tmp.write(0);
                        this.tmp.write(skipCount + 1);
                        xy2 += skipCount - 1;
                    } else {
                        this.tmp.write(-repeatCount);
                        this.tmp.writeInt(v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                this.tmp.write(literalCount);
                this.tmp.writeInts(data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            this.tmp.write(-1);
        }
        long pos = this.tmpSeek.getStreamPosition();
        this.tmpSeek.seek(headerPos);
        this.tmp.writeInt((int)(pos - headerPos));
        this.tmpSeek.seek(pos);
        this.tmpSeek.toOutputStream(out);
    }
}

