/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.quicktime;

import ch.randelshofer.io.ImageOutputStreamAdapter;
import ch.randelshofer.media.quicktime.AppleRLEEncoder;
import ch.randelshofer.media.quicktime.DataAtomOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.sound.sampled.AudioFormat;

public class QuickTimeWriter {
    private ImageOutputStream out;
    private long streamOffset;
    private Date creationTime;
    private long movieTimeScale = 600L;
    private ArrayList<Track> tracks = new ArrayList();
    private States state = States.REALIZED;
    private WideDataAtom mdatAtom;
    private long mdatOffset;
    private CompositeAtom moovAtom;

    public QuickTimeWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.streamOffset = 0L;
    }

    public QuickTimeWriter(ImageOutputStream out) throws IOException {
        this.out = out;
        this.streamOffset = out.getStreamPosition();
    }

    public void setMovieTimeScale(long timeScale) {
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        this.movieTimeScale = timeScale;
    }

    public long getMovieTimeScale() {
        return this.movieTimeScale;
    }

    public long getMediaTimeScale(int track) {
        return this.tracks.get((int)track).mediaTimeScale;
    }

    public long getMediaDuration(int track) {
        return this.tracks.get((int)track).mediaDuration;
    }

    public long getUneditedTrackDuration(int track) {
        Track t = this.tracks.get(track);
        return t.mediaDuration * t.mediaTimeScale / this.movieTimeScale;
    }

    public long getTrackDuration(int track) {
        return this.tracks.get(track).getTrackDuration(this.movieTimeScale);
    }

    public long getMovieDuration() {
        long duration = 0L;
        for (Track t : this.tracks) {
            duration = Math.max(duration, t.getTrackDuration(this.movieTimeScale));
        }
        return duration;
    }

    public void setVideoColorTable(int track, IndexColorModel icm) {
        VideoTrack t = (VideoTrack)this.tracks.get(track);
        t.videoColorTable = icm;
    }

    public IndexColorModel getVideoColorTable(int track) {
        VideoTrack t = (VideoTrack)this.tracks.get(track);
        return t.videoColorTable;
    }

    public void setEditList(int track, Edit[] editList) {
        if (editList != null && editList.length > 0 && editList[editList.length - 1].mediaTime == -1) {
            throw new IllegalArgumentException("Edit list must not end with empty edit.");
        }
        this.tracks.get((int)track).editList = editList;
    }

    public void addVideoTrack(VideoFormat encoding, long timeScale, int width, int height) throws IOException {
        this.addVideoTrack(encoding.compressionType, encoding.compressorName, timeScale, width, height, 24, encoding.allSamplesAreSyncSamples ? 1 : 30);
    }

    public void addVideoTrack(String compressionType, String compressorName, long timeScale, int width, int height, int depth, int syncInterval) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("compressionType must be 4 characters long:" + compressionType);
        }
        if (compressorName == null || compressorName.length() < 1 || compressorName.length() > 32) {
            throw new IllegalArgumentException("compressorName must be between 1 and 32 characters long:" + compressionType);
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width and height must be greater than 0, width:" + width + " height:" + height);
        }
        VideoTrack t = new VideoTrack();
        t.mediaCompressionType = compressionType;
        t.mediaCompressorName = compressorName;
        t.mediaTimeScale = timeScale;
        t.videoWidth = width;
        t.videoHeight = height;
        t.videoDepth = depth;
        t.syncInterval = syncInterval;
        for (VideoFormat vf : VideoFormat.values()) {
            if (!vf.compressionType.equals(compressionType)) continue;
            t.videoEncoding = vf;
            break;
        }
        this.tracks.add(t);
    }

    public void addAudioTrack(AudioFormat format) throws IOException {
        String qtAudioFormat;
        boolean isCompressed;
        int frameSize;
        int frameDuration;
        int numberOfChannels;
        int sampleSizeInBits;
        long timeScale;
        double sampleRate;
        block16: {
            block17: {
                boolean bigEndian;
                block15: {
                    this.ensureStarted();
                    sampleRate = format.getSampleRate();
                    timeScale = (int)Math.floor(sampleRate);
                    sampleSizeInBits = format.getSampleSizeInBits();
                    numberOfChannels = format.getChannels();
                    bigEndian = format.isBigEndian();
                    frameDuration = (int)(format.getSampleRate() / format.getFrameRate());
                    frameSize = format.getFrameSize();
                    boolean bl = isCompressed = format.getProperty("vbr") != null && (Boolean)format.getProperty("vbr") != false;
                    if (!format.getEncoding().equals(AudioFormat.Encoding.ALAW)) break block15;
                    qtAudioFormat = "alaw";
                    if (sampleSizeInBits != 8) {
                        throw new IllegalArgumentException("Sample size of 8 for ALAW required:" + sampleSizeInBits);
                    }
                    break block16;
                }
                if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) break block17;
                switch (sampleSizeInBits) {
                    case 16: {
                        qtAudioFormat = bigEndian ? "twos" : "sowt";
                        break block16;
                    }
                    case 24: {
                        qtAudioFormat = "in24";
                        break block16;
                    }
                    case 32: {
                        qtAudioFormat = "in32";
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Sample size of 16, 24 or 32 for PCM_SIGNED required:" + sampleSizeInBits);
                    }
                }
            }
            if (format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                if (sampleSizeInBits != 8) {
                    throw new IllegalArgumentException("Sample size of 8 PCM_UNSIGNED required:" + sampleSizeInBits);
                }
                qtAudioFormat = "raw ";
            } else if (format.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                if (sampleSizeInBits != 8) {
                    throw new IllegalArgumentException("Sample size of 8 for ULAW required:" + sampleSizeInBits);
                }
                qtAudioFormat = "ulaw";
            } else if (format.getEncoding().toString().equals("MP3")) {
                qtAudioFormat = ".mp3";
            } else {
                qtAudioFormat = format.getEncoding().toString();
                if (qtAudioFormat.length() != 4) {
                    throw new IllegalArgumentException("Unsupported encoding:" + format.getEncoding());
                }
            }
        }
        this.addAudioTrack(qtAudioFormat, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize);
    }

    public void addAudioTrack(String compressionType, long timeScale, double sampleRate, int numberOfChannels, int sampleSizeInBits, boolean isCompressed, int frameDuration, int frameSize) throws IOException {
        this.ensureStarted();
        if (compressionType == null || compressionType.length() != 4) {
            throw new IllegalArgumentException("audioFormat must be 4 characters long:" + compressionType);
        }
        if (timeScale < 1L || timeScale > 0x200000000L) {
            throw new IllegalArgumentException("timeScale must be between 1 and 2^32:" + timeScale);
        }
        if (timeScale != (long)((int)Math.floor(sampleRate))) {
            throw new IllegalArgumentException("timeScale: " + timeScale + " must match integer portion of sampleRate: " + sampleRate);
        }
        if (numberOfChannels != 1 && numberOfChannels != 2) {
            throw new IllegalArgumentException("numberOfChannels must be 1 or 2: " + numberOfChannels);
        }
        if (sampleSizeInBits != 8 && sampleSizeInBits != 16) {
            throw new IllegalArgumentException("sampleSize must be 8 or 16: " + numberOfChannels);
        }
        AudioTrack t = new AudioTrack();
        t.mediaCompressionType = compressionType;
        t.mediaTimeScale = timeScale;
        t.soundSampleRate = sampleRate;
        t.soundCompressionId = isCompressed ? -2 : -1;
        t.soundNumberOfChannels = numberOfChannels;
        t.soundSampleSize = sampleSizeInBits;
        t.soundSamplesPerPacket = frameDuration;
        if (isCompressed) {
            t.soundBytesPerPacket = frameSize;
            t.soundBytesPerFrame = frameSize * numberOfChannels;
        } else {
            t.soundBytesPerPacket = frameSize / numberOfChannels;
            t.soundBytesPerFrame = frameSize;
        }
        t.soundBytesPerSample = sampleSizeInBits / 8;
        this.tracks.add(t);
    }

    public void setCompressionQuality(int track, float newValue) {
        ((VideoTrack)this.tracks.get(track)).videoQuality = newValue;
    }

    public float getCompressionQuality(int track) {
        return ((VideoTrack)this.tracks.get(track)).videoQuality;
    }

    public void setSyncInterval(int track, int i) {
        ((VideoTrack)this.tracks.get(track)).syncInterval = i;
    }

    public int getSyncInterval(int track) {
        return ((VideoTrack)this.tracks.get(track)).syncInterval;
    }

    private void ensureStarted() throws IOException {
        this.ensureOpen();
        if (this.state == States.FINISHED) {
            throw new IOException("Can not write into finished movie.");
        }
        if (this.state != States.STARTED) {
            this.creationTime = new Date();
            this.writeProlog();
            this.mdatAtom = new WideDataAtom("mdat");
            this.state = States.STARTED;
        }
    }

    public void writeFrame(int track, BufferedImage image, long duration) throws IOException {
        boolean isSync;
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration must be greater 0.");
        }
        VideoTrack t = (VideoTrack)this.tracks.get(track);
        if (t.mediaType != MediaType.VIDEO) {
            throw new IllegalArgumentException("Track " + track + " is not a video track");
        }
        if (t.videoEncoding == null) {
            throw new UnsupportedOperationException("Encoding not supported.");
        }
        this.ensureStarted();
        if (t.videoWidth != image.getWidth() || t.videoHeight != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of frame[" + this.tracks.get(track).getSampleCount() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video dimension (width=" + t.videoWidth + ", height=" + t.videoHeight + ") in track " + track + ".");
        }
        long offset = this.getRelativeStreamPosition();
        block0 : switch (t.videoEncoding) {
            case RAW: {
                WritableRaster raster;
                isSync = true;
                switch (t.videoDepth) {
                    case 8: {
                        if (image.getType() != 13) {
                            throw new IllegalArgumentException("BufferedImage type " + image.getType() + " does not match track type " + 13 + ".");
                        }
                        raster = image.getRaster();
                        int sw = raster.getSampleModel().getWidth();
                        int sh = raster.getSampleModel().getHeight();
                        Rectangle r = raster.getBounds();
                        r.x -= raster.getSampleModelTranslateX();
                        r.y -= raster.getSampleModelTranslateY();
                        DataBufferByte buf = (DataBufferByte)raster.getDataBuffer();
                        byte[] bytes = buf.getData();
                        int ymax = r.x + (r.y + r.height) * sw;
                        for (int xy = r.x + r.y * sw; xy < ymax; xy += sw) {
                            this.mdatAtom.getOutputStream().write(bytes, xy, r.width);
                        }
                        break block0;
                    }
                    case 24: {
                        raster = image.getRaster();
                        int[] rgb = new int[t.videoWidth * 3];
                        byte[] bytes = new byte[t.videoWidth * 3];
                        for (int y = 0; y < t.videoHeight; ++y) {
                            rgb = raster.getPixels(0, y, t.videoWidth, 1, rgb);
                            int n = t.videoWidth * 3;
                            for (int k = 0; k < n; ++k) {
                                bytes[k] = (byte)rgb[k];
                            }
                            this.mdatAtom.getOutputStream().write(bytes);
                        }
                        break block0;
                    }
                    default: {
                        throw new UnsupportedOperationException("Encoding not supported.");
                    }
                }
            }
            case JPG: {
                isSync = true;
                ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
                ImageWriteParam iwParam = iw.getDefaultWriteParam();
                iwParam.setCompressionMode(2);
                iwParam.setCompressionQuality(t.videoQuality);
                MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(this.mdatAtom.getOutputStream());
                iw.setOutput(imgOut);
                IIOImage img = new IIOImage(image, null, null);
                iw.write(null, img, iwParam);
                iw.dispose();
                break;
            }
            case PNG: {
                isSync = true;
                ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/png").next();
                ImageWriteParam iwParam = iw.getDefaultWriteParam();
                MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(this.mdatAtom.getOutputStream());
                iw.setOutput(imgOut);
                IIOImage img = new IIOImage(image, null, null);
                iw.write(null, img, iwParam);
                iw.dispose();
                break;
            }
            case RLE: {
                isSync = t.previousData == null || t.syncInterval != 0 && t.sampleCount % (long)t.syncInterval == 0L;
                WritableRaster raster = image.getRaster();
                int sw = raster.getSampleModel().getWidth();
                int sh = raster.getSampleModel().getHeight();
                Rectangle r = raster.getBounds();
                r.x -= raster.getSampleModelTranslateX();
                r.y -= raster.getSampleModelTranslateY();
                if (t.encoder == null) {
                    t.encoder = new AppleRLEEncoder();
                }
                AppleRLEEncoder enc = t.encoder;
                switch (t.videoDepth) {
                    case 16: {
                        DataBufferUShort buf = (DataBufferUShort)raster.getDataBuffer();
                        short[] data = buf.getData();
                        if (isSync) {
                            enc.writeKey16(this.mdatAtom.getOutputStream(), data, r.width, r.height, r.x + r.y * sw, sw);
                        } else {
                            enc.writeDelta16(this.mdatAtom.getOutputStream(), data, (short[])t.previousData, r.width, r.height, r.x + r.y * sw, sw);
                        }
                        if (t.previousData == null) {
                            t.previousData = new short[data.length];
                        }
                        System.arraycopy(data, 0, t.previousData, 0, data.length);
                        break block0;
                    }
                    case 24: {
                        DataBufferInt buf = (DataBufferInt)raster.getDataBuffer();
                        int[] data = buf.getData();
                        if (isSync) {
                            enc.writeKey24(this.mdatAtom.getOutputStream(), data, r.width, r.height, r.x + r.y * sw, sw);
                        } else {
                            enc.writeDelta24(this.mdatAtom.getOutputStream(), data, (int[])t.previousData, r.width, r.height, r.x + r.y * sw, sw);
                        }
                        if (t.previousData == null) {
                            t.previousData = new int[data.length];
                        }
                        System.arraycopy(data, 0, t.previousData, 0, data.length);
                        break block0;
                    }
                    case 32: {
                        DataBufferInt buf = (DataBufferInt)raster.getDataBuffer();
                        int[] data = buf.getData();
                        if (isSync) {
                            enc.writeKey32(this.mdatAtom.getOutputStream(), data, image.getWidth(), image.getHeight(), 0, image.getWidth());
                        } else {
                            enc.writeDelta32(this.mdatAtom.getOutputStream(), data, (int[])t.previousData, image.getWidth(), image.getHeight(), 0, image.getWidth());
                        }
                        if (t.previousData == null) {
                            t.previousData = new int[data.length];
                        }
                        System.arraycopy(data, 0, t.previousData, 0, data.length);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Encoding not supported.");
            }
            default: {
                throw new UnsupportedOperationException("Encoding not supported.");
            }
        }
        long length = this.getRelativeStreamPosition() - offset;
        t.addSample(new Sample(duration, offset, length), 1, isSync);
    }

    public void writeSample(int track, File file, long duration) throws IOException {
        this.writeSample(track, file, duration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSample(int track, File file, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.writeSample(track, in, duration, isSync);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void writeSample(int track, InputStream in, long duration) throws IOException {
        this.writeSample(track, in, duration, true);
    }

    public void writeSample(int track, InputStream in, long duration, boolean isSync) throws IOException {
        int len;
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        Track t = this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) != -1) {
            ((OutputStream)mdatOut).write(buf, 0, len);
        }
        long length = this.getRelativeStreamPosition() - offset;
        t.addSample(new Sample(duration, offset, length), 1, isSync);
    }

    public void writeSample(int track, byte[] data, long duration) throws IOException {
        this.ensureStarted();
        this.writeSample(track, data, 0, data.length, duration, true);
    }

    public void writeSample(int track, byte[] data, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        this.writeSample(track, data, 0, data.length, duration, isSync);
    }

    public void writeSample(int track, byte[] data, int off, int len, long duration) throws IOException {
        this.ensureStarted();
        this.writeSample(track, data, off, len, duration, true);
    }

    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be greater 0");
        }
        Track t = this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        t.addSample(new Sample(duration, offset, len), 1, isSync);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int sampleDuration) throws IOException {
        this.writeSamples(track, sampleCount, data, 0, data.length, sampleDuration, true);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, int sampleDuration) throws IOException {
        this.writeSamples(track, sampleCount, data, off, len, sampleDuration, true);
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, int sampleDuration, boolean isSync) throws IOException {
        this.ensureStarted();
        if (sampleDuration <= 0) {
            throw new IllegalArgumentException("sampleDuration must be greater 0, sampleDuration=" + sampleDuration);
        }
        if (sampleCount <= 0) {
            throw new IllegalArgumentException("sampleCount must be greater 0, sampleCount=" + sampleCount);
        }
        if (len % sampleCount != 0) {
            throw new IllegalArgumentException("len must be divisable by sampleCount len=" + len + " sampleCount=" + sampleCount);
        }
        Track t = this.tracks.get(track);
        this.ensureOpen();
        this.ensureStarted();
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write(data, off, len);
        int sampleLength = len / sampleCount;
        Sample first = new Sample(sampleDuration, offset, sampleLength);
        Sample last = new Sample(sampleDuration, offset + (long)(sampleLength * (sampleCount - 1)), sampleLength);
        t.addChunk(new Chunk(first, last, sampleCount, 1), isSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.state == States.STARTED) {
                this.finish();
            }
        }
        finally {
            if (this.state != States.CLOSED) {
                this.out.close();
                this.state = States.CLOSED;
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            int n = this.tracks.size();
            for (int i = 0; i < n; ++i) {
            }
            this.mdatAtom.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    private void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    private void writeProlog() throws IOException {
        DataAtom ftypAtom = new DataAtom("ftyp");
        DataAtomOutputStream d = ftypAtom.getOutputStream();
        d.writeType("qt  ");
        d.writeBCD4(2005);
        d.writeBCD2(3);
        d.writeBCD2(0);
        d.writeType("qt  ");
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        ftypAtom.finish();
    }

    private void writeEpilog() throws IOException {
        Date modificationTime = new Date();
        long duration = this.getMovieDuration();
        this.moovAtom = new CompositeAtom("moov");
        DataAtom leaf = new DataAtom("mvhd");
        this.moovAtom.add(leaf);
        DataAtomOutputStream d = leaf.getOutputStream();
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeByte(0);
        d.writeMacTimestamp(this.creationTime);
        d.writeMacTimestamp(modificationTime);
        d.writeUInt(this.movieTimeScale);
        d.writeUInt(duration);
        d.writeFixed16D16(1.0);
        d.writeShort(256);
        d.write(new byte[10]);
        d.writeFixed16D16(1.0);
        d.writeFixed16D16(0.0);
        d.writeFixed2D30(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed16D16(1.0);
        d.writeFixed2D30(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed16D16(0.0);
        d.writeFixed2D30(1.0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeUInt(this.tracks.size() + 1);
        int n = this.tracks.size();
        for (int i = 0; i < n; ++i) {
            Track t = this.tracks.get(i);
            t.writeTrackAtoms(i, this.moovAtom, modificationTime);
        }
        this.moovAtom.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toWebOptimizedMovie(File outputFile, boolean compressHeader) throws IOException {
        this.finish();
        long originalMdatOffset = this.mdatAtom.getOffset();
        CompositeAtom originalMoovAtom = this.moovAtom;
        this.mdatOffset = 0L;
        ImageOutputStream originalOut = this.out;
        try {
            int read;
            Object buf;
            this.out = null;
            if (compressHeader) {
                buf = new ByteArrayOutputStream();
                int maxIteration = 5;
                long compressionHeadersSize = 48L;
                long headerSize = 0L;
                long freeSize = 0L;
                while (true) {
                    this.mdatOffset = compressionHeadersSize + headerSize + freeSize;
                    ((ByteArrayOutputStream)buf).reset();
                    DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)buf);
                    this.out = new MemoryCacheImageOutputStream(deflater);
                    this.writeEpilog();
                    this.out.close();
                    deflater.close();
                    if ((long)((ByteArrayOutputStream)buf).size() <= headerSize + freeSize || --maxIteration <= 0) break;
                    if (headerSize != 0L) {
                        freeSize = Math.max(freeSize, (long)((ByteArrayOutputStream)buf).size() - headerSize - freeSize);
                    }
                    headerSize = ((ByteArrayOutputStream)buf).size();
                }
                freeSize = headerSize + freeSize - (long)((ByteArrayOutputStream)buf).size();
                headerSize = ((ByteArrayOutputStream)buf).size();
                if (maxIteration < 0 || ((ByteArrayOutputStream)buf).size() == 0) {
                    compressHeader = false;
                    System.err.println("WARNING QuickTimeWriter failed to compress header.");
                } else {
                    this.out = new FileImageOutputStream(outputFile);
                    this.writeProlog();
                    DataAtomOutputStream daos = new DataAtomOutputStream(new ImageOutputStreamAdapter(this.out));
                    daos.writeUInt(headerSize + 40L);
                    daos.writeType("moov");
                    daos.writeUInt(headerSize + 32L);
                    daos.writeType("cmov");
                    daos.writeUInt(12L);
                    daos.writeType("dcom");
                    daos.writeType("zlib");
                    daos.writeUInt(headerSize + 12L);
                    daos.writeType("cmvd");
                    daos.writeUInt(originalMoovAtom.size());
                    daos.write(((ByteArrayOutputStream)buf).toByteArray());
                    daos.writeUInt(freeSize + 8L);
                    daos.writeType("free");
                    int i = 0;
                    while ((long)i < freeSize) {
                        daos.write(0);
                        ++i;
                    }
                }
            }
            if (!compressHeader) {
                this.out = new FileImageOutputStream(outputFile);
                this.mdatOffset = this.moovAtom.size();
                this.writeProlog();
                this.writeEpilog();
            }
            buf = new byte[4096];
            originalOut.seek(originalMdatOffset);
            long n = this.mdatAtom.size();
            for (long count = 0L; count < n; count += (long)read) {
                read = originalOut.read((byte[])buf, 0, (int)Math.min((long)((Object)buf).length, n - count));
                this.out.write((byte[])buf, 0, read);
            }
            this.out.close();
        }
        finally {
            this.mdatOffset = 0L;
            this.moovAtom = originalMoovAtom;
            this.out = originalOut;
        }
    }

    private class WideDataAtom
    extends Atom {
        private DataAtomOutputStream data;
        private boolean finished;

        public WideDataAtom(String type) throws IOException {
            super(type);
            QuickTimeWriter.this.out.writeLong(0L);
            QuickTimeWriter.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out)){

                @Override
                public void flush() throws IOException {
                }
            };
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("Atom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long pointer = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                long finishedSize = this.size();
                if (finishedSize <= 0xFFFFFFFFL) {
                    headerData.writeUInt(8L);
                    headerData.writeType("wide");
                    headerData.writeUInt(finishedSize - 8L);
                    headerData.writeType(this.type);
                } else {
                    headerData.writeInt(1);
                    headerData.writeType(this.type);
                    headerData.writeLong(finishedSize - 8L);
                }
                QuickTimeWriter.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 16L + this.data.size();
        }
    }

    private class DataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public DataAtom(String name) throws IOException {
            super(name);
            QuickTimeWriter.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataAtom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                headerData.writeUInt(this.size());
                headerData.writeType(this.type);
                QuickTimeWriter.this.seekRelative(pointer);
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    private class CompositeAtom
    extends DataAtom {
        private LinkedList<Atom> children;

        public CompositeAtom(String type) throws IOException {
            super(type);
            this.children = new LinkedList();
        }

        public void add(Atom child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = QuickTimeWriter.this.getRelativeStreamPosition();
                QuickTimeWriter.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(QuickTimeWriter.this.out));
                headerData.writeInt((int)this.size());
                headerData.writeType(this.type);
                for (Atom child : this.children) {
                    child.finish();
                }
                QuickTimeWriter.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 8L + this.data.size();
            for (Atom child : this.children) {
                length += child.size();
            }
            return length;
        }
    }

    private abstract class Atom {
        protected String type;
        protected long offset;

        public Atom(String type) throws IOException {
            this.type = type;
            this.offset = QuickTimeWriter.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    private static class Chunk
    extends Group {
        private int sampleDescriptionId;

        public Chunk(Sample firstSample, int sampleDescriptionId) {
            super(firstSample);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public Chunk(Sample firstSample, Sample lastSample, int sampleCount, int sampleDescriptionId) {
            super(firstSample, lastSample, sampleCount);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public boolean maybeAddSample(Sample sample, int sampleDescriptionId) {
            if (sampleDescriptionId == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    private static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(Sample firstSample) {
            super(firstSample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    private static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(Sample firstSample) {
            super(firstSample);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    private static abstract class Group {
        protected Sample firstSample;
        protected Sample lastSample;
        protected long sampleCount;
        private static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(Sample firstSample) {
            this.firstSample = this.lastSample = firstSample;
            this.sampleCount = 1L;
        }

        protected Group(Sample firstSample, Sample lastSample, long sampleCount) {
            this.firstSample = firstSample;
            this.lastSample = lastSample;
            this.sampleCount = sampleCount;
            if (sampleCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(Sample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }

    private static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    private static enum States {
        REALIZED,
        STARTED,
        FINISHED,
        CLOSED;

    }

    private class AudioTrack
    extends Track {
        private int soundNumberOfChannels;
        private int soundSampleSize;
        private int soundCompressionId;
        private long soundSamplesPerPacket;
        private int soundBytesPerPacket;
        private int soundBytesPerFrame;
        private int soundBytesPerSample;
        private double soundSampleRate;
        private byte[] stsdExtensions;

        public AudioTrack() {
            super(MediaType.AUDIO);
            this.stsdExtensions = new byte[0];
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom minfAtom) throws IOException {
            DataAtom leaf = new DataAtom("smhd");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeFixed8D8(0.0f);
            d.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeUInt(52 + this.stsdExtensions.length);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeUShort(1);
            d.writeUShort(1);
            d.writeUShort(0);
            d.writeUInt(0L);
            d.writeUShort(this.soundNumberOfChannels);
            d.writeUShort(this.soundSampleSize);
            d.writeUShort(this.soundCompressionId);
            d.writeUShort(0);
            d.writeFixed16D16(this.soundSampleRate);
            d.writeUInt(this.soundSamplesPerPacket);
            d.writeUInt(this.soundBytesPerPacket);
            d.writeUInt(this.soundBytesPerFrame);
            d.writeUInt(this.soundBytesPerSample);
            d.write(this.stsdExtensions);
        }
    }

    private class VideoTrack
    extends Track {
        private VideoFormat videoEncoding;
        private float videoQuality;
        private int videoWidth;
        private int videoHeight;
        private int videoDepth;
        private IndexColorModel videoColorTable;
        private AppleRLEEncoder encoder;
        private Object previousData;
        private int syncInterval;

        public VideoTrack() {
            super(MediaType.VIDEO);
            this.videoQuality = 0.97f;
            this.videoWidth = -1;
            this.videoHeight = -1;
            this.videoDepth = -1;
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom minfAtom) throws IOException {
            DataAtom leaf = new DataAtom("vmhd");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(1);
            d.writeShort(64);
            d.writeUShort(0);
            d.writeUShort(0);
            d.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            CompositeAtom leaf = new CompositeAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeInt(86);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeShort(1);
            d.writeShort(0);
            d.writeShort(0);
            d.writeType("java");
            d.writeInt(0);
            d.writeInt(512);
            d.writeUShort(this.videoWidth);
            d.writeUShort(this.videoHeight);
            d.writeFixed16D16(72.0);
            d.writeFixed16D16(72.0);
            d.writeInt(0);
            d.writeShort(1);
            d.writePString(this.mediaCompressorName, 32);
            d.writeShort(this.videoDepth);
            d.writeShort(this.videoColorTable == null ? -1 : 0);
            if (this.videoColorTable != null) {
                this.writeColorTableAtom(leaf);
            }
        }

        protected void writeColorTableAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("ctab");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.writeUInt(0L);
            d.writeUShort(32768);
            d.writeUShort(this.videoColorTable.getMapSize() - 1);
            int n = this.videoColorTable.getMapSize();
            for (int i = 0; i < n; ++i) {
                d.writeUShort(0);
                d.writeUShort(this.videoColorTable.getRed(i) << 8 | this.videoColorTable.getRed(i));
                d.writeUShort(this.videoColorTable.getGreen(i) << 8 | this.videoColorTable.getGreen(i));
                d.writeUShort(this.videoColorTable.getBlue(i) << 8 | this.videoColorTable.getBlue(i));
            }
        }
    }

    private abstract class Track {
        final MediaType mediaType;
        protected long mediaTimeScale = 600L;
        protected String mediaCompressionType;
        protected String mediaCompressorName;
        protected ArrayList<Chunk> chunks = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected ArrayList<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected long mediaDuration = 0L;
        protected Edit[] editList;

        public Track(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public void addSample(Sample sample, int sampleDescriptionId, boolean isSyncSample) {
            this.mediaDuration += sample.duration;
            ++this.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    this.syncSamples.add(this.sampleCount);
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddSample(sample)) {
                this.timeToSamples.add(new TimeToSampleGroup(sample));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddSample(sample)) {
                this.sampleSizes.add(new SampleSizeGroup(sample));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddSample(sample, sampleDescriptionId)) {
                this.chunks.add(new Chunk(sample, sampleDescriptionId));
            }
        }

        public void addChunk(Chunk chunk, boolean isSyncSample) {
            this.mediaDuration += chunk.firstSample.duration * chunk.sampleCount;
            this.sampleCount += chunk.sampleCount;
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddChunk(chunk)) {
                this.timeToSamples.add(new TimeToSampleGroup(chunk));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddChunk(chunk)) {
                this.sampleSizes.add(new SampleSizeGroup(chunk));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddChunk(chunk)) {
                this.chunks.add(chunk);
            }
        }

        public boolean isEmpty() {
            return this.sampleCount == 0L;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getTrackDuration(long movieTimeScale) {
            if (this.editList == null || this.editList.length == 0) {
                return this.mediaDuration * movieTimeScale / this.mediaTimeScale;
            }
            long duration = 0L;
            for (int i = 0; i < this.editList.length; ++i) {
                duration += (long)this.editList[i].trackDuration;
            }
            return duration;
        }

        private void writeTrackAtoms(int trackIndex, CompositeAtom moovAtom, Date modificationTime) throws IOException {
            CompositeAtom trakAtom = new CompositeAtom("trak");
            moovAtom.add(trakAtom);
            DataAtom leaf = new DataAtom("tkhd");
            trakAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(15);
            d.writeMacTimestamp(QuickTimeWriter.this.creationTime);
            d.writeMacTimestamp(modificationTime);
            d.writeInt(trackIndex + 1);
            d.writeInt(0);
            d.writeUInt(this.getTrackDuration(QuickTimeWriter.this.movieTimeScale));
            d.writeLong(0L);
            d.writeShort(0);
            d.writeShort(0);
            d.writeFixed8D8(this.mediaType == MediaType.AUDIO ? 1.0f : 0.0f);
            d.writeShort(0);
            d.writeFixed16D16(1.0);
            d.writeFixed16D16(0.0);
            d.writeFixed2D30(0.0);
            d.writeFixed16D16(0.0);
            d.writeFixed16D16(1.0);
            d.writeFixed2D30(0.0);
            d.writeFixed16D16(0.0);
            d.writeFixed16D16(0.0);
            d.writeFixed2D30(1.0);
            d.writeFixed16D16(this.mediaType == MediaType.VIDEO ? (double)((VideoTrack)this).videoWidth : 0.0);
            d.writeFixed16D16(this.mediaType == MediaType.VIDEO ? (double)((VideoTrack)this).videoHeight : 0.0);
            CompositeAtom edtsAtom = new CompositeAtom("edts");
            trakAtom.add(edtsAtom);
            leaf = new DataAtom("elst");
            edtsAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            Edit[] elist = this.editList;
            if (elist == null || elist.length == 0) {
                d.writeUInt(1L);
                d.writeUInt(this.getTrackDuration(QuickTimeWriter.this.movieTimeScale));
                d.writeUInt(0L);
                d.writeFixed16D16(1.0);
            } else {
                d.writeUInt(elist.length);
                for (int i = 0; i < elist.length; ++i) {
                    d.writeUInt(elist[i].trackDuration);
                    d.writeUInt(elist[i].mediaTime);
                    d.writeUInt(elist[i].mediaRate);
                }
            }
            CompositeAtom mdiaAtom = new CompositeAtom("mdia");
            trakAtom.add(mdiaAtom);
            leaf = new DataAtom("mdhd");
            mdiaAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeMacTimestamp(QuickTimeWriter.this.creationTime);
            d.writeMacTimestamp(modificationTime);
            d.writeUInt(this.mediaTimeScale);
            d.writeUInt(this.mediaDuration);
            d.writeShort(0);
            d.writeShort(0);
            leaf = new DataAtom("hdlr");
            mdiaAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeType("mhlr");
            d.writeType(this.mediaType == MediaType.VIDEO ? "vide" : "soun");
            if (this.mediaType == MediaType.AUDIO) {
                d.writeType("appl");
            } else {
                d.writeUInt(0L);
            }
            d.writeUInt(this.mediaType == MediaType.AUDIO ? 0x10000000L : 0L);
            d.writeUInt(this.mediaType == MediaType.AUDIO ? 65941L : 0L);
            d.writePString(this.mediaType == MediaType.AUDIO ? "Apple Sound Media Handler" : "");
            this.writeMediaInformationAtoms(mdiaAtom);
        }

        private void writeMediaInformationAtoms(CompositeAtom mdiaAtom) throws IOException {
            CompositeAtom minfAtom = new CompositeAtom("minf");
            mdiaAtom.add(minfAtom);
            this.writeMediaInformationHeaderAtom(minfAtom);
            DataAtom leaf = new DataAtom("hdlr");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeType("dhlr");
            d.writeType("alis");
            if (this.mediaType == MediaType.AUDIO) {
                d.writeType("appl");
            } else {
                d.writeUInt(0L);
            }
            d.writeUInt(this.mediaType == MediaType.AUDIO ? 0x10000001L : 0L);
            d.writeInt(this.mediaType == MediaType.AUDIO ? 65967 : 0);
            d.writePString("Apple Alias Data Handler");
            CompositeAtom dinfAtom = new CompositeAtom("dinf");
            minfAtom.add(dinfAtom);
            leaf = new DataAtom("dref");
            dinfAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeInt(12);
            d.writeType("alis");
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(1);
            this.writeSampleTableAtoms(minfAtom);
        }

        protected abstract void writeMediaInformationHeaderAtom(CompositeAtom var1) throws IOException;

        protected abstract void writeSampleDescriptionAtom(CompositeAtom var1) throws IOException;

        private void writeSampleTableAtoms(CompositeAtom minfAtom) throws IOException {
            int sampleUnit;
            CompositeAtom stblAtom = new CompositeAtom("stbl");
            minfAtom.add(stblAtom);
            this.writeSampleDescriptionAtom(stblAtom);
            DataAtom leaf = new DataAtom("stts");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeUInt(this.timeToSamples.size());
            for (TimeToSampleGroup tts : this.timeToSamples) {
                d.writeUInt(tts.getSampleCount());
                d.writeUInt(tts.getSampleDuration());
            }
            leaf = new DataAtom("stsc");
            stblAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            int entryCount = 0;
            long previousSampleCount = -1L;
            long previousSampleDescriptionId = -1L;
            for (Chunk c : this.chunks) {
                if (c.sampleCount == previousSampleCount && (long)c.sampleDescriptionId == previousSampleDescriptionId) continue;
                previousSampleCount = c.sampleCount;
                previousSampleDescriptionId = c.sampleDescriptionId;
                ++entryCount;
            }
            d.writeInt(entryCount);
            int firstChunk = 1;
            previousSampleCount = -1L;
            previousSampleDescriptionId = -1L;
            for (Chunk c : this.chunks) {
                if (c.sampleCount != previousSampleCount || (long)c.sampleDescriptionId != previousSampleDescriptionId) {
                    previousSampleCount = c.sampleCount;
                    previousSampleDescriptionId = c.sampleDescriptionId;
                    d.writeUInt(firstChunk);
                    d.writeUInt(c.sampleCount);
                    d.writeInt(c.sampleDescriptionId);
                }
                ++firstChunk;
            }
            if (this.syncSamples != null) {
                leaf = new DataAtom("stss");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.syncSamples.size());
                for (Long number : this.syncSamples) {
                    d.writeUInt(number);
                }
            }
            leaf = new DataAtom("stsz");
            stblAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            int n = sampleUnit = this.mediaType == MediaType.AUDIO && ((AudioTrack)this).soundCompressionId != -2 ? ((AudioTrack)this).soundSampleSize / 8 * ((AudioTrack)this).soundNumberOfChannels : 1;
            if (this.sampleSizes.size() == 1) {
                d.writeUInt(this.sampleSizes.get(0).getSampleLength() / (long)sampleUnit);
                d.writeUInt(this.sampleSizes.get(0).getSampleCount());
            } else {
                d.writeUInt(0L);
                long count = 0L;
                for (SampleSizeGroup s : this.sampleSizes) {
                    count += s.sampleCount;
                }
                d.writeUInt(count);
                for (SampleSizeGroup s : this.sampleSizes) {
                    long sampleSize = s.getSampleLength() / (long)sampleUnit;
                    int i = 0;
                    while ((long)i < s.sampleCount) {
                        d.writeUInt(sampleSize);
                        ++i;
                    }
                }
            }
            if (this.chunks.isEmpty() || this.chunks.get(this.chunks.size() - 1).getChunkOffset() <= 0xFFFFFFFFL) {
                leaf = new DataAtom("stco");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.chunks.size());
                for (Chunk c : this.chunks) {
                    d.writeUInt(c.getChunkOffset() + QuickTimeWriter.this.mdatOffset);
                }
            } else {
                leaf = new DataAtom("co64");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.chunks.size());
                for (Chunk c : this.chunks) {
                    d.writeLong(c.getChunkOffset());
                }
            }
        }
    }

    private static enum MediaType {
        VIDEO,
        AUDIO;

    }

    public static enum VideoFormat {
        RAW("raw ", "None", true),
        JPG("jpeg", "Photo - JPEG", true),
        PNG("png ", "PNG", true),
        RLE("rle ", "Animation", false);

        private String compressionType;
        private String compressorName;
        private boolean allSamplesAreSyncSamples;

        private VideoFormat(String compressionType, String compressorName, boolean allSamplesAreSyncSamples) {
            this.compressionType = compressionType;
            this.compressorName = compressorName;
            this.allSamplesAreSyncSamples = allSamplesAreSyncSamples;
        }
    }

    public static class Edit {
        public int trackDuration;
        public int mediaTime;
        public int mediaRate;

        public Edit(int trackDuration, int mediaTime, double mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = (int)(mediaRate * 65536.0);
        }

        public Edit(int trackDuration, int mediaTime, int mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
        }
    }
}

