/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import java.awt.Insets;
import java.util.ArrayList;
import net.disy.commons.swing.layout.grid.GridCell;
import net.disy.commons.swing.layout.util.GridCellSize;
import net.disy.commons.swing.layout.util.GridCellSizeList;

public class Grid {
    private final GridCellSizeList rowSizes;
    private final GridCellSizeList columnSizes;
    private final GridCell[] cells;

    public Grid(GridCellSizeList rowSizes, GridCellSizeList columnSizes, GridCell[] cells) {
        this.rowSizes = rowSizes;
        this.columnSizes = columnSizes;
        this.cells = cells;
    }

    public GridCellSize getColumn(int columnIndex) {
        return this.columnSizes.get(columnIndex);
    }

    public GridCellSize getRow(int rowIndex) {
        return this.rowSizes.get(rowIndex);
    }

    public int getRowCount() {
        return this.rowSizes.size();
    }

    public int getCellCount() {
        return this.cells.length;
    }

    public GridCell getCell(int i) {
        return this.cells[i];
    }

    public int getColumnCount() {
        return this.columnSizes.size();
    }

    public GridCellSizeList getColumns() {
        return this.columnSizes;
    }

    public GridCellSizeList getRows() {
        return this.rowSizes;
    }

    public void makeColumnsEqualWidth() {
        int i;
        int i2;
        int minimumColumnWidth = 0;
        for (i2 = 0; i2 < this.columnSizes.size(); ++i2) {
            if (this.columnSizes.get(i2).getMinimumSize() <= minimumColumnWidth) continue;
            minimumColumnWidth = this.columnSizes.get(i2).getMinimumSize();
        }
        for (i2 = 0; i2 < this.columnSizes.size(); ++i2) {
            this.columnSizes.get(i2).setMinimumSize(minimumColumnWidth);
        }
        int preferredColumnWidth = 0;
        for (i = 0; i < this.columnSizes.size(); ++i) {
            if (this.columnSizes.get(i).getPreferredSize() <= preferredColumnWidth) continue;
            preferredColumnWidth = this.columnSizes.get(i).getPreferredSize();
        }
        for (i = 0; i < this.columnSizes.size(); ++i) {
            this.columnSizes.get(i).setPreferredSize(preferredColumnWidth);
        }
    }

    public int getTotalMinimumWidth(int horizontalSpacing, Insets insets) {
        int totalWidth = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            GridCellSize column = this.getColumn(i);
            totalWidth += column.getMinimumSize();
        }
        if (this.getColumnCount() > 0) {
            totalWidth += (this.getColumnCount() - 1) * horizontalSpacing;
        }
        return totalWidth += insets.left + insets.right;
    }

    public int getTotalPreferredWidth(int horizontalSpacing, Insets insets) {
        int totalWidth = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            GridCellSize column = this.getColumn(i);
            totalWidth += column.getPreferredSize();
        }
        if (this.getColumnCount() > 0) {
            totalWidth += (this.getColumnCount() - 1) * horizontalSpacing;
        }
        return totalWidth += insets.left + insets.right;
    }

    public int getTotalWidth(int horizontalSpacing, Insets insets) {
        int totalWidth = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            GridCellSize column = this.getColumn(i);
            totalWidth += column.getSize();
        }
        if (this.getColumnCount() > 0) {
            totalWidth += (this.getColumnCount() - 1) * horizontalSpacing;
        }
        return totalWidth += insets.left + insets.right;
    }

    public int getTotalMinimumHeight(int verticalSpacing, Insets insets) {
        int totalHeight = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            GridCellSize row = this.getRow(i);
            totalHeight += row.getMinimumSize();
        }
        if (this.getRowCount() > 0) {
            totalHeight += (this.getRowCount() - 1) * verticalSpacing;
        }
        return totalHeight += insets.top + insets.bottom;
    }

    public int getTotalPreferredHeight(int verticalSpacing, Insets insets) {
        int totalHeight = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            GridCellSize row = this.getRow(i);
            totalHeight += row.getPreferredSize();
        }
        if (this.getRowCount() > 0) {
            totalHeight += (this.getRowCount() - 1) * verticalSpacing;
        }
        return totalHeight += insets.top + insets.bottom;
    }

    public int getTotalHeight(int verticalSpacing, Insets insets) {
        int totalHeight = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            GridCellSize row = this.getRow(i);
            totalHeight += row.getSize();
        }
        if (this.getRowCount() > 0) {
            totalHeight += (this.getRowCount() - 1) * verticalSpacing;
        }
        return totalHeight += insets.top + insets.bottom;
    }

    public GridCellSizeList getGrabbingColumnSizes() {
        return this.getGrabbingColumnSizes(0, this.getColumnCount());
    }

    public GridCellSizeList getGrabbingColumnSizes(int startIndex, int span) {
        ArrayList<GridCellSize> grabbingColumns = new ArrayList<GridCellSize>();
        for (int i = startIndex; i < startIndex + span; ++i) {
            if (!this.getColumn(i).isGrabExcessSpace()) continue;
            grabbingColumns.add(this.getColumn(i));
        }
        return new GridCellSizeList(grabbingColumns.toArray(new GridCellSize[grabbingColumns.size()]));
    }

    public GridCellSizeList getNonGrabbingColumnSizes() {
        ArrayList<GridCellSize> nonGrabbingColumns = new ArrayList<GridCellSize>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i).isGrabExcessSpace()) continue;
            nonGrabbingColumns.add(this.getColumn(i));
        }
        return new GridCellSizeList(nonGrabbingColumns.toArray(new GridCellSize[nonGrabbingColumns.size()]));
    }

    public GridCellSizeList getGrabbingRowSizes() {
        return this.getGrabbingRowSizes(0, this.getRowCount());
    }

    public GridCellSizeList getGrabbingRowSizes(int startIndex, int span) {
        ArrayList<GridCellSize> grabbingRows = new ArrayList<GridCellSize>();
        for (int i = startIndex; i < startIndex + span; ++i) {
            if (!this.getRow(i).isGrabExcessSpace()) continue;
            grabbingRows.add(this.getRow(i));
        }
        return new GridCellSizeList(grabbingRows.toArray(new GridCellSize[grabbingRows.size()]));
    }

    public GridCellSizeList getNonGrabbingRowSizes() {
        ArrayList<GridCellSize> nonGrabbingRows = new ArrayList<GridCellSize>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getRow(i).isGrabExcessSpace()) continue;
            nonGrabbingRows.add(this.getRow(i));
        }
        return new GridCellSizeList(nonGrabbingRows.toArray(new GridCellSize[nonGrabbingRows.size()]));
    }
}

