/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.toolbar;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import net.disy.commons.swing.action.ActionWidgetFactory;
import net.disy.commons.swing.action.SmartToggleAction;
import net.disy.commons.swing.component.VerticalLine;

public class ToolBarUtilities {
    public static final Insets TOOLBAR_MARGIN = new Insets(1, 1, 1, 1);
    private static final Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);

    public static AbstractButton createToolBarButton(Action action) {
        AbstractButton button = action instanceof SmartToggleAction ? ActionWidgetFactory.createToggleButton((SmartToggleAction)action) : new JButton();
        button.setAction(action);
        ToolBarUtilities.configureToolBarButton(button);
        return button;
    }

    public static void configureToolBarButton(AbstractButton button) {
        button.setFocusPainted(false);
        button.setMargin(TOOLBAR_BUTTON_MARGIN);
        if (button.getToolTipText() == null) {
            button.setToolTipText(button.getText());
        }
        if (button.getIcon() != null) {
            button.setText(null);
        }
    }

    public static JToolBar createEmptyToolBar() {
        JToolBar toolBar = new JToolBar(){

            @Override
            public Component add(Component c) {
                if (c instanceof JToolBar) {
                    JToolBar addedToolBar = (JToolBar)c;
                    addedToolBar.setBorder(BorderFactory.createEmptyBorder());
                    addedToolBar.setMargin(new Insets(0, 0, 0, 0));
                    addedToolBar.putClientProperty("Plastic.is3D", false);
                    addedToolBar.setOpaque(false);
                }
                return super.add(c);
            }

            @Override
            public void addSeparator() {
                super.add(new VerticalLine());
            }
        };
        toolBar.setLayout(new FlowLayout(0, 0, 0));
        ToolBarUtilities.setToolBarProperties(toolBar);
        return toolBar;
    }

    public static void setToolBarProperties(JToolBar toolBar) {
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        toolBar.setMargin(TOOLBAR_MARGIN);
        toolBar.setRollover(true);
    }

    public static void addToolBarButton(JToolBar toolBar, Action action) {
        toolBar.add(ToolBarUtilities.createToolBarButton(action));
    }
}

