/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.ui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.ui.IObjectUi;

public class ObjectUiTableCellRenderer
extends DefaultTableCellRenderer {
    private final IObjectUi objectUi;
    private final int alignment;

    public ObjectUiTableCellRenderer(IObjectUi objectUi) {
        this(objectUi, 2);
    }

    public ObjectUiTableCellRenderer(IObjectUi objectUi, int alignment) {
        Ensure.ensureArgumentNotNull(objectUi);
        this.objectUi = objectUi;
        this.alignment = alignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setIcon(this.objectUi.getIcon(value));
        this.setText(this.objectUi.getLabel(value));
        this.setToolTipText(this.objectUi.getToolTipText(value));
        this.setHorizontalAlignment(this.alignment);
        return this;
    }

    public IObjectUi getObjectUi() {
        return this.objectUi;
    }
}

