/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.disy.commons.core.io.IOUtilities;

@Deprecated
public class BMPDecoder {
    InputStream is;
    int curPos = 0;
    int bitmapOffset;
    int width;
    int height;
    short bitsPerPixel;
    int compression;
    int actualSizeOfBitmap;
    int scanLineSize;
    int actualColorsUsed;
    byte[] r;
    byte[] g;
    byte[] b;
    int noOfEntries;
    byte[] byteData;
    int[] intData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(File file) {
        BMPDecoder bmp = new BMPDecoder();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            bmp.read(is);
        }
        catch (Exception e) {
            Image image;
            try {
                image = null;
            }
            catch (Throwable throwable) {
                IOUtilities.close(is);
                throw throwable;
            }
            IOUtilities.close(is);
            return image;
        }
        IOUtilities.close(is);
        MemoryImageSource mis = bmp.makeImageSource();
        if (mis == null) {
            throw new RuntimeException();
        }
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        return img;
    }

    private int readInt() throws IOException {
        int b1 = this.is.read();
        int b2 = this.is.read();
        int b3 = this.is.read();
        int b4 = this.is.read();
        this.curPos += 4;
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
    }

    private short readShort() throws IOException {
        int b1 = this.is.read();
        int b2 = this.is.read();
        this.curPos += 4;
        return (short)((b2 << 8) + b1);
    }

    private void getFileHeader() throws IOException, Exception {
        int fileType = 19778;
        fileType = this.readShort();
        if (fileType != 19778) {
            throw new Exception("Not a BMP file");
        }
        this.readInt();
        this.readShort();
        this.readShort();
        this.bitmapOffset = this.readInt();
    }

    private void getBitmapHeader() throws IOException {
        this.readInt();
        this.width = this.readInt();
        this.height = this.readInt();
        this.readShort();
        this.bitsPerPixel = this.readShort();
        this.compression = this.readInt();
        int sizeOfBitmap = this.readInt();
        this.readInt();
        this.readInt();
        int colorsUsed = this.readInt();
        this.readInt();
        this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.actualSizeOfBitmap = sizeOfBitmap != 0 ? sizeOfBitmap : this.scanLineSize * this.height;
        this.actualColorsUsed = colorsUsed != 0 ? colorsUsed : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
    }

    private void getPalette() throws IOException {
        this.noOfEntries = this.actualColorsUsed;
        if (this.noOfEntries > 0) {
            this.r = new byte[this.noOfEntries];
            this.g = new byte[this.noOfEntries];
            this.b = new byte[this.noOfEntries];
            for (int i = 0; i < this.noOfEntries; ++i) {
                this.b[i] = (byte)this.is.read();
                this.g[i] = (byte)this.is.read();
                this.r[i] = (byte)this.is.read();
                this.is.read();
                this.curPos += 4;
            }
        }
    }

    private void unpack(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        for (int i = 0; i < w; ++i) {
            int b0 = rawData[k++] & 0xFF;
            int b1 = (rawData[k++] & 0xFF) << 8;
            int b2 = (rawData[k++] & 0xFF) << 16;
            intData[j] = 0xFF000000 | b0 | b1 | b2;
            ++j;
        }
    }

    private void unpack(byte[] rawData, int rawOffset, int bpp, byte[] byteData, int byteOffset, int w) throws Exception {
        int pixPerByte;
        int mask;
        int j = byteOffset;
        int k = rawOffset;
        switch (bpp) {
            case 1: {
                mask = 1;
                pixPerByte = 8;
                break;
            }
            case 4: {
                mask = 15;
                pixPerByte = 2;
                break;
            }
            case 8: {
                mask = -1;
                pixPerByte = 1;
                break;
            }
            default: {
                throw new Exception("Unsupported bits-per-pixel value");
            }
        }
        int i = 0;
        while (true) {
            int shift = 8 - bpp;
            for (int ii = 0; ii < pixPerByte; ++ii) {
                byte br = rawData[k];
                br = (byte)(br >> shift);
                byteData[j] = (byte)(br & mask);
                ++j;
                if (++i == w) {
                    return;
                }
                shift -= bpp;
            }
            ++k;
        }
    }

    private void getPixelData() throws IOException, Exception {
        long skip = this.bitmapOffset - this.curPos;
        if (skip > 0L) {
            this.is.skip(skip);
            this.curPos = (int)((long)this.curPos + skip);
        }
        int len = this.scanLineSize;
        if (this.bitsPerPixel > 8) {
            this.intData = new int[this.width * this.height];
        } else {
            this.byteData = new byte[this.width * this.height];
        }
        byte[] rawData = new byte[this.actualSizeOfBitmap];
        int rawOffset = 0;
        int offset = (this.height - 1) * this.width;
        for (int i = this.height - 1; i >= 0; --i) {
            int n = this.is.read(rawData, rawOffset, len);
            if (n < len) {
                throw new Exception("Scan line ended prematurely after " + n + " bytes");
            }
            if (this.bitsPerPixel > 8) {
                this.unpack(rawData, rawOffset, this.intData, offset, this.width);
            } else {
                this.unpack(rawData, rawOffset, this.bitsPerPixel, this.byteData, offset, this.width);
            }
            rawOffset += len;
            offset -= this.width;
        }
    }

    public void read(InputStream is) throws IOException, Exception {
        this.is = is;
        this.getFileHeader();
        this.getBitmapHeader();
        if (this.compression != 0) {
            throw new Exception("Compression not supported");
        }
        this.getPalette();
        this.getPixelData();
    }

    public MemoryImageSource makeImageSource() {
        ColorModel cm = this.noOfEntries > 0 ? new IndexColorModel((int)this.bitsPerPixel, this.noOfEntries, this.r, this.g, this.b) : ColorModel.getRGBdefault();
        MemoryImageSource mis = this.bitsPerPixel > 8 ? new MemoryImageSource(this.width, this.height, cm, this.intData, 0, this.width) : new MemoryImageSource(this.width, this.height, cm, this.byteData, 0, this.width);
        return mis;
    }
}

