/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.JavEApplication;
import de.jave.jave.Point2d;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class LineToolGeneric
extends GenericTool {
    private Point point1;
    private Point point2;

    public LineToolGeneric(JaveMainPanel mainPanel, JavEApplication asciiPainter) {
        super(mainPanel, asciiPainter);
    }

    @Override
    public String getName() {
        return "Line Generic";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_LINE_GENERIC_ICON;
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        this.point2 = point;
        this.repaintCursor();
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.point1 = null;
        this.point2 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.isMix());
            this.markPlate.convert();
            this.markPlate.pasteResultInto(this.getPlate().getContent());
            this.saveCurrentState("draw line");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (code == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.point1 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        g.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        g.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        this.markPlate.clear();
        Point2d p1 = this.getPlate().getRealLocationForScreenPoint(this.point1);
        Point2d p2 = this.getPlate().getRealLocationForScreenPoint(this.point2);
        this.markPlate.drawLine(p1, p2);
        this.markPlate.convert();
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.point1 = null;
        this.point2 = null;
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
        this.point1 = null;
        this.point2 = null;
    }
}

