/*
 * Decompiled with CFR 0.152.
 */
package de.jave.swing.tabbedpane;

import de.jave.swing.tabbedpane.IDoubleClickListener;
import de.jave.swing.tabbedpane.ISmartTabbedPaneCloseListener;
import de.jave.swing.tabbedpane.ISmartTabbedPanePopupMenuFactory;
import de.jave.swing.tabbedpane.SmartTabbedPaneUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class SmartTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private SmartTabbedPaneUI paneUI;
    private ISmartTabbedPanePopupMenuFactory popupMenuFactory;

    public SmartTabbedPane() {
        super.setTabLayoutPolicy(1);
        this.paneUI = new SmartTabbedPaneUI();
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    @Override
    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
    }

    public void setCloseIcon(boolean b) {
        this.paneUI.setCloseIcon(b);
    }

    public synchronized void addCloseListener(ISmartTabbedPaneCloseListener l) {
        this.listenerList.add(ISmartTabbedPaneCloseListener.class, l);
    }

    public synchronized void addDoubleClickListener(IDoubleClickListener l) {
        this.listenerList.add(IDoubleClickListener.class, l);
    }

    public synchronized void removeCloseListener(ISmartTabbedPaneCloseListener l) {
        this.listenerList.remove(ISmartTabbedPaneCloseListener.class, l);
    }

    public synchronized void removeDoubleClickListener(IDoubleClickListener l) {
        this.listenerList.remove(IDoubleClickListener.class, l);
    }

    public void fireTabClosing(int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(ISmartTabbedPaneCloseListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((ISmartTabbedPaneCloseListener)closeListeners[i]).tabClosing(this, overTabIndex);
        }
    }

    public void fireDoubleClickTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] dClickListeners = this.getListeners(IDoubleClickListener.class);
        for (int i = 0; i < dClickListeners.length; ++i) {
            ((IDoubleClickListener)dClickListeners[i]).doubleClickOperation(e);
        }
    }

    public void popupOnTabEvent(int tabIndex, Point point) {
        if (this.popupMenuFactory == null) {
            return;
        }
        JPopupMenu menu = this.popupMenuFactory.createPopupMenu(this, tabIndex);
        if (menu == null) {
            return;
        }
        menu.show(this, point.x, point.y);
    }

    public void setPopupMenuFactory(ISmartTabbedPanePopupMenuFactory popupMenuFactory) {
        this.popupMenuFactory = popupMenuFactory;
    }
}

