/*
 * Decompiled with CFR 0.152.
 */
package de.jave.undo;

import de.jave.jave.JaveStatusFile;
import de.jave.undo.LogFileManagerEntry;
import de.jave.util.Queue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class LogFileManager
extends Thread {
    private static LogFileManager instance = new LogFileManager();
    private final Queue queue = new Queue();
    private final boolean shallStop = false;

    public static LogFileManager getInstance() {
        return instance;
    }

    public LogFileManager() {
        super("LogFileManager");
        this.setPriority(1);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            LogFileManagerEntry objectToWrite = null;
            Queue queue = this.queue;
            synchronized (queue) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.queue.isEmpty()) {
                    objectToWrite = (LogFileManagerEntry)this.queue.get();
                }
            }
            if (objectToWrite == null) continue;
            this.write(objectToWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(LogFileManagerEntry entry) {
        String s = entry.getUndoState().toString();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(entry.getFile(), true));
            writer.write(s);
            writer.newLine();
        }
        catch (IOException e) {
            try {
                System.err.println(e);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtilities.close(writer);
                throw throwable;
            }
            IOUtilities.close(writer);
        }
        IOUtilities.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createNewLogFile() throws IOException {
        File logFileFolder = JaveStatusFile.logDir;
        String logFileFileExtension = ".jlog";
        LogFileManager logFileManager = this;
        synchronized (logFileManager) {
            File file;
            if (!logFileFolder.exists()) {
                boolean success = logFileFolder.mkdirs();
            }
            int r = (int)(Math.random() * 2.147483647E9);
            do {
                r = r < 0 ? -r : r;
                file = new File(logFileFolder, String.valueOf(r) + ".jlog");
                ++r;
            } while (file.exists());
            file.createNewFile();
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(LogFileManagerEntry entry) {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.put(entry);
            this.queue.notifyAll();
        }
    }
}

