/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.statusbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import org.apache.log4j.Logger;
import org.diylc.announcements.AnnouncementProvider;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.appframework.update.UpdateChecker;
import org.diylc.common.BadPositionException;
import org.diylc.common.ComponentType;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.core.IDIYComponent;
import org.diylc.images.IconLoader;
import org.diylc.swing.ISwingUI;
import org.diylc.swingframework.MemoryBar;
import org.diylc.swingframework.miscutils.PercentageListCellRenderer;
import org.diylc.swingframework.update.UpdateDialog;
import org.diylc.swingframework.update.UpdateLabel;

public class StatusBar
extends JPanel
implements IPlugIn {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(StatusBar.class);
    public static String UPDATE_URL = "http://www.diy-fever.com/update.xml";
    private static String HIGHLIGHT_CONNECTED_TIP = "Click on a component to highlight area directly or indirectly connected to the area below the cursor. To continue editing, this mode needs to be switched OFF";
    private static final Format sizeFormat = new DecimalFormat("0.##");
    private JComboBox zoomBox;
    private UpdateLabel updateLabel;
    private JLabel announcementLabel;
    private JLabel recentChangesLabel;
    private MemoryBar memoryPanel;
    private JLabel statusLabel;
    private JLabel positionLabel;
    private JLabel sizeLabel;
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private ComponentType componentSlot;
    private Point controlPointSlot;
    private Boolean forceInstatiate;
    private List<String> componentNamesUnderCursor;
    private List<String> selectedComponentNames;
    private List<String> stuckComponentNames;
    private String statusMessage;
    private AnnouncementProvider announcementProvider;
    private Point2D mousePositionIn;
    private Point2D mousePositionMm;

    public StatusBar(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        this.announcementProvider = new AnnouncementProvider();
        this.setLayout(new GridBagLayout());
        try {
            iSwingUI.injectGUIComponent(this, 3);
        }
        catch (BadPositionException badPositionException) {
            LOG.error((Object)"Could not install status bar", (Throwable)badPositionException);
        }
        iSwingUI.executeBackgroundTask(new ITask<String>(){

            public String doInBackground() throws Exception {
                Thread.sleep(1000L);
                String string = StatusBar.this.announcementProvider.getCurrentAnnouncements(false);
                String string2 = StatusBar.this.getUpdateLabel().getUpdateChecker().findNewVersionShort();
                if (string2 != null) {
                    String string3 = "<font size='4'><b>New version available:</b> " + string2 + "</font><br>Click the lighbulb icon in the bottom-right corner of the window for more info.";
                    if (string == null || string.length() == 0) {
                        return "<html>" + string3 + "</html>";
                    }
                    string = string.replace("<html>", "<html>" + string3 + "<br>");
                }
                return string;
            }

            public void failed(Exception exception) {
                LOG.error((Object)"Error while fetching announcements", (Throwable)exception);
            }

            public void complete(String string) {
                if (string != null && string.length() > 0) {
                    new BalloonTip((JComponent)StatusBar.this.getUpdateLabel(), string, (BalloonTipStyle)new EdgedBalloonStyle(UIManager.getColor("ToolTip.background"), UIManager.getColor("ToolTip.foreground")), true);
                    StatusBar.this.announcementProvider.dismissed();
                }
            }
        }, false);
        ConfigurationManager.getInstance().addConfigListener("metric", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                StatusBar.this.refreshPosition((Boolean)object);
            }
        });
        ConfigurationManager.getInstance().addConfigListener("highlightContinuityArea", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                StatusBar.this.refreshStatusText();
            }
        });
    }

    private JComboBox getZoomBox() {
        if (this.zoomBox == null) {
            this.zoomBox = new JComboBox<Double>(this.plugInPort.getAvailableZoomLevels());
            this.zoomBox.setSelectedItem(this.plugInPort.getZoomLevel());
            this.zoomBox.setFocusable(false);
            this.zoomBox.setRenderer(new PercentageListCellRenderer());
            this.zoomBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatusBar.this.plugInPort.setZoomLevel(((Double)StatusBar.this.zoomBox.getSelectedItem()).doubleValue());
                }
            });
        }
        return this.zoomBox;
    }

    private UpdateLabel getUpdateLabel() {
        if (this.updateLabel == null) {
            this.updateLabel = new UpdateLabel(this.plugInPort.getCurrentVersionNumber(), UPDATE_URL){
                private static final long serialVersionUID = 1L;

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return new Point(0, -16);
                }
            };
            this.updateLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }
        return this.updateLabel;
    }

    public JLabel getAnnouncementLabel() {
        if (this.announcementLabel == null) {
            this.announcementLabel = new JLabel(IconLoader.Megaphone.getIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return new Point(0, -16);
                }
            };
            this.announcementLabel.setToolTipText("Click to fetch the most recent public announcement");
            this.announcementLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.announcementLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    StatusBar.this.swingUI.executeBackgroundTask(new ITask<String>(){

                        public String doInBackground() throws Exception {
                            return StatusBar.this.announcementProvider.getCurrentAnnouncements(true);
                        }

                        public void failed(Exception exception) {
                            LOG.error((Object)"Error while fetching announcements", (Throwable)exception);
                            StatusBar.this.swingUI.showMessage("Could not fetch public announcements.", "Error", 0);
                        }

                        public void complete(String string) {
                            if (string != null && string.length() > 0) {
                                StatusBar.this.swingUI.showMessage(string, "Public Announcement", 1);
                                StatusBar.this.announcementProvider.dismissed();
                            } else {
                                StatusBar.this.swingUI.showMessage("No new public announcements available.", "Public Announcement", 1);
                            }
                        }
                    }, true);
                }
            });
        }
        return this.announcementLabel;
    }

    public JLabel getRecentChangesLabel() {
        if (this.recentChangesLabel == null) {
            this.recentChangesLabel = new JLabel(IconLoader.ScrollInformation.getIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return new Point(0, -16);
                }
            };
            this.recentChangesLabel.setToolTipText("Click to show recent changes and updates");
            this.recentChangesLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.recentChangesLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    List list = StatusBar.this.plugInPort.getRecentUpdates();
                    if (list == null) {
                        StatusBar.this.swingUI.showMessage("Version history is not available.", "Information", 1);
                    } else {
                        String string = UpdateChecker.createUpdateHTML(list);
                        UpdateDialog updateDialog = new UpdateDialog((JComponent)StatusBar.this.swingUI.getOwnerFrame().getRootPane(), string, (String)null);
                        updateDialog.setVisible(true);
                    }
                }
            });
        }
        return this.recentChangesLabel;
    }

    private MemoryBar getMemoryPanel() {
        if (this.memoryPanel == null) {
            this.memoryPanel = new MemoryBar(false){
                private static final long serialVersionUID = 1L;

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return new Point(0, -52);
                }
            };
        }
        return this.memoryPanel;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        }
        return this.statusLabel;
    }

    private JLabel getPositionLabel() {
        if (this.positionLabel == null) {
            this.positionLabel = new JLabel();
            this.positionLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }
        return this.positionLabel;
    }

    public JLabel getSizeLabel() {
        if (this.sizeLabel == null) {
            this.sizeLabel = new JLabel(IconLoader.Size.getIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    return new Point(0, -16);
                }
            };
            this.sizeLabel.setFocusable(true);
            this.sizeLabel.setToolTipText("Click to calculate selection size");
            this.sizeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point2D[] point2DArray = StatusBar.this.plugInPort.calculateSelectionDimension();
                    String string = point2DArray == null ? "Selection is empty." : sizeFormat.format(point2DArray[0].getX()) + " x " + sizeFormat.format(point2DArray[0].getY()) + " in\n" + sizeFormat.format(point2DArray[1].getX()) + " x " + sizeFormat.format(point2DArray[1].getY()) + " cm";
                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(StatusBar.this), string, "Selection Size", 1);
                }
            });
        }
        return this.sizeLabel;
    }

    private void layoutComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getStatusLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.getPositionLabel(), gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Zoom: "), "West");
        jPanel.add((Component)this.getZoomBox(), "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.getSizeLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.getAnnouncementLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getUpdateLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.getRecentChangesLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.getMemoryPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.layoutComponents();
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.ZOOM_CHANGED, new EventType[]{EventType.SLOT_CHANGED, EventType.AVAILABLE_CTRL_POINTS_CHANGED, EventType.SELECTION_CHANGED, EventType.STATUS_MESSAGE_CHANGED, EventType.MOUSE_MOVED});
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        switch (eventType) {
            case ZOOM_CHANGED: {
                if (objectArray[0].equals(this.getZoomBox().getSelectedItem())) break;
                final Double d = (Double)objectArray[0];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusBar.this.getZoomBox().setSelectedItem(d);
                    }
                });
                break;
            }
            case SELECTION_CHANGED: {
                Collection collection = (Collection)objectArray[0];
                Collection collection2 = (Collection)objectArray[1];
                HashSet<String> hashSet = new HashSet<String>();
                for (IDIYComponent iDIYComponent : collection) {
                    hashSet.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                this.selectedComponentNames = new ArrayList<String>(hashSet);
                Collections.sort(this.selectedComponentNames);
                this.stuckComponentNames = new ArrayList<String>();
                for (IDIYComponent iDIYComponent : collection2) {
                    this.stuckComponentNames.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                this.stuckComponentNames.removeAll(this.selectedComponentNames);
                Collections.sort(this.stuckComponentNames);
                this.refreshStatusText();
                break;
            }
            case SLOT_CHANGED: {
                this.componentSlot = (ComponentType)objectArray[0];
                this.controlPointSlot = (Point)objectArray[1];
                this.forceInstatiate = objectArray.length > 2 ? (Boolean)objectArray[2] : null;
                this.refreshStatusText();
                break;
            }
            case AVAILABLE_CTRL_POINTS_CHANGED: {
                this.componentNamesUnderCursor = new ArrayList<String>();
                for (IDIYComponent iDIYComponent : ((Map)objectArray[0]).keySet()) {
                    this.componentNamesUnderCursor.add("<font color='blue'>" + iDIYComponent.getName() + "</font>");
                }
                Collections.sort(this.componentNamesUnderCursor);
                this.refreshStatusText();
                break;
            }
            case STATUS_MESSAGE_CHANGED: {
                this.statusMessage = (String)objectArray[0];
                this.refreshStatusText();
                break;
            }
            case MOUSE_MOVED: {
                this.mousePositionIn = (Point2D)objectArray[1];
                this.mousePositionMm = (Point2D)objectArray[2];
                this.refreshPosition(ConfigurationManager.getInstance().readBoolean("metric", true));
            }
        }
    }

    private void refreshPosition(boolean bl) {
        String string;
        Point2D point2D = bl ? this.mousePositionMm : this.mousePositionIn;
        String string2 = string = bl ? "mm" : "in";
        if (point2D == null) {
            this.getPositionLabel().setText(null);
        } else {
            this.getPositionLabel().setText(String.format("x:%.2f%s y:%.2f%s", point2D.getX(), string, point2D.getY(), string));
        }
    }

    private void refreshStatusText() {
        Object object;
        String string = this.statusMessage;
        if (this.componentSlot == null) {
            if (this.componentNamesUnderCursor != null && !this.componentNamesUnderCursor.isEmpty()) {
                object = Utils.toCommaString(this.componentNamesUnderCursor);
                string = "<html>Drag control point(s) of " + (String)object + "</html>";
            } else if (this.selectedComponentNames != null && !this.selectedComponentNames.isEmpty()) {
                object = new StringBuilder();
                ((StringBuilder)object).append(Utils.toCommaString(this.selectedComponentNames.subList(0, Math.min(20, this.selectedComponentNames.size()))));
                if (this.selectedComponentNames.size() > 15) {
                    ((StringBuilder)object).append(" and " + (this.selectedComponentNames.size() - 15) + " more");
                }
                if (!this.stuckComponentNames.isEmpty()) {
                    ((StringBuilder)object).append(" (hold <b>Ctrl</b> and drag to unstuck from ");
                    ((StringBuilder)object).append(Utils.toCommaString(this.stuckComponentNames.subList(0, Math.min(5, this.stuckComponentNames.size()))));
                    if (this.stuckComponentNames.size() > 5) {
                        ((StringBuilder)object).append(" and " + (this.stuckComponentNames.size() - 5) + " more");
                    }
                    ((StringBuilder)object).append(")");
                }
                string = "<html>Selection: " + ((StringBuilder)object).toString() + "</html>";
            }
        } else if (this.forceInstatiate != null && this.forceInstatiate.booleanValue()) {
            string = "<html>Drag the mouse over the canvas to place a new <font color='blue'>" + this.componentSlot.getName() + "</font></html>";
        } else {
            switch (this.componentSlot.getCreationMethod()) {
                case POINT_BY_POINT: {
                    object = this.controlPointSlot == null ? "first" : "second";
                    string = "<html>Click on the canvas to set the " + (String)object + " control point of a new <font color='blue'>" + this.componentSlot.getName() + "</font> or press <b>Esc</b> to cancel</html>";
                    break;
                }
                case SINGLE_CLICK: {
                    string = "<html>Click on the canvas to create a new <font color='blue'>" + this.componentSlot.getName() + "</font> or press <b>Esc</b> to cancel</html>";
                }
            }
        }
        object = ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false);
        if (((Boolean)object).booleanValue()) {
            string = HIGHLIGHT_CONNECTED_TIP;
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar.this.getStatusLabel().setText(string2);
            }
        });
    }
}

