/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.common;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.diylc.common.ZoomableStroke;

public class ObjectCache {
    private static ObjectCache instance;
    private Map<Float, Stroke> basicStrokeMap = new HashMap<Float, Stroke>();
    private Map<Float, Stroke> zoomableStrokeMap = new HashMap<Float, Stroke>();
    private Map<String, Stroke> dashStrokeMap = new HashMap<String, Stroke>();

    public static ObjectCache getInstance() {
        if (instance == null) {
            instance = new ObjectCache();
        }
        return instance;
    }

    private ObjectCache() {
    }

    public Stroke fetchBasicStroke(float f) {
        if (this.basicStrokeMap.containsKey(Float.valueOf(f))) {
            return this.basicStrokeMap.get(Float.valueOf(f));
        }
        BasicStroke basicStroke = new BasicStroke(f, 1, 1);
        this.basicStrokeMap.put(Float.valueOf(f), basicStroke);
        return basicStroke;
    }

    public Stroke fetchZoomableStroke(float f) {
        if (this.zoomableStrokeMap.containsKey(Float.valueOf(f))) {
            return this.zoomableStrokeMap.get(Float.valueOf(f));
        }
        ZoomableStroke zoomableStroke = new ZoomableStroke(f, 1, 1);
        this.zoomableStrokeMap.put(Float.valueOf(f), zoomableStroke);
        return zoomableStroke;
    }

    public Stroke fetchStroke(float f, float[] fArray, float f2, int n) {
        String string = f + "|" + Arrays.toString(fArray) + "|" + f2 + "|" + f2;
        if (this.dashStrokeMap.containsKey(string)) {
            return this.dashStrokeMap.get(string);
        }
        BasicStroke basicStroke = new BasicStroke(f, n, 1, 0.0f, fArray, f2);
        this.dashStrokeMap.put(string, basicStroke);
        return basicStroke;
    }
}

