/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractComponent;
import org.diylc.components.boards.AbstractBoard;
import org.diylc.components.boards.VeroBoard;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Trace Cut", category="Connectivity", author="Branislav Stojkovic", description="Designates the place where a trace on the vero board needs to be cut", instanceNamePrefix="Cut", zOrder=3.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class TraceCut
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(0.08), SizeUnit.in);
    public static Size CUT_WIDTH = new Size(Double.valueOf(0.5), SizeUnit.mm);
    public static Color FILL_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.red;
    public static Color SELECTION_COLOR = Color.red;
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.7), SizeUnit.mm);
    private Size size = SIZE;
    private Color fillColor = FILL_COLOR;
    @Deprecated
    private Color borderColor = BORDER_COLOR;
    private Color boardColor = AbstractBoard.BOARD_COLOR;
    private Boolean cutBetweenHoles = false;
    private Size holeSpacing = VeroBoard.SPACING;
    protected Point point = new Point(0, 0);

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        g2d.setStroke(ObjectCache.getInstance().fetchZoomableStroke(1.0f));
        int size = this.getClosestOdd((int)this.size.convertToPixels());
        int cutWidth = this.getClosestOdd((int)CUT_WIDTH.convertToPixels());
        if (this.getCutBetweenHoles()) {
            int holeSpacing = this.getClosestOdd(this.getHoleSpacing().convertToPixels());
            g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.boardColor);
            drawingObserver.startTrackingContinuityArea(false);
            g2d.fillRect(this.point.x - holeSpacing / 2 - cutWidth / 2, this.point.y - size / 2 - 1, cutWidth, size + 2);
            drawingObserver.stopTrackingContinuityArea();
        } else {
            g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.boardColor);
            drawingObserver.startTrackingContinuityArea(false);
            g2d.fillRoundRect(this.point.x - size / 2, this.point.y - size / 2, size, size, size, size);
            drawingObserver.stopTrackingContinuityArea();
            g2d.setColor(Constants.CANVAS_COLOR);
            int holeSize = this.getClosestOdd((int)HOLE_SIZE.convertToPixels());
            g2d.fillOval(this.point.x - holeSize / 2, this.point.y - holeSize / 2, holeSize, holeSize);
            g2d.setColor(this.boardColor.darker());
            g2d.drawOval(this.point.x - holeSize / 2, this.point.y - holeSize / 2, holeSize, holeSize);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(AbstractBoard.BOARD_COLOR);
        g2d.fillRect(0, 2 / factor, width - 1, height - 4 / factor);
        g2d.setColor(AbstractBoard.BORDER_COLOR);
        g2d.drawRect(0, 2 / factor, width - 1, height - 4 / factor);
        g2d.setColor(COPPER_COLOR);
        g2d.fillRect(1 / factor, width / 3, width - 2 / factor, this.getClosestOdd(width / 3) + 1);
        g2d.setColor(COPPER_COLOR.darker());
        g2d.drawRect(1 / factor, width / 3, width - 2 / factor, this.getClosestOdd(width / 3) + 1);
        g2d.setColor(AbstractBoard.BOARD_COLOR);
        g2d.fillRoundRect(width / 3, width / 3, this.getClosestOdd(width / 3) + 2, this.getClosestOdd(width / 3) + 2, width / 3, width / 3);
        g2d.setColor(COPPER_COLOR);
        g2d.fillRect(1 / factor, 2 / factor, width - 2 / factor, 4 / factor);
        g2d.fillRect(1 / factor, height - 6 / factor, width - 2 / factor, 4 / factor);
        g2d.setColor(COPPER_COLOR.darker());
        g2d.drawRect(1 / factor, 2 / factor, width - 2 / factor, 4 / factor);
        g2d.drawRect(1 / factor, height - 6 / factor, width - 2 / factor, 4 / factor);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(width / 6 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
        g2d.fillOval(width / 2 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
        g2d.fillOval(5 * width / 6 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
        g2d.setColor(COPPER_COLOR.darker());
        g2d.drawOval(width / 6 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
        g2d.drawOval(width / 2 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
        g2d.drawOval(5 * width / 6 - 1, width / 2 - 1, this.getClosestOdd(3.0 / (double)factor), this.getClosestOdd(3.0 / (double)factor));
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @EditableProperty
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty(name="Fill")
    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Deprecated
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Deprecated
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Cut between holes")
    public boolean getCutBetweenHoles() {
        if (this.cutBetweenHoles == null) {
            this.cutBetweenHoles = false;
        }
        return this.cutBetweenHoles;
    }

    public void setCutBetweenHoles(boolean cutBetweenHoles) {
        this.cutBetweenHoles = cutBetweenHoles;
    }

    @EditableProperty(name="Board")
    public Color getBoardColor() {
        if (this.boardColor == null) {
            this.boardColor = AbstractBoard.BOARD_COLOR;
        }
        return this.boardColor;
    }

    public void setBoardColor(Color boardColor) {
        this.boardColor = boardColor;
    }

    @EditableProperty(name="Hole spacing")
    public Size getHoleSpacing() {
        if (this.holeSpacing == null) {
            this.holeSpacing = VeroBoard.SPACING;
        }
        return this.holeSpacing;
    }

    public void setHoleSpacing(Size holeSpacing) {
        this.holeSpacing = holeSpacing;
    }

    @Deprecated
    public String getName() {
        return super.getName();
    }

    public String getControlPointNodeName(int index) {
        return null;
    }
}

