/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.components.guitar.AbstractGuitarPickup;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Humbucker Pickup", category="Guitar", author="Branislav Stojkovic", description="Double-coil humbucker guitar pickup (PAF, Mini Humbuckers, Filtertrons)", zOrder=4.0, instanceNamePrefix="PKP", autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Guitar Wiring Diagram")
public class HumbuckerPickup
extends AbstractGuitarPickup {
    private static final long serialVersionUID = 1L;
    private static Color BASE_COLOR = Color.lightGray;
    private static Color BOBIN_COLOR1 = Color.decode("#EAE3C6");
    private static Color BOBIN_COLOR2 = Color.black;
    private static Size WIDTH = new Size(Double.valueOf(36.5), SizeUnit.mm);
    private static Size LENGTH = new Size(Double.valueOf(68.58), SizeUnit.mm);
    private static Size WIDTH_MINI = new Size(Double.valueOf(29.3), SizeUnit.mm);
    private static Size LENGTH_MINI = new Size(Double.valueOf(67.4), SizeUnit.mm);
    private static Size WIDTH_FILTERTRON = new Size(Double.valueOf(34.9), SizeUnit.mm);
    private static Size LENGTH_FILTERTRON = new Size(Double.valueOf(71.4), SizeUnit.mm);
    private static Size FILTETRON_CUTOUT_MARGIN = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private static Size LIP_WIDTH = new Size(Double.valueOf(12.7), SizeUnit.mm);
    private static Size LIP_LENGTH = new Size(Double.valueOf(7.9), SizeUnit.mm);
    private static Size EDGE_RADIUS = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POINT_MARGIN = new Size(Double.valueOf(1.5), SizeUnit.mm);
    private static Size SCREW_LINE = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private static Size POINT_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size LIP_HOLE_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size POLE_SIZE = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POLE_SIZE_FILTERTRON = new Size(Double.valueOf(5.0), SizeUnit.mm);
    private static Size POLE_SPACING = new Size(Double.valueOf(10.1), SizeUnit.mm);
    private Color color = BASE_COLOR;
    private Color poleColor = METAL_COLOR;
    private HumbuckerType type;
    private boolean cover;
    private Boolean legs = true;
    private Color bobinColor1 = BOBIN_COLOR1;
    private Color bobinColor2 = BOBIN_COLOR2;
    private PolePieceType coilType1;
    private PolePieceType coilType2;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.color);
        if (this.getType() != HumbuckerType.Filtertron) {
            g2d.fill(body[0]);
        }
        if (body[1] != null) {
            g2d.fill(body[1]);
        }
        if (!outlineMode) {
            if (body[4] != null) {
                g2d.setColor(this.getBobinColor1());
                g2d.fill(body[4]);
            }
            if (body[5] != null) {
                g2d.setColor(this.getBobinColor2());
                g2d.fill(body[5]);
            }
        }
        if (this.getType() == HumbuckerType.Filtertron) {
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.color);
            g2d.fill(body[0]);
        }
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker();
        }
        g2d.setColor(finalBorderColor);
        if (this.getType() != HumbuckerType.Filtertron) {
            g2d.draw(body[0]);
        }
        if (body[1] != null) {
            g2d.draw(body[1]);
        }
        if (!outlineMode) {
            g2d.setColor(this.getPoleColor());
            g2d.fill(body[3]);
            g2d.setColor(this.darkerOrLighter(this.getPoleColor()));
            g2d.draw(body[3]);
            if (body[6] != null) {
                g2d.draw(body[6]);
            }
            if (this.getType() != HumbuckerType.Filtertron) {
                if (body[4] != null) {
                    g2d.setColor(this.getBobinColor1().darker());
                    g2d.draw(body[4]);
                }
                if (body[5] != null) {
                    g2d.setColor(this.getBobinColor2().darker());
                    g2d.draw(body[5]);
                }
            }
        }
        if (this.getType() == HumbuckerType.Filtertron) {
            g2d.setColor(finalBorderColor);
            g2d.draw(body[0]);
        }
        this.drawMainLabel(g2d, project, outlineMode, componentState);
        this.drawlTerminalLabels(g2d, finalBorderColor, project);
    }

    @Override
    protected OrientationHV getControlPointDirection() {
        return OrientationHV.VERTICAL;
    }

    @Override
    protected Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[7];
            Point[] points = this.getControlPoints();
            int x = points[0].x;
            int y = points[0].y;
            int width = (int)this.getType().getWidth().convertToPixels();
            int length = (int)this.getType().getLength().convertToPixels();
            int lipWidth = (int)LIP_WIDTH.convertToPixels();
            int lipLength = (int)LIP_LENGTH.convertToPixels();
            int edgeRadius = (int)EDGE_RADIUS.convertToPixels();
            int pointMargin = (int)POINT_MARGIN.convertToPixels();
            int pointSize = this.getClosestOdd(POINT_SIZE.convertToPixels());
            int lipHoleSize = this.getClosestOdd(LIP_HOLE_SIZE.convertToPixels());
            int poleSize = (int)this.getType().getPoleSize().convertToPixels();
            int poleSpacing = (int)POLE_SPACING.convertToPixels();
            int coilSpacing = width / 2;
            int coilMargin = (width - coilSpacing) / 2;
            int poleMargin = (length - poleSpacing * 5) / 2;
            Area base = new Area(new RoundRectangle2D.Double(x - length, y - pointMargin, length, width, edgeRadius, edgeRadius));
            this.body[0] = new Area(base);
            if (this.getType() == HumbuckerType.Filtertron) {
                int cutoutMargin = (int)FILTETRON_CUTOUT_MARGIN.convertToPixels();
                int cutoutHeight = poleSize + 2 * cutoutMargin;
                int cutoutWidth = 5 * poleSpacing + poleSize + 2 * cutoutMargin;
                Area cutout = new Area(new RoundRectangle2D.Double(x - length + poleMargin - poleSize / 2 - cutoutMargin, y - pointMargin + coilMargin - poleSize / 2 - cutoutMargin, cutoutWidth, cutoutHeight, cutoutHeight, cutoutHeight));
                ((Area)this.body[0]).subtract(cutout);
                cutout = new Area(new RoundRectangle2D.Double(x - length + poleMargin - poleSize / 2 - cutoutMargin, y - pointMargin + width - coilMargin - poleSize / 2 - cutoutMargin, cutoutWidth, cutoutHeight, cutoutHeight, cutoutHeight));
                ((Area)this.body[0]).subtract(cutout);
                int middleCutoutWidth = poleSpacing / 5;
                cutout = new Area(new Rectangle2D.Double(x - length / 2 - middleCutoutWidth / 2, y - pointMargin + width / 4, middleCutoutWidth, width / 2));
                ((Area)this.body[0]).subtract(cutout);
                if (!this.getLegs().booleanValue()) {
                    cutout = new Area(new Ellipse2D.Double(x - length + lipHoleSize * 2, (double)(y - pointMargin + width / 2) - (double)lipHoleSize * 0.75, (double)lipHoleSize * 1.5, (double)lipHoleSize * 1.5));
                    ((Area)this.body[0]).subtract(cutout);
                    cutout = new Area(new Ellipse2D.Double(x - lipHoleSize * 3, (double)(y - pointMargin + width / 2) - (double)lipHoleSize * 0.75, (double)lipHoleSize * 1.5, (double)lipHoleSize * 1.5));
                    ((Area)this.body[0]).subtract(cutout);
                }
            }
            if (!this.getCover() || this.getType() == HumbuckerType.Filtertron) {
                int bobinWidth = width / 2;
                int bobinRadius = (int)(this.getType() == HumbuckerType.Filtertron ? (float)edgeRadius * 1.1f : (float)bobinWidth);
                this.body[4] = new Area(new RoundRectangle2D.Double(x - length, y - pointMargin, length, bobinWidth, bobinRadius, bobinRadius));
                this.body[5] = new Area(new RoundRectangle2D.Double(x - length, y - pointMargin + bobinWidth, length, bobinWidth, bobinRadius, bobinRadius));
            }
            if (this.getLegs().booleanValue()) {
                Area legArea = new Area(new RoundRectangle2D.Double(x - length - lipLength, y - pointMargin + width / 2 - lipWidth / 2, length + 2 * lipLength, lipWidth, edgeRadius / 2, edgeRadius / 2));
                legArea.subtract((Area)this.body[0]);
                legArea.subtract(new Area(new Ellipse2D.Double(x - length - lipLength / 2, y - pointMargin + width / 2 - lipHoleSize / 2, lipHoleSize, lipHoleSize)));
                legArea.subtract(new Area(new Ellipse2D.Double(x + lipLength / 2, y - pointMargin + width / 2 - lipHoleSize / 2, lipHoleSize, lipHoleSize)));
                legArea.subtract(base);
                this.body[1] = legArea;
            }
            this.body[2] = new Area(new Ellipse2D.Double(x - pointSize / 2, y - pointSize / 2, pointSize, pointSize));
            Area poleArea = new Area();
            Area poleDecorationArea = new Area();
            if (this.getCoilType1() == PolePieceType.Rail) {
                poleArea.add(new Area(new RoundRectangle2D.Double(x - length + poleMargin - poleSize / 2, y - pointMargin + coilMargin - poleSize / 2, poleSpacing * 5 + poleSize, poleSize, poleSize / 2, poleSize / 2)));
            } else if (this.getCoilType1() == PolePieceType.Rods || this.getCoilType1() == PolePieceType.Screws) {
                Path2D.Double screwPath = new Path2D.Double();
                for (int i = 0; i < 6; ++i) {
                    Ellipse2D.Double pole = new Ellipse2D.Double(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + coilMargin - poleSize / 2, poleSize, poleSize);
                    poleArea.add(new Area(pole));
                    if (this.getCoilType1() != PolePieceType.Screws) continue;
                    if (i % 2 == 0) {
                        ((Path2D)screwPath).moveTo(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + coilMargin - poleSize / 2);
                        ((Path2D)screwPath).lineTo(x - length + poleMargin + i * poleSpacing - poleSize / 2 + poleSize, y - pointMargin + coilMargin - poleSize / 2 + poleSize);
                        continue;
                    }
                    ((Path2D)screwPath).moveTo(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + coilMargin - poleSize / 2 + poleSize);
                    ((Path2D)screwPath).lineTo(x - length + poleMargin + i * poleSpacing - poleSize / 2 + poleSize, y - pointMargin + coilMargin - poleSize / 2);
                }
                if (this.getCoilType1() == PolePieceType.Screws) {
                    Stroke pathStroke = ObjectCache.getInstance().fetchBasicStroke((float)SCREW_LINE.convertToPixels());
                    Area screwArea = new Area(pathStroke.createStrokedShape(screwPath));
                    screwArea.intersect(poleArea);
                    poleDecorationArea.add(screwArea);
                }
            }
            if (this.getCoilType2() == PolePieceType.Rail) {
                poleArea.add(new Area(new RoundRectangle2D.Double(x - length + poleMargin - poleSize / 2, y - pointMargin + width - coilMargin - poleSize / 2, poleSpacing * 5 + poleSize, poleSize, poleSize / 2, poleSize / 2)));
            } else if (this.getCoilType2() == PolePieceType.Rods || this.getCoilType2() == PolePieceType.Screws) {
                Path2D.Double screwPath = new Path2D.Double();
                for (int i = 0; i < 6; ++i) {
                    Ellipse2D.Double pole = new Ellipse2D.Double(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + width - coilMargin - poleSize / 2, poleSize, poleSize);
                    poleArea.add(new Area(pole));
                    if (this.getCoilType1() != PolePieceType.Screws) continue;
                    if (i % 2 == 1) {
                        ((Path2D)screwPath).moveTo(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + width - coilMargin - poleSize / 2);
                        ((Path2D)screwPath).lineTo(x - length + poleMargin + i * poleSpacing - poleSize / 2 + poleSize, y - pointMargin + width - coilMargin - poleSize / 2 + poleSize);
                        continue;
                    }
                    ((Path2D)screwPath).moveTo(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin + width - coilMargin - poleSize / 2 + poleSize);
                    ((Path2D)screwPath).lineTo(x - length + poleMargin + i * poleSpacing - poleSize / 2 + poleSize, y - pointMargin + width - coilMargin - poleSize / 2);
                }
                if (this.getCoilType2() == PolePieceType.Screws) {
                    Stroke pathStroke = ObjectCache.getInstance().fetchBasicStroke((float)SCREW_LINE.convertToPixels());
                    Area screwArea = new Area(pathStroke.createStrokedShape(screwPath));
                    screwArea.intersect(poleArea);
                    poleDecorationArea.add(screwArea);
                }
            }
            this.body[3] = poleArea;
            this.body[6] = poleDecorationArea;
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (Shape shape : this.body) {
                    Area area = (Area)shape;
                    if (area == null) continue;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    @Override
    protected int getMainLabelYOffset() {
        return (int)(this.getType().getWidth().convertToPixels() / 2.0 - 20.0);
    }

    @Override
    public boolean isHumbucker() {
        return true;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        int baseWidth = 16 * width / 32;
        int baseLength = 27 * width / 32;
        g2d.setColor(BASE_COLOR);
        g2d.fillRoundRect((width - baseWidth / 4) / 2, 0, baseWidth / 4, height - 1, 2 * width / 32, 2 * width / 32);
        g2d.setColor(BASE_COLOR.darker());
        g2d.drawRoundRect((width - baseWidth / 4) / 2, 0, baseWidth / 4, height - 1, 2 * width / 32, 2 * width / 32);
        g2d.setColor(BASE_COLOR);
        g2d.fillRoundRect((width - baseWidth) / 2, (height - baseLength) / 2, baseWidth, baseLength, 4 * width / 32, 4 * width / 32);
        g2d.setColor(BASE_COLOR.darker());
        g2d.drawRoundRect((width - baseWidth) / 2, (height - baseLength) / 2, baseWidth, baseLength, 4 * width / 32, 4 * width / 32);
        g2d.setColor(BOBIN_COLOR1);
        g2d.fillRoundRect((width - baseWidth) / 2, (height - baseLength) / 2, baseWidth / 2, baseLength, baseWidth / 2, baseWidth / 2);
        g2d.setColor(BOBIN_COLOR2);
        g2d.fillRoundRect(width / 2, (height - baseLength) / 2, baseWidth / 2, baseLength, baseWidth / 2, baseWidth / 2);
        g2d.setColor(METAL_COLOR);
        int poleSize = 2;
        int poleSpacing = 17 * width / 32;
        for (int i = 0; i < 6; ++i) {
            g2d.fillOval((width - poleSize - baseWidth / 2) / 2, (height - poleSpacing) / 2 + i * poleSpacing / 5, poleSize, poleSize);
            g2d.fillOval((width - poleSize + baseWidth / 2) / 2, (height - poleSpacing) / 2 + i * poleSpacing / 5, poleSize, poleSize);
        }
    }

    @EditableProperty
    public HumbuckerType getType() {
        if (this.type == null) {
            this.type = HumbuckerType.PAF;
        }
        return this.type;
    }

    public void setType(HumbuckerType type) {
        this.type = type;
        this.body = null;
    }

    @EditableProperty(name="Bobin 1")
    public Color getBobinColor1() {
        if (this.bobinColor1 == null) {
            this.bobinColor1 = BOBIN_COLOR1;
        }
        return this.bobinColor1;
    }

    public void setBobinColor1(Color bobinColor1) {
        this.bobinColor1 = bobinColor1;
    }

    @EditableProperty(name="Bobin 2")
    public Color getBobinColor2() {
        if (this.bobinColor2 == null) {
            this.bobinColor2 = BOBIN_COLOR2;
        }
        return this.bobinColor2;
    }

    public void setBobinColor2(Color bobinColor2) {
        this.bobinColor2 = bobinColor2;
    }

    @EditableProperty
    public boolean getCover() {
        return this.cover;
    }

    public void setCover(boolean cover) {
        this.cover = cover;
        this.body = null;
    }

    @EditableProperty
    public Boolean getLegs() {
        if (this.legs == null) {
            this.legs = true;
        }
        return this.legs;
    }

    public void setLegs(Boolean legs) {
        this.legs = legs;
        this.body = null;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Pole Color")
    public Color getPoleColor() {
        if (this.poleColor == null) {
            this.poleColor = METAL_COLOR;
        }
        return this.poleColor;
    }

    public void setPoleColor(Color poleColor) {
        this.poleColor = poleColor;
    }

    @EditableProperty(name="Pole Pieces 1")
    public PolePieceType getCoilType1() {
        if (this.coilType1 == null) {
            return PolePieceType.Screws;
        }
        return this.coilType1;
    }

    public void setCoilType1(PolePieceType coilType1) {
        this.coilType1 = coilType1;
        this.body = null;
    }

    @EditableProperty(name="Pole Pieces 2")
    public PolePieceType getCoilType2() {
        if (this.coilType2 == null) {
            return PolePieceType.Rods;
        }
        return this.coilType2;
    }

    public void setCoilType2(PolePieceType coilType2) {
        this.coilType2 = coilType2;
        this.body = null;
    }

    public String getControlPointNodeName(int index) {
        switch (index) {
            case 0: {
                return "North Start";
            }
            case 1: {
                return "North Finish";
            }
            case 2: {
                return "South Start";
            }
            case 3: {
                return "South Finish";
            }
        }
        return null;
    }

    public String getInternalLinkName(int index1, int index2) {
        if (index1 == 0 && index2 == 1) {
            return AbstractGuitarPickup.Polarity.North.toString() + "->";
        }
        if (index1 == 2 && index2 == 3) {
            return AbstractGuitarPickup.Polarity.South.toString() + "->";
        }
        if (index1 == 1 && index2 == 0) {
            return AbstractGuitarPickup.Polarity.North.toString() + "<-";
        }
        if (index1 == 3 && index2 == 2) {
            return AbstractGuitarPickup.Polarity.South.toString() + "<-";
        }
        return null;
    }

    @Override
    public AbstractGuitarPickup.Polarity getPolarity() {
        return super.getPolarity();
    }

    static /* synthetic */ Size access$000() {
        return WIDTH;
    }

    static /* synthetic */ Size access$100() {
        return LENGTH;
    }

    static /* synthetic */ Size access$200() {
        return POLE_SIZE;
    }

    static /* synthetic */ Size access$300() {
        return WIDTH_MINI;
    }

    static /* synthetic */ Size access$400() {
        return LENGTH_MINI;
    }

    static /* synthetic */ Size access$500() {
        return WIDTH_FILTERTRON;
    }

    static /* synthetic */ Size access$600() {
        return LENGTH_FILTERTRON;
    }

    static /* synthetic */ Size access$700() {
        return POLE_SIZE_FILTERTRON;
    }

    public static enum PolePieceType {
        Rods,
        Rail,
        Screws,
        None;

    }

    public static enum HumbuckerType {
        PAF(HumbuckerPickup.access$000(), HumbuckerPickup.access$100(), HumbuckerPickup.access$200()),
        Mini(HumbuckerPickup.access$300(), HumbuckerPickup.access$400(), HumbuckerPickup.access$200()),
        Filtertron(HumbuckerPickup.access$500(), HumbuckerPickup.access$600(), HumbuckerPickup.access$700());

        private Size width;
        private Size length;
        private Size poleSize;

        private HumbuckerType(Size width, Size length, Size poleSize) {
            this.width = width;
            this.length = length;
            this.poleSize = poleSize;
        }

        public Size getWidth() {
            return this.width;
        }

        public Size getLength() {
            return this.length;
        }

        public Size getPoleSize() {
            return this.poleSize;
        }

        public String toString() {
            return this.name();
        }
    }
}

