/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.passive.Voltage;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Film Capacitor (Axial)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="C", description="Axial film capacitor, similar to Mallory 150s", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class AxialFilmCapacitor
extends AbstractLeadedComponent<Capacitance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#FFE303");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    private Capacitance value = null;
    @Deprecated
    private Voltage voltage = Voltage._63V;
    private org.diylc.core.measures.Voltage voltageNew = null;

    public AxialFilmCapacitor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @Override
    protected boolean supportsStandingMode() {
        return true;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Capacitance getValue() {
        return this.value;
    }

    public void setValue(Capacitance value) {
        this.value = value;
    }

    @Deprecated
    public Voltage getVoltage() {
        return this.voltage;
    }

    @Deprecated
    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @EditableProperty(name="Voltage")
    public org.diylc.core.measures.Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(org.diylc.core.measures.Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(4, height / 2 - 3, width - 8, 6);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(4, height / 2 - 3, width - 8, 6);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @Override
    protected Shape getBodyShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getLength().convertToPixels(), this.getClosestOdd(this.getWidth().convertToPixels()));
    }

    @Override
    @EditableProperty(name="Reverse (standing)")
    public boolean getFlipStanding() {
        return super.getFlipStanding();
    }
}

