/*
 * Decompiled with CFR 0.152.
 */
import circuit.CircuitPanel;
import globals.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class FidoReadApplet
extends JApplet {
    private static final long serialVersionUID = 10L;
    CircuitPanel CC;
    Color backgroundColor;
    JScrollPane SC;

    public void init() {
        this.backgroundColor = Color.white;
        this.CC = new CircuitPanel(false);
        this.CC.setBackground(this.backgroundColor);
        this.CC.setGridVisibility(false);
        this.SC = new JScrollPane(this.CC);
        this.SC.getVerticalScrollBar().setUnitIncrement(20);
        this.SC.getHorizontalScrollBar().setUnitIncrement(20);
        this.CC.profileTime = false;
        this.CC.antiAlias = true;
        this.CC.P.loadLibraryInJar(FidoReadApplet.class.getResource("lib/IHRAM.FCL"), "ihram");
        this.CC.P.loadLibraryInJar(FidoReadApplet.class.getResource("lib/FCDstdlib.fcl"), "");
        this.CC.P.loadLibraryInJar(FidoReadApplet.class.getResource("lib/PCB_en.fcl"), "pcb");
        this.CC.P.setLayers(Globals.createStandardLayers());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.SC, "Center");
    }

    public void trace(String c, int zoom) {
        this.CC.getMapCoordinates().setMagnitudes(zoom, zoom);
        try {
            this.CC.P.parseString(new StringBuffer(c));
        }
        catch (IOException E) {
            JOptionPane.showMessageDialog(this, "Too much consecutive errors. Bad format?");
        }
        this.repaint();
        this.getToolkit().sync();
    }

    public void setAntiAlias(boolean aa) {
        this.CC.antiAlias = aa;
    }

    public void setProfileTime(boolean pp) {
        this.CC.profileTime = pp;
    }

    public void backColor(int color) {
        switch (color) {
            case 0: {
                this.backgroundColor = Color.black;
                break;
            }
            case 1: {
                this.backgroundColor = Color.blue;
                break;
            }
            case 2: {
                this.backgroundColor = Color.green;
                break;
            }
            case 3: {
                this.backgroundColor = Color.cyan.darker();
                break;
            }
            case 4: {
                this.backgroundColor = Color.red;
                break;
            }
            case 5: {
                this.backgroundColor = Color.magenta;
                break;
            }
            case 6: {
                this.backgroundColor = Color.orange;
                break;
            }
            case 7: {
                this.backgroundColor = Color.lightGray;
                break;
            }
            case 8: {
                this.backgroundColor = Color.gray;
                break;
            }
            case 9: {
                this.backgroundColor = new Color(128, 128, 255);
                break;
            }
            case 10: {
                this.backgroundColor = new Color(128, 255, 128);
                break;
            }
            case 11: {
                this.backgroundColor = new Color(128, 255, 255);
                break;
            }
            case 12: {
                this.backgroundColor = new Color(255, 128, 128);
                break;
            }
            case 13: {
                this.backgroundColor = Color.pink;
                break;
            }
            case 14: {
                this.backgroundColor = Color.yellow;
                break;
            }
            default: {
                this.backgroundColor = Color.white;
            }
        }
        this.CC.setBackground(this.backgroundColor);
    }
}

