/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.ParseSchem;
import clipboard.TextTransfer;
import dialogs.DialogParameters;
import dialogs.ParameterDescription;
import geom.ChangeCoordinatesListener;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.PrimitiveAdvText;
import primitives.PrimitiveBezier;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveConnection;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePCBPad;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;
import timer.MyTimer;
import toolbars.ChangeGridState;
import toolbars.ChangeSelectedLayer;
import toolbars.ChangeSelectionListener;
import toolbars.ChangeZoomListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitPanel
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener,
ChangeSelectedLayer,
ChangeGridState,
ChangeZoomListener,
ChangeSelectionListener {
    public transient ParseSchem P;
    private transient MapCoordinates cs;
    public boolean isFilled;
    public boolean antiAlias = true;
    private boolean isGridVisible = true;
    public int PCB_pad_sizex;
    public int PCB_pad_sizey;
    public int PCB_pad_style;
    public int PCB_pad_drill;
    public int PCB_thickness;
    private Color backgroundColor = Color.white;
    private Rectangle evidenceRect;
    public static final int MARGIN = 20;
    static final Color editingColor = Color.green;
    private static final String rulerFont = "Lucida Sans Regular";
    public boolean profileTime;
    private double average;
    private double record;
    private double runs;
    private double record_c;
    private double record_d;
    private int oldx;
    private int oldy;
    private Rectangle scrollRectangle;
    private boolean successiveMove;
    public boolean extStrict;
    public boolean splitNonStandardMacro_s;
    public boolean splitNonStandardMacro_c;
    private int clickNumber;
    public static final int NPOLY = 256;
    private int[] xpoly;
    private int[] ypoly;
    static final int SEL_TOLERANCE = 10;
    private int currentLayer;
    private int actionSelected;
    private String macroKey;
    private transient GraphicPrimitive primEdit = null;
    public static final int NONE = 0;
    public static final int SELECTION = 1;
    public static final int ZOOM = 2;
    public static final int HAND = 3;
    public static final int LINE = 4;
    public static final int TEXT = 5;
    public static final int BEZIER = 6;
    public static final int POLYGON = 7;
    public static final int ELLIPSE = 8;
    public static final int RECTANGLE = 9;
    public static final int CONNECTION = 10;
    public static final int PCB_LINE = 11;
    public static final int PCB_PAD = 12;
    public static final int MACRO = 13;
    public static final int COMPLEXCURVE = 14;
    JPopupMenu popup;
    JMenuItem editCut;
    JMenuItem editCopy;
    JMenuItem editPaste;
    JMenuItem editRotate;
    JMenuItem editMirror;
    JMenuItem editAddNode;
    JMenuItem editRemoveNode;
    int menux;
    int menuy;
    private ChangeZoomListener zoomListener = null;
    private ChangeSelectionListener selectionListener;
    private ChangeSelectionListener scrollGestureSelectionListener;
    private ChangeCoordinatesListener coordinatesListener;
    private int rulerStartX;
    private int rulerStartY;
    private int rulerEndX;
    private int rulerEndY;
    private boolean ruler;

    public CircuitPanel(boolean isEditable) {
        this.P = new ParseSchem();
        this.record_c = this.record = 1.0E100;
        this.record_d = this.record;
        this.evidenceRect = new Rectangle(0, 0, -1, -1);
        this.cs = new MapCoordinates();
        this.cs.setXCenter(0.0);
        this.cs.setYCenter(0.0);
        this.cs.setXMagnitude(4.0);
        this.cs.setYMagnitude(4.0);
        this.cs.setOrientation(0);
        this.setOpaque(true);
        this.runs = 0.0;
        this.average = 0.0;
        this.currentLayer = 0;
        this.PCB_thickness = 5;
        this.PCB_pad_sizex = 5;
        this.PCB_pad_sizey = 5;
        this.PCB_pad_drill = 2;
        this.xpoly = new int[256];
        this.ypoly = new int[256];
        this.splitNonStandardMacro_s = false;
        this.splitNonStandardMacro_c = false;
        if (isEditable) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFocusable(true);
            this.registerActiveKeys();
            this.popup = new JPopupMenu();
            this.editCut = new JMenuItem(Globals.messages.getString("Cut"));
            this.editCopy = new JMenuItem(Globals.messages.getString("Copy"));
            this.editPaste = new JMenuItem(Globals.messages.getString("Paste"));
            this.editRotate = new JMenuItem(Globals.messages.getString("Rotate"));
            this.editMirror = new JMenuItem(Globals.messages.getString("Mirror_E"));
            this.editAddNode = new JMenuItem(Globals.messages.getString("Add_node"));
            this.editRemoveNode = new JMenuItem(Globals.messages.getString("Remove_node"));
            this.popup.add(this.editCut);
            this.popup.add(this.editCopy);
            this.popup.add(this.editPaste);
            this.popup.addSeparator();
            this.popup.add(this.editRotate);
            this.popup.add(this.editMirror);
            this.popup.add(this.editAddNode);
            this.popup.add(this.editRemoveNode);
            this.editCut.addActionListener(this);
            this.editCopy.addActionListener(this);
            this.editPaste.addActionListener(this);
            this.editRotate.addActionListener(this);
            this.editMirror.addActionListener(this);
            this.editAddNode.addActionListener(this);
            this.editRemoveNode.addActionListener(this);
        }
    }

    private void registerAction(String actionString, char key, final int state) {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toUpperCase(key)), actionString);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toLowerCase(key)), actionString);
        this.getActionMap().put(actionString, new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.setSelectionState(state, "");
                CircuitPanel.this.primEdit = null;
                CircuitPanel.this.repaint();
            }
        });
    }

    public void registerActiveKeys() {
        this.registerAction("selection", 'a', 1);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0, false), "selection");
        this.registerAction("line", 'l', 4);
        this.registerAction("text", 't', 5);
        this.registerAction("bezier", 'b', 6);
        this.registerAction("polygon", 'p', 7);
        this.registerAction("complexcurve", 'o', 14);
        this.registerAction("ellipse", 'e', 8);
        this.registerAction("rectangle", 'g', 9);
        this.registerAction("connection", 'c', 10);
        this.registerAction("pcbline", 'i', 11);
        this.registerAction("pcbpad", 'z', 12);
        String delete = "delete";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.P.deleteAllSelected();
                CircuitPanel.this.repaint();
            }
        });
        String escape = "escape";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.getActionMap().put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                if (CircuitPanel.this.clickNumber > 0) {
                    CircuitPanel.this.successiveMove = false;
                    CircuitPanel.this.clickNumber = 0;
                    CircuitPanel.this.primEdit = null;
                    CircuitPanel.this.repaint();
                }
            }
        });
        String left = "lleft";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(37, 8, false), "lleft");
        this.getActionMap().put("lleft", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.P.moveAllSelected(-1, 0);
                CircuitPanel.this.repaint();
            }
        });
        String right = "lright";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(39, 8, false), "lright");
        this.getActionMap().put("lright", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.P.moveAllSelected(1, 0);
                CircuitPanel.this.repaint();
            }
        });
        String up = "lup";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8, false), "lup");
        this.getActionMap().put("lup", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.P.moveAllSelected(0, -1);
                CircuitPanel.this.repaint();
            }
        });
        String down = "ldown";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8, false), "ldown");
        this.getActionMap().put("ldown", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.P.moveAllSelected(0, 1);
                CircuitPanel.this.repaint();
            }
        });
    }

    public boolean isEnteringMacro() {
        return this.primEdit != null && this.primEdit instanceof PrimitiveMacro;
    }

    public void rotateMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.rotatePrimitive(false, this.primEdit.getFirstPoint().x, this.primEdit.getFirstPoint().y);
        }
    }

    public void mirrorMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.mirrorPrimitive(this.primEdit.getFirstPoint().x);
        }
    }

    @Override
    public void setSelectionState(int s, String macro) {
        if (this.selectionListener != null && s != this.actionSelected) {
            this.selectionListener.setSelectionState(s, macro);
            this.selectionListener.setStrictCompatibility(this.extStrict);
        }
        this.actionSelected = s;
        if (this.scrollGestureSelectionListener != null) {
            this.scrollGestureSelectionListener.setSelectionState(s, macro);
        }
        this.clickNumber = 0;
        this.successiveMove = false;
        this.selectCursor();
        this.macroKey = macro;
    }

    @Override
    public int getSelectionState() {
        return this.actionSelected;
    }

    public void setScrollRectangle(Rectangle r) {
        this.scrollRectangle = r;
        this.scrollRectToVisible(r);
    }

    public void addChangeZoomListener(ChangeZoomListener c) {
        this.zoomListener = c;
    }

    public void addChangeSelectionListener(ChangeSelectionListener c) {
        this.selectionListener = c;
    }

    public void addScrollGestureSelectionListener(ChangeSelectionListener c) {
        this.scrollGestureSelectionListener = c;
    }

    public void addChangeCoordinatesListener(ChangeCoordinatesListener c) {
        this.coordinatesListener = c;
    }

    public int getCurrentLayer() {
        return this.currentLayer;
    }

    public void setCurrentLayer(int l) {
        if (l < 0) {
            l = 0;
        }
        if (l >= this.P.getLayers().size()) {
            l = this.P.getLayers().size() - 1;
        }
        this.currentLayer = l;
    }

    public void setCirc(StringBuffer c) throws IOException {
        this.P.parseString(c);
    }

    public StringBuffer getCirc(boolean extensions) {
        return this.P.getText(extensions);
    }

    @Override
    public void changeSelectedLayer(int s) {
        this.currentLayer = s;
    }

    @Override
    public void setGridVisibility(boolean v) {
        this.isGridVisible = v;
        this.repaint();
    }

    @Override
    public void setSnapState(boolean v) {
        this.cs.setSnap(v);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.requestFocusInWindow();
        if (this.actionSelected == 1 && evt.getClickCount() >= 2) {
            this.setPropertiesForPrimitive();
        }
    }

    private void handleClick(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.requestFocusInWindow();
        if (this.clickNumber > 255) {
            this.clickNumber = 255;
        }
        this.coordinatesListener.changeInfos("");
        if (this.actionSelected != 13) {
            this.primEdit = null;
        }
        switch (this.actionSelected) {
            default: {
                break;
            }
            case 0: {
                this.clickNumber = 0;
                break;
            }
            case 1: {
                int toll;
                this.clickNumber = 0;
                if (evt.getClickCount() >= 2) {
                    this.setPropertiesForPrimitive();
                    break;
                }
                if (evt.getButton() == 3) {
                    boolean s = false;
                    if (this.P.getFirstSelectedPrimitive() != null) {
                        s = true;
                    }
                    this.editCut.setEnabled(s);
                    this.editCopy.setEnabled(s);
                    this.editRotate.setEnabled(s);
                    this.editMirror.setEnabled(s);
                    s = this.P.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve || this.P.getFirstSelectedPrimitive() instanceof PrimitivePolygon;
                    this.editAddNode.setEnabled(s);
                    this.editRemoveNode.setEnabled(s);
                    this.editAddNode.setVisible(s);
                    this.editRemoveNode.setVisible(s);
                    TextTransfer textTransfer = new TextTransfer();
                    if (textTransfer.getClipboardContents().equals("")) {
                        this.editPaste.setEnabled(false);
                    } else {
                        this.editPaste.setEnabled(true);
                    }
                    this.menux = evt.getX();
                    this.menuy = evt.getY();
                    this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
                    break;
                }
                boolean toggle = false;
                toggle = Globals.useMetaForMultipleSelection ? evt.isMetaDown() : evt.isControlDown();
                if (!toggle) {
                    this.P.deselectAll();
                }
                if ((toll = this.cs.unmapXnosnap(x + 10) - this.cs.unmapXnosnap(x)) < 2) {
                    toll = 2;
                }
                this.P.selectPrimitive(this.cs.unmapXnosnap(x), this.cs.unmapYnosnap(y), toll, toggle);
                break;
            }
            case 2: {
                this.cs.unmapXsnap(x);
                this.cs.unmapYsnap(y);
                double z = this.cs.getXMagnitude();
                z = (evt.getModifiers() & 4) == 0 ? z * 3.0 / 2.0 : z * 2.0 / 3.0;
                if (z > 20.0) {
                    z = 20.0;
                }
                if (z < 0.25) {
                    z = 0.25;
                }
                z = (double)Math.round(z * 100.0) / 100.0;
                this.cs.setMagnitudes(z, z);
                this.repaint();
                break;
            }
            case 10: {
                if ((evt.getModifiers() & 4) == 4) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                PrimitiveConnection g = new PrimitiveConnection(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), this.currentLayer);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                this.repaint();
                break;
            }
            case 12: {
                if ((evt.getModifiers() & 4) == 4) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                PrimitivePCBPad g = new PrimitivePCBPad(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), this.PCB_pad_sizex, this.PCB_pad_sizey, this.PCB_pad_drill, this.PCB_pad_style, this.currentLayer);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                this.repaint();
                break;
            }
            case 4: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                ++this.clickNumber;
                if (evt.getClickCount() >= 2) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                if (this.clickNumber != 2 && (evt.getModifiers() & 4) == 0) break;
                PrimitiveLine g = new PrimitiveLine(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.currentLayer, false, false, 0, 3, 2, 0);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                if ((evt.getModifiers() & 4) == 0) {
                    this.clickNumber = 1;
                    this.xpoly[1] = this.xpoly[2];
                    this.ypoly[1] = this.ypoly[2];
                } else {
                    this.clickNumber = 0;
                }
                this.repaint();
                break;
            }
            case 5: {
                if ((evt.getModifiers() & 4) != 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if (evt.getClickCount() >= 2) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                PrimitiveAdvText newtext = new PrimitiveAdvText(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), 3, 4, this.P.getTextFont(), 0, 0, "String", this.currentLayer);
                this.P.deselectAll();
                this.P.addPrimitive(newtext, true, true);
                newtext.setSelected(true);
                this.repaint();
                this.setPropertiesForPrimitive();
                break;
            }
            case 6: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if ((evt.getModifiers() & 4) != 0) {
                    this.clickNumber = 0;
                    this.repaint();
                    break;
                }
                ++this.clickNumber;
                if (this.clickNumber <= 2) {
                    this.successiveMove = false;
                }
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                if (this.clickNumber != 4) break;
                PrimitiveBezier g = new PrimitiveBezier(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.xpoly[3], this.ypoly[3], this.xpoly[4], this.ypoly[4], this.currentLayer, false, false, 0, 3, 2, 0);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                this.clickNumber = 0;
                this.repaint();
                break;
            }
            case 7: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if (evt.getClickCount() >= 2) {
                    PrimitivePolygon poly = new PrimitivePolygon(this.isFilled, this.currentLayer, 0);
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        poly.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    poly.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                    this.P.addPrimitive(poly, true, true);
                    this.clickNumber = 0;
                    this.repaint();
                    break;
                }
                ++this.clickNumber;
                if (this.clickNumber <= 2) {
                    this.successiveMove = false;
                }
                if (this.clickNumber == 256) {
                    return;
                }
                if (this.clickNumber == 256) {
                    return;
                }
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                break;
            }
            case 14: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if (evt.getClickCount() >= 2) {
                    PrimitiveComplexCurve compc = new PrimitiveComplexCurve(this.isFilled, false, this.currentLayer, false, false, 0, 3, 2, 0);
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        compc.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    compc.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                    this.P.addPrimitive(compc, true, true);
                    this.clickNumber = 0;
                    this.repaint();
                    break;
                }
                ++this.clickNumber;
                if (this.clickNumber <= 2) {
                    this.successiveMove = false;
                }
                if (this.clickNumber == 256) {
                    return;
                }
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                break;
            }
            case 8: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if (evt.isControlDown() && this.clickNumber > 0) {
                    y = this.cs.mapY(this.xpoly[1], this.ypoly[1]) + (x - this.cs.mapX(this.xpoly[1], this.ypoly[1]));
                }
                ++this.clickNumber;
                this.successiveMove = false;
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                if (this.clickNumber != 2) break;
                PrimitiveOval g = new PrimitiveOval(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.isFilled, this.currentLayer, 0);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                this.clickNumber = 0;
                this.repaint();
                break;
            }
            case 9: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                if (evt.isControlDown() && this.clickNumber > 0) {
                    y = this.cs.mapY(this.xpoly[1], this.ypoly[1]) + (x - this.cs.mapX(this.xpoly[1], this.ypoly[1]));
                }
                ++this.clickNumber;
                this.successiveMove = false;
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                if (this.clickNumber == 2) {
                    PrimitiveRectangle g = new PrimitiveRectangle(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.isFilled, this.currentLayer, 0);
                    g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                    this.P.addPrimitive(g, true, true);
                    this.clickNumber = 0;
                    this.repaint();
                }
                if (this.clickNumber < 2) break;
                this.clickNumber = 0;
                break;
            }
            case 11: {
                if ((evt.getModifiers() & 4) != 0 && this.clickNumber == 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                ++this.clickNumber;
                if (evt.getClickCount() >= 2) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.xpoly[this.clickNumber] = this.cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = this.cs.unmapYsnap(y);
                if (this.clickNumber != 2 && (evt.getModifiers() & 4) == 0) break;
                PrimitivePCBLine g = new PrimitivePCBLine(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.PCB_thickness, this.currentLayer);
                g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, true);
                if ((evt.getModifiers() & 4) == 0) {
                    this.clickNumber = 1;
                    this.xpoly[1] = this.xpoly[2];
                    this.ypoly[1] = this.ypoly[2];
                } else {
                    this.clickNumber = 0;
                }
                this.repaint();
                break;
            }
            case 13: {
                this.successiveMove = false;
                if ((evt.getModifiers() & 4) != 0) {
                    this.selectAndSetProperties(x, y);
                    break;
                }
                try {
                    this.P.deselectAll();
                    int orientation = 0;
                    boolean mirror = false;
                    if (this.primEdit instanceof PrimitiveMacro) {
                        orientation = ((PrimitiveMacro)this.primEdit).getOrientation();
                        mirror = ((PrimitiveMacro)this.primEdit).isMirrored();
                    }
                    this.P.addPrimitive(new PrimitiveMacro(this.P.getLibrary(), this.P.getLayers(), this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), this.macroKey, "", this.cs.unmapXsnap(x) + 10, this.cs.unmapYsnap(y) + 5, "", this.cs.unmapXsnap(x) + 10, this.cs.unmapYsnap(y) + 10, this.P.getTextFont(), this.P.getTextFontSize(), orientation, mirror), true, true);
                    this.primEdit = null;
                    this.successiveMove = false;
                }
                catch (IOException G) {
                    System.out.println(G);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int xa = evt.getX();
        int ya = evt.getY();
        int x = this.cs.mapX(this.cs.unmapXsnap(xa), 0.0);
        int y = this.cs.mapY(0.0, this.cs.unmapYsnap(ya));
        if (this.coordinatesListener != null) {
            this.coordinatesListener.changeCoordinates(this.cs.unmapXsnap(xa), this.cs.unmapYsnap(ya));
        }
        if (x == this.oldx && y == this.oldy) {
            return;
        }
        Graphics g = this.getGraphics();
        if (this.actionSelected != 13) {
            this.primEdit = null;
        } else if (this.primEdit != null) {
            this.requestFocusInWindow();
        }
        if (this.actionSelected == 13) {
            try {
                int orientation = 0;
                boolean mirror = false;
                if (this.primEdit instanceof PrimitiveMacro) {
                    orientation = ((PrimitiveMacro)this.primEdit).getOrientation();
                    mirror = ((PrimitiveMacro)this.primEdit).isMirrored();
                }
                PrimitiveMacro n = new PrimitiveMacro(this.P.getLibrary(), this.createEditingLayerArray(), this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), this.macroKey, "", this.cs.unmapXsnap(x) + 10, this.cs.unmapYsnap(y) + 5, "", this.cs.unmapXsnap(x) + 10, this.cs.unmapYsnap(y) + 10, this.P.getTextFont(), this.P.getTextFontSize(), orientation, mirror);
                n.setDrawOnlyLayer(-1);
                this.primEdit = n;
                this.repaint();
                this.successiveMove = true;
            }
            catch (IOException E) {
                // empty catch block
            }
        }
        if (this.clickNumber == 0) {
            g.dispose();
            this.oldx = x;
            this.oldy = y;
            return;
        }
        if (this.actionSelected == 4) {
            this.primEdit = new PrimitiveLine(this.xpoly[1], this.ypoly[1], this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), 0, false, false, 0, 3, 2, 0);
            this.repaint();
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double w = Math.sqrt((this.xpoly[1] - this.cs.unmapXsnap(xa)) * (this.xpoly[1] - this.cs.unmapXsnap(xa)) + (this.ypoly[1] - this.cs.unmapYsnap(ya)) * (this.ypoly[1] - this.cs.unmapYsnap(ya)));
                double wmm = w * 127.0 / 1000.0;
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + this.roundTo(w, 2) + " (" + this.roundTo(wmm, 2) + " mm)");
            }
        }
        if (this.actionSelected == 11) {
            this.primEdit = new PrimitivePCBLine(this.xpoly[1], this.ypoly[1], this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), this.PCB_thickness, 0);
            this.repaint();
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double w = Math.sqrt((this.xpoly[1] - this.cs.unmapXsnap(xa)) * (this.xpoly[1] - this.cs.unmapXsnap(xa)) + (this.ypoly[1] - this.cs.unmapYsnap(ya)) * (this.ypoly[1] - this.cs.unmapYsnap(ya)));
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + this.roundTo(w, 2));
            }
        }
        if (this.actionSelected == 6) {
            this.primEdit = new PrimitivePolygon(false, 0, 0);
            for (int i = 1; i <= this.clickNumber; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y));
            this.repaint();
            this.successiveMove = true;
        }
        if (this.actionSelected == 7) {
            this.primEdit = new PrimitivePolygon(false, 0, 0);
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y));
            this.repaint();
            this.successiveMove = true;
        }
        if (this.actionSelected == 14) {
            this.primEdit = new PrimitiveComplexCurve(false, false, 0, false, false, 0, 3, 2, 0);
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitiveComplexCurve)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitiveComplexCurve)this.primEdit).addPoint(this.cs.unmapXsnap(x), this.cs.unmapYsnap(y));
            this.repaint();
            this.successiveMove = true;
        }
        if (this.actionSelected == 9) {
            if (evt.isControlDown() && this.clickNumber > 0) {
                y = this.cs.mapY(this.xpoly[1], this.ypoly[1]) + (x - this.cs.mapX(this.xpoly[1], this.ypoly[1]));
            }
            this.primEdit = new PrimitiveRectangle(this.xpoly[1], this.ypoly[1], this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), false, 0, 0);
            this.repaint();
            this.successiveMove = true;
        }
        if (this.actionSelected == 8) {
            if (evt.isControlDown() && this.clickNumber > 0) {
                y = this.cs.mapY(this.xpoly[1], this.ypoly[1]) + (x - this.cs.mapX(this.xpoly[1], this.ypoly[1]));
            }
            this.primEdit = new PrimitiveOval(this.xpoly[1], this.ypoly[1], this.cs.unmapXsnap(x), this.cs.unmapYsnap(y), false, 0, 0);
            this.repaint();
            this.successiveMove = true;
        }
        this.oldx = x;
        this.oldy = y;
        g.dispose();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        this.ruler = false;
        this.rulerStartX = px;
        this.rulerStartY = py;
        this.rulerEndX = px;
        this.rulerEndY = py;
        boolean multiple = evt.isControlDown();
        if (Globals.useMetaForMultipleSelection) {
            multiple = evt.isMetaDown();
        }
        if (this.actionSelected == 1 && (evt.getModifiers() & 4) == 0 && !evt.isShiftDown()) {
            this.P.dragHandleStart(px, py, 10, multiple, this.cs);
        } else if (this.actionSelected == 1) {
            this.ruler = true;
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_c) {
                this.record_c = elapsed;
            }
            System.out.println("MP: Time elapsed: " + elapsed + "; record: " + this.record_c + " ms");
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        Graphics g = this.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        if ((evt.getModifiers() & 4) != 0 || evt.isShiftDown()) {
            this.rulerEndX = px;
            this.rulerEndY = py;
            this.repaint();
            return;
        }
        this.P.dragHandleDrag(this, g2d, px, py, this.cs);
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_d) {
                this.record_d = elapsed;
            }
            System.out.println("MD: Time elapsed: " + elapsed + "; record: " + this.record_d + " ms");
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        boolean multiple = evt.isControlDown();
        if (Globals.useMetaForMultipleSelection) {
            multiple = evt.isMetaDown();
        }
        if (this.actionSelected == 1) {
            if (this.rulerStartX != px || this.rulerStartY != py) {
                this.P.dragHandleEnd(this, px, py, multiple, this.cs);
            } else {
                this.ruler = false;
                this.handleClick(evt);
            }
            this.repaint();
        } else {
            this.handleClick(evt);
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_d) {
                this.record_d = elapsed;
            }
            System.out.println("MR: Time elapsed: " + elapsed + "; record: " + this.record_d + " ms");
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.selectCursor();
    }

    public void selectCursor() {
        switch (this.actionSelected) {
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 2: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.setCursor(Cursor.getPredefinedCursor(1));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.successiveMove) {
            this.successiveMove = false;
            this.primEdit = null;
            this.repaint();
        }
    }

    @Override
    public void changeZoom(double z) {
        z = (double)Math.round(z * 100.0) / 100.0;
        this.cs.setMagnitudes(z, z);
        this.successiveMove = false;
        this.repaint();
    }

    @Override
    public void setBackground(Color sfondo) {
        this.backgroundColor = sfondo;
    }

    public void setEvidenceRect(int lx, int ly, int w, int h) {
        this.evidenceRect = new Rectangle();
        this.evidenceRect.x = lx;
        this.evidenceRect.y = ly;
        this.evidenceRect.height = h;
        this.evidenceRect.width = w;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        MyTimer mt = new MyTimer();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isGridVisible) {
            this.P.drawGrid(g2, this.cs, 0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(Color.black);
        this.P.draw(g2, this.cs);
        if (this.zoomListener != null) {
            this.zoomListener.changeZoom(this.cs.getXMagnitude());
        }
        this.P.drawSelectedHandles(g2, this.cs);
        g.setColor(editingColor);
        g2.setStroke(new BasicStroke(1.0f));
        if (this.evidenceRect != null && this.actionSelected == 1) {
            g.drawRect(this.evidenceRect.x, this.evidenceRect.y, this.evidenceRect.width, this.evidenceRect.height);
        } else {
            this.evidenceRect = null;
        }
        this.drawPrimEdit(g2);
        if (this.ruler) {
            this.drawRuler(g, this.rulerStartX, this.rulerStartY, this.rulerEndX, this.rulerEndY);
        }
        if (this.cs.getXMax() > 0 && this.cs.getYMax() > 0) {
            this.setPreferredSize(new Dimension(this.cs.getXMax() + 20, this.cs.getYMax() + 20));
            this.revalidate();
        }
        if (this.scrollRectangle != null) {
            Rectangle r = this.scrollRectangle;
            this.scrollRectangle = null;
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            g2.drawString("Version: 0.24.1", 0, 100);
            g.drawString("Time elapsed: " + elapsed + " ms", 0, 50);
            this.runs += 1.0;
            this.average += elapsed;
            if (elapsed < this.record) {
                this.record = elapsed;
            }
            System.out.println("R: Time elapsed: " + elapsed + " averaging " + this.average / this.runs + "ms in " + this.runs + " redraws; record: " + this.record + " ms");
        }
    }

    @Override
    public void validate() {
        if (this.cs.getXMax() > 0 && this.cs.getYMax() > 0) {
            this.setPreferredSize(new Dimension(this.cs.getXMax() + 20, this.cs.getYMax() + 20));
        }
        super.validate();
    }

    private void drawPrimEdit(Graphics2D g2) {
        if (this.primEdit != null) {
            this.primEdit.draw(g2, this.cs, this.createEditingLayerArray());
        }
    }

    private Vector<LayerDesc> createEditingLayerArray() {
        Vector<LayerDesc> ll = new Vector<LayerDesc>();
        for (int i = 0; i < 16; ++i) {
            ll.add(new LayerDesc(editingColor, true, "", 1.0f));
        }
        return ll;
    }

    private void drawRuler(Graphics g, int sx, int sy, int ex, int ey) {
        int xa = this.cs.unmapXnosnap(sx);
        int ya = this.cs.unmapYnosnap(sy);
        int xb = this.cs.unmapXnosnap(ex);
        int yb = this.cs.unmapYnosnap(ey);
        double length = Math.sqrt((double)(xa - xb) * (double)(xa - xb) + (double)((ya - yb) * (ya - yb)));
        g.drawLine(sx, sy, ex, ey);
        double alpha = sx != ex ? Math.atan((double)(ey - sy) / (double)(ex - sx)) : 1.5707963267948966 + (ey - sy < 0 ? 0.0 : Math.PI);
        alpha += ex - sx > 0 ? 0.0 : Math.PI;
        double l = 5.0;
        l = this.cs.getXMagnitude() < 1.0 ? 10.0 : (this.cs.getXMagnitude() > 5.0 ? 1.0 : 5.0);
        double ll = 0.0;
        double ld = 5.0;
        int m = 5;
        int j = 0;
        double dex = (double)sx + length * Math.cos(alpha) * this.cs.getXMagnitude();
        double dey = (double)sy + length * Math.sin(alpha) * this.cs.getYMagnitude();
        alpha += 1.5707963267948966;
        boolean debut = true;
        for (double i = 0.0; i <= length; i += l) {
            if (j++ == m || debut) {
                j = 1;
                ll = 2.0 * ld;
                debut = false;
            } else {
                ll = ld;
            }
            double x = dex * i / length + (double)sx * (length - i) / length;
            double y = dey * i / length + (double)sy * (length - i) / length;
            int x1 = (int)(x - ll * Math.cos(alpha));
            int x2 = (int)(x + ll * Math.cos(alpha));
            int y1 = (int)(y - ll * Math.sin(alpha));
            int y2 = (int)(y + ll * Math.sin(alpha));
            g.drawLine(x1, y1, x2, y2);
        }
        Font f = new Font(rulerFont, 0, 10);
        g.setFont(f);
        String t1 = this.roundTo(length, 2);
        String t2 = this.roundTo(length * 0.127, 2) + " mm";
        FontMetrics fm = g.getFontMetrics(f);
        g.setColor(Color.white);
        g.fillRect(ex + 10, ey, Math.max(fm.stringWidth(t1), fm.stringWidth(t2)) + 1, 24);
        g.setColor(editingColor);
        g.drawRect(ex + 9, ey - 1, Math.max(fm.stringWidth(t1), fm.stringWidth(t2)) + 2, 25);
        g.setColor(editingColor.darker().darker());
        g.drawString(t1, ex + 10, ey + 10);
        g.drawString(t2, ex + 10, ey + 20);
    }

    public void setPCB_pad_sizex(int s) {
        this.PCB_pad_sizex = s;
    }

    public int getPCB_pad_sizex() {
        return this.PCB_pad_sizex;
    }

    public void setPCB_pad_sizey(int s) {
        this.PCB_pad_sizey = s;
    }

    public int getPCB_pad_sizey() {
        return this.PCB_pad_sizey;
    }

    public void setPCB_pad_style(int s) {
        this.PCB_pad_style = s;
    }

    public int getPCB_pad_style() {
        return this.PCB_pad_style;
    }

    public void setPCB_pad_drill(int s) {
        this.PCB_pad_drill = s;
    }

    public int getPCB_pad_drill() {
        return this.PCB_pad_drill;
    }

    public void setPCB_thickness(int s) {
        this.PCB_thickness = s;
    }

    public int getPCB_thickness() {
        return this.PCB_thickness;
    }

    private void setPropertiesForPrimitive() {
        GraphicPrimitive gp = this.P.getFirstSelectedPrimitive();
        if (gp != null) {
            Vector<ParameterDescription> v = gp.getControls();
            DialogParameters dp = new DialogParameters(null, v, this.extStrict, this.P.getLayers());
            dp.setVisible(true);
            if (dp.active) {
                gp.setControls(dp.getCharacteristics());
                this.P.setChanged(true);
                this.P.sortPrimitiveLayers();
                this.P.saveUndoState();
                this.repaint();
            }
        }
    }

    private void selectAndSetProperties(int x, int y) {
        this.P.deselectAll();
        this.P.selectPrimitive(this.cs.unmapXnosnap(x), this.cs.unmapYnosnap(y), this.cs.unmapXnosnap(x + 10) - this.cs.unmapXnosnap(x), false);
        this.repaint();
        this.setPropertiesForPrimitive();
    }

    public boolean getStrictCompatibility() {
        return this.extStrict;
    }

    @Override
    public void setStrictCompatibility(boolean strict) {
        this.extStrict = strict;
    }

    private String roundTo(double n, int ch) {
        return "" + (double)((int)(n * Math.pow(10.0, ch))) / Math.pow(10.0, ch);
    }

    public void setMapCoordinates(MapCoordinates m) {
        this.cs = m;
    }

    public MapCoordinates getMapCoordinates() {
        return this.cs;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            String arg = evt.getActionCommand();
            if (arg.equals(Globals.messages.getString("Copy"))) {
                this.P.copySelected(!this.extStrict, this.splitNonStandardMacro_c, this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
            } else if (arg.equals(Globals.messages.getString("Cut"))) {
                this.P.copySelected(!this.extStrict, this.splitNonStandardMacro_c, this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
                this.P.deleteAllSelected();
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Paste"))) {
                this.P.paste(this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Rotate"))) {
                if (!this.isEnteringMacro()) {
                    this.P.rotateAllSelected();
                } else {
                    this.rotateMacro();
                }
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Mirror_E"))) {
                if (!this.isEnteringMacro()) {
                    this.P.mirrorAllSelected();
                } else {
                    this.mirrorMacro();
                }
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Remove_node"))) {
                if (this.P.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon poly = (PrimitivePolygon)this.P.getFirstSelectedPrimitive();
                    poly.removePoint(this.getMapCoordinates().unmapXnosnap(this.menux), this.getMapCoordinates().unmapYnosnap(this.menuy), 1.0);
                    this.P.saveUndoState();
                    this.repaint();
                } else if (this.P.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve curve = (PrimitiveComplexCurve)this.P.getFirstSelectedPrimitive();
                    curve.removePoint(this.getMapCoordinates().unmapXnosnap(this.menux), this.getMapCoordinates().unmapYnosnap(this.menuy), 1.0);
                    this.P.saveUndoState();
                    this.repaint();
                }
            } else if (arg.equals(Globals.messages.getString("Add_node"))) {
                if (this.P.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon poly = (PrimitivePolygon)this.P.getFirstSelectedPrimitive();
                    poly.addPointClosest(this.getMapCoordinates().unmapXsnap(this.menux), this.getMapCoordinates().unmapYsnap(this.menuy));
                    this.P.saveUndoState();
                    this.repaint();
                } else if (this.P.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve poly = (PrimitiveComplexCurve)this.P.getFirstSelectedPrimitive();
                    poly.addPointClosest(this.getMapCoordinates().unmapXsnap(this.menux), this.getMapCoordinates().unmapYsnap(this.menuy));
                    this.P.saveUndoState();
                    this.repaint();
                }
            }
        }
    }
}

