/*
 * Decompiled with CFR 0.152.
 */
package export;

import export.ExportInterface;
import globals.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;
import primitives.MacroDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportEPS
implements ExportInterface {
    private File fileExp;
    private FileWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private double actualWidth;
    private Color actualColor;
    private int actualDash;
    static final int PREC = 3;
    static final String[] dash = new String[]{"[5.0 10]", "[2.5 2.5]", "[1.0 1.0]", "[1.0 2.5]", "[1.0 2.5 2.5 2.5]"};

    public int cLe(double l) {
        return (int)l;
    }

    public ExportEPS(File f) throws IOException {
        this.fileExp = f;
        this.fstream = new FileWriter(this.fileExp);
    }

    @Override
    public void exportStart(Dimension totalSize, Vector<LayerDesc> la, int grid) throws IOException {
        this.layerV = la;
        this.out = new BufferedWriter(this.fstream);
        int wi = totalSize.width;
        int he = totalSize.height;
        double res_mult = 2.7777777777777777;
        this.out.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        this.out.write("%%Pages: 0\n");
        this.out.write("%%BoundingBox: -1 -1 " + (int)((double)totalSize.width / res_mult + 1.0) + " " + (int)((double)totalSize.height / res_mult + 1.0) + "\n");
        this.out.write("%%Creator: FidoCadJ 0.24.1, EPS export filter by Davide Bucci\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        this.out.write("%%CreationDate: " + dateFormat.format(date) + "\n");
        this.out.write("%%EndComments\n");
        this.out.write("/ellipsedict 8 dict def\nellipsedict /mtrx matrix put\n/ellipse\n\t{ ellipsedict begin\n\t  /endangle exch def\n\t  /startangle exch def\n\t  /yrad exch def\n\t  /xrad exch def\n\t  /y exch def\n\t  /x exch def\n\t  /savematrix mtrx currentmatrix def\n\t  x y translate\n\t  xrad yrad scale\n\t  0 0 1 startangle endangle arc\n\t  savematrix setmatrix\n\t  end\n\t} def\n");
        this.out.write("0 " + (double)totalSize.height / res_mult + " translate\n");
        this.out.write("" + 1.0 / res_mult + " " + -1.0 / res_mult + " scale\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("%%EOF\n");
        this.out.close();
    }

    @Override
    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        String bold = "";
        int ys = (int)((double)(sizex * 12) / 7.0 + 0.5);
        if (isBold) {
            bold = "-Bold";
        }
        HashMap<String, String> substFont = new HashMap<String, String>();
        substFont.put(" ", "-");
        fontname = Globals.substituteBizarreChars(fontname, substFont);
        this.out.write("/" + fontname + bold + " findfont\n" + ys + " scalefont\n" + "setfont\n");
        this.out.write("newpath\n");
        this.out.write("" + x + " " + y + " moveto\n");
        this.out.write("gsave\n");
        if (orientation != 0) {
            this.out.write("  " + (isMirrored ? orientation : -orientation) + " rotate\n");
        }
        if (isMirrored) {
            this.out.write("  -1 -1 scale\n");
        } else {
            this.out.write("  1 -1 scale\n");
        }
        double ratio = sizey / sizex != 1 ? (double)sizey / (double)sizex * 22.0 / 40.0 : 1.0;
        this.out.write("  1 " + ratio + " scale\n");
        this.out.write("  0 " + (double)(-ys) * 0.8 + " rmoveto\n");
        this.checkColorAndWidth(c, 0.33);
        HashMap<String, String> subst = new HashMap<String, String>();
        subst.put("(", "\\050");
        subst.put(")", "\\051");
        text = Globals.substituteBizarreChars(text, subst);
        this.out.write("  (" + text + ") show\n");
        this.out.write("grestore\n");
    }

    @Override
    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("" + x1 + " " + y1 + " moveto \n");
        this.out.write("" + x2 + " " + y2 + " " + x3 + " " + y3 + " " + x4 + " " + y4 + " curveto stroke\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x4, y4, x3, y3, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    @Override
    public void exportConnection(int x, int y, int layer, double node_size) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, 0.33);
        this.out.write("newpath\n");
        this.out.write("" + x + " " + y + " " + node_size / 2.0 + " " + node_size / 2.0 + " 0 360 ellipse\n");
        this.out.write("fill\n");
    }

    @Override
    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("" + x1 + " " + y1 + " moveto " + x2 + " " + y2 + " lineto stroke\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x2, y2, x1, y1, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    @Override
    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
        double alpha = x != xc ? Math.atan((y - yc) / (x - xc)) : 1.5707963267948966 + (y - yc < 0.0 ? 0.0 : Math.PI);
        double x0 = x - l * Math.cos(alpha += x - xc > 0.0 ? 0.0 : Math.PI);
        double y0 = y - l * Math.sin(alpha);
        double x1 = x0 - h * Math.sin(alpha);
        double y1 = y0 + h * Math.cos(alpha);
        double x2 = x0 + h * Math.sin(alpha);
        double y2 = y0 - h * Math.cos(alpha);
        this.registerDash(0);
        this.out.write("newpath\n");
        this.out.write("" + this.roundTo(x) + " " + this.roundTo(y) + " moveto\n");
        this.out.write("" + this.roundTo(x1) + " " + this.roundTo(y1) + " lineto\n");
        this.out.write("" + this.roundTo(x2) + " " + this.roundTo(y2) + " lineto\n");
        this.out.write("closepath\n");
        if ((style & 2) == 0) {
            this.out.write("fill \n");
        } else {
            this.out.write("stroke \n");
        }
        if ((style & 1) != 0) {
            double x3 = x - h * Math.sin(alpha);
            double y3 = y + h * Math.cos(alpha);
            double x4 = x + h * Math.sin(alpha);
            double y4 = y - h * Math.cos(alpha);
            this.out.write("" + this.roundTo(x3) + " " + this.roundTo(y3) + " moveto\n" + this.roundTo(x4) + " " + this.roundTo(y4) + " lineto\nstroke\n");
        }
    }

    @Override
    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String name, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map<String, MacroDesc> m) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("newpath\n");
        this.out.write("" + (double)(x1 + x2) / 2.0 + " " + (double)(y1 + y2) / 2.0 + " " + (double)Math.abs(x2 - x1) / 2.0 + " " + (double)Math.abs(y2 - y1) / 2.0 + " 0 360 ellipse\n");
        if (isFilled) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    @Override
    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, width);
        this.registerDash(0);
        this.out.write("1 setlinecap\n");
        this.out.write("" + x1 + " " + y1 + " moveto " + x2 + " " + y2 + " lineto stroke\n");
    }

    @Override
    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, 0.33);
        if (!onlyHole) {
            switch (style) {
                default: {
                    this.out.write("newpath\n");
                    this.out.write("" + x + " " + y + " " + (double)six / 2.0 + " " + (double)siy / 2.0 + " 0 360 ellipse\n");
                    this.out.write("fill\n");
                    break;
                }
                case 2: {
                    this.roundRect((double)x - (double)six / 2.0, (double)y - (double)siy / 2.0, six, siy, 4.0, true);
                    break;
                }
                case 1: {
                    double xdd = (double)x - (double)six / 2.0;
                    double ydd = (double)y - (double)siy / 2.0;
                    this.out.write("newpath\n");
                    this.out.write("" + xdd + " " + ydd + " moveto\n");
                    this.out.write("" + (xdd + (double)six) + " " + ydd + " lineto\n");
                    this.out.write("" + (xdd + (double)six) + " " + (ydd + (double)siy) + " lineto\n");
                    this.out.write("" + xdd + " " + (ydd + (double)siy) + " lineto\n");
                    this.out.write("closepath\n");
                    this.out.write("fill\n");
                }
            }
        }
        this.checkColorAndWidth(Color.white, 0.33);
        this.out.write("newpath\n");
        this.out.write("" + x + " " + y + " " + (double)indiam / 2.0 + " " + (double)indiam / 2.0 + " 0 360 ellipse\n");
        this.out.write("fill\n");
    }

    @Override
    public void exportPolygon(Point2D.Double[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        String fill_pattern = "";
        if (nVertices < 1) {
            return;
        }
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("newpath\n");
        this.out.write("" + vertices[0].x + " " + vertices[0].y + " moveto\n");
        for (int i = 1; i < nVertices; ++i) {
            this.out.write("" + vertices[i].x + " " + vertices[i].y + " lineto\n");
        }
        this.out.write("closepath\n");
        if (isFilled) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    @Override
    public boolean exportCurve(Point2D.Double[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("newpath\n");
        this.out.write("" + this.roundTo(x1, 3) + " " + this.roundTo(y1, 3) + " moveto\n");
        this.out.write("" + this.roundTo(x2, 3) + " " + this.roundTo(y1, 3) + " lineto\n");
        this.out.write("" + this.roundTo(x2, 3) + " " + this.roundTo(y2, 3) + " lineto\n");
        this.out.write("" + this.roundTo(x1, 3) + " " + this.roundTo(y2, 3) + " lineto\n");
        this.out.write("closepath\n");
        if (isFilled) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    private String roundTo(double n, int ch) {
        return "" + (double)((int)(n * Math.pow(10.0, ch))) / Math.pow(10.0, ch);
    }

    private String roundTo(double n) {
        int ch = 2;
        return "" + (double)((int)(n * Math.pow(10.0, ch))) / Math.pow(10.0, ch);
    }

    private void roundRect(double x1, double y1, double w, double h, double r, boolean filled) throws IOException {
        this.out.write("" + (x1 + r) + " " + y1 + " moveto\n");
        this.out.write("" + (x1 + w - r) + " " + y1 + " lineto\n");
        this.out.write("" + (x1 + w) + " " + y1 + " " + (x1 + w) + " " + y1 + " " + (x1 + w) + " " + (y1 + r) + " curveto\n");
        this.out.write("" + (x1 + w) + " " + (y1 + h - r) + " lineto\n");
        this.out.write("" + (x1 + w) + " " + (y1 + h) + " " + (x1 + w) + " " + (y1 + h) + " " + (x1 + w - r) + " " + (y1 + h) + " curveto\n");
        this.out.write("" + (x1 + r) + " " + (y1 + h) + " lineto\n");
        this.out.write("" + x1 + " " + (y1 + h) + " " + x1 + " " + (y1 + h) + " " + x1 + " " + (y1 + h - r) + " curveto\n");
        this.out.write("" + x1 + " " + (y1 + r) + " lineto\n");
        this.out.write("" + x1 + " " + y1 + " " + x1 + " " + y1 + " " + (x1 + r) + " " + y1 + " curveto\n");
        this.out.write("  " + (filled ? "fill\n" : "stroke\n"));
    }

    private void checkColorAndWidth(Color c, double wl) throws IOException {
        if (c != this.actualColor) {
            this.out.write("  " + this.roundTo((double)c.getRed() / 255.0) + " " + this.roundTo((double)c.getGreen() / 255.0) + " " + this.roundTo((double)c.getBlue() / 255.0) + " setrgbcolor\n");
            this.actualColor = c;
        }
        if (wl != this.actualWidth) {
            this.out.write("  " + wl + " setlinewidth\n");
            this.actualWidth = wl;
        }
    }

    private void registerDash(int dashStyle) throws IOException {
        if (this.actualDash != dashStyle) {
            this.actualDash = dashStyle;
            if (dashStyle == 0) {
                this.out.write("[] 0 setdash\n");
            } else {
                this.out.write("" + dash[dashStyle] + " 0 setdash\n");
            }
        }
    }
}

