/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveAdvText
extends GraphicPrimitive {
    private String txt = "";
    private int six = 3;
    private int siy = 4;
    private int sty;
    private int o = 0;
    private String fontName = "Courier New";
    private boolean recalcSize;
    static final int TEXT_BOLD = 1;
    static final int TEXT_MIRRORED = 4;
    static final int TEXT_ITALIC = 2;
    static final int N_POINTS = 1;
    private AffineTransform at;
    private AffineTransform stretching;
    private AffineTransform ats;
    private Font f;
    private boolean mirror;
    private int orientation;
    private AffineTransform mm;
    private FontMetrics fm;
    private int h;
    private int th;
    private int w;
    private int x1;
    private int y1;
    private int xa;
    private int ya;
    private int qq;
    private double xyfactor;
    private double si;
    private double co;
    private boolean needStretching;
    private static BufferedImage sizeCalculationImage;
    private int xaSCI;
    private int yaSCI;
    private int orientationSCI;
    private int hSCI;
    private int thSCI;
    private int wSCI;
    private int[] xpSCI;
    private int[] ypSCI;

    @Override
    public int getControlPointNumber() {
        return 1;
    }

    public PrimitiveAdvText() {
        this.virtualPoint = new Point[1];
        for (int i = 0; i < 1; ++i) {
            this.virtualPoint[i] = new Point();
        }
        this.changed = true;
        this.recalcSize = true;
    }

    public PrimitiveAdvText(int x, int y, int sx, int sy, String fn, int or, int st, String t, int l) {
        this();
        this.virtualPoint[0] = new Point(x, y);
        this.six = sx;
        this.siy = sy;
        this.sty = st;
        this.txt = t;
        this.o = or;
        this.fontName = fn;
        this.setLayer(l);
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public final void draw(Graphics2D g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        if (this.txt.length() == 0) {
            return;
        }
        this.changed = true;
        if (this.changed) {
            this.changed = false;
            this.mirror = false;
            this.recalcSize = true;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.xa = coordSys.mapX(this.x1, this.y1);
            this.ya = coordSys.mapY(this.x1, this.y1);
            int font_style = 0;
            font_style += (this.sty & 1) == 0 ? 0 : 1;
            this.f = new Font(this.fontName, font_style += (this.sty & 2) == 0 ? 0 : 2, (int)((double)(this.six * 12) * coordSys.getYMagnitude() / 7.0 + 0.5));
            this.orientation = this.o - coordSys.getOrientation() * 90;
            if ((this.sty & 4) != 0) {
                this.mirror = true;
                this.orientation = -this.orientation;
            }
            if (this.six == 0 || this.siy == 0) {
                this.siy = 10;
                this.six = 7;
            }
            this.fm = g.getFontMetrics(this.f);
            this.h = this.fm.getAscent();
            this.th = this.h + this.fm.getDescent();
            this.w = this.fm.stringWidth(this.txt);
            this.xyfactor = 1.0;
            this.needStretching = false;
            this.stretching = new AffineTransform();
            if (this.siy / this.six != 1) {
                this.xyfactor = (double)this.siy / (double)this.six * 22.0 / 40.0;
                this.needStretching = true;
            }
            this.stretching.scale(1.0, this.xyfactor);
            if (this.orientation != 0) {
                if (!this.mirror) {
                    this.si = Math.sin(Math.toRadians(this.orientation));
                    this.co = Math.cos(Math.toRadians(this.orientation));
                } else {
                    this.si = Math.sin(Math.toRadians(-this.orientation));
                    this.co = Math.cos(Math.toRadians(-this.orientation));
                }
                double bbx1 = this.xa;
                double bby1 = this.ya;
                double bbx2 = (double)this.xa + (double)this.th * this.si;
                double bby2 = (double)this.ya + (double)this.th * this.co * this.xyfactor;
                double bbx3 = (double)this.xa + (double)this.w * this.co + (double)this.th * this.si;
                double bby3 = (double)this.ya + ((double)this.th * this.co - (double)this.w * this.si) * this.xyfactor;
                double bbx4 = (double)this.xa + (double)this.w * this.co;
                double bby4 = (double)this.ya - (double)this.w * this.si * this.xyfactor;
                if (this.mirror) {
                    this.mm = new AffineTransform();
                    this.mm.scale(-1.0, 1.0);
                    bbx2 = (double)this.xa - (double)this.th * this.si;
                    bbx3 = (double)this.xa - (double)this.w * this.co - (double)this.th * this.si;
                    bbx4 = (double)this.xa - (double)this.w * this.co;
                }
                coordSys.trackPoint((int)bbx1, (int)bby1);
                coordSys.trackPoint((int)bbx2, (int)bby2);
                coordSys.trackPoint((int)bbx3, (int)bby3);
                coordSys.trackPoint((int)bbx4, (int)bby4);
            } else if (!this.mirror) {
                coordSys.trackPoint(this.xa + this.w, this.ya);
                coordSys.trackPoint(this.xa, this.ya + (int)((double)this.h * this.xyfactor));
            } else {
                coordSys.trackPoint(this.xa - this.w, this.ya);
                coordSys.trackPoint(this.xa, this.ya + (int)((double)this.th * this.xyfactor));
            }
            this.qq = (int)((double)this.ya / this.xyfactor);
        }
        this.at = (AffineTransform)g.getTransform().clone();
        this.ats = (AffineTransform)this.at.clone();
        if (this.orientation != 0) {
            if (this.mirror) {
                this.at.concatenate(this.mm);
                this.at.rotate(Math.toRadians(this.orientation), -this.xa, this.ya);
                if (this.needStretching) {
                    this.at.concatenate(this.stretching);
                }
                g.setTransform(this.at);
                if (!g.getFont().equals(this.f)) {
                    g.setFont(this.f);
                }
                g.drawString(this.txt, -this.xa, this.qq + this.h);
            } else {
                this.at.rotate(Math.toRadians(-this.orientation), this.xa, this.ya);
                if (this.needStretching) {
                    this.at.concatenate(this.stretching);
                }
                g.setTransform(this.at);
                if (!g.getFont().equals(this.f)) {
                    g.setFont(this.f);
                }
                g.drawString(this.txt, this.xa, this.qq + this.h);
            }
        } else if (!this.mirror) {
            if (this.needStretching) {
                this.at.concatenate(this.stretching);
                g.setTransform(this.at);
            }
            if (g.hitClip(this.xa, this.qq, this.w, this.th)) {
                if (this.th < 4) {
                    g.drawLine(this.xa, this.qq, this.xa + this.w, this.qq);
                    if (this.needStretching) {
                        g.setTransform(this.ats);
                    }
                    return;
                }
                if (!g.getFont().equals(this.f)) {
                    g.setFont(this.f);
                }
                g.drawString(this.txt, this.xa, this.qq + this.h);
                if (this.needStretching) {
                    g.setTransform(this.ats);
                }
                return;
            }
        } else {
            this.at.scale(-1.0, this.xyfactor);
            g.setTransform(this.at);
            if (g.hitClip(-this.xa, this.qq, this.w, this.h)) {
                if (!g.getFont().equals(this.f)) {
                    g.setFont(this.f);
                }
                g.drawString(this.txt, -this.xa, this.qq + this.h);
            }
        }
        g.setTransform(this.ats);
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        this.recalcSize = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.siy = Integer.parseInt(tokens[3]);
            this.six = Integer.parseInt(tokens[4]);
            this.o = Integer.parseInt(tokens[5]);
            this.sty = Integer.parseInt(tokens[6]);
            this.parseLayer(tokens[7]);
            int j = 8;
            StringBuffer txtb = new StringBuffer();
            this.fontName = tokens[8].equals("*") ? "Courier New" : tokens[8].replaceAll("\\+\\+", " ");
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
            this.txt = txtb.toString();
        } else if (tokens[0].equals("TE")) {
            if (N < 4) {
                IOException E = new IOException("bad arguments on TE");
                throw E;
            }
            this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.six = 3;
            this.siy = 4;
            this.o = 0;
            this.sty = 0;
            int j = 2;
            this.txt = "";
            while (j < N - 1) {
                this.txt = this.txt + tokens[++j] + " ";
            }
            this.parseLayer("0");
        } else {
            IOException E = new IOException("Invalid primitive: programming error?");
            throw E;
        }
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.changed || this.recalcSize) {
            this.recalcSize = false;
            sizeCalculationImage = new BufferedImage(1, 1, 1);
            Graphics2D gSCI = sizeCalculationImage.createGraphics();
            this.xaSCI = this.virtualPoint[0].x;
            this.yaSCI = this.virtualPoint[0].y;
            this.orientationSCI = this.o;
            Font f = new Font(this.fontName, (this.sty & 1) == 0 ? 0 : 1, (int)((double)this.six * 12.0 / 7.0 + 0.5));
            gSCI.setFont(f);
            FontMetrics fmSCI = gSCI.getFontMetrics(f);
            this.hSCI = fmSCI.getAscent();
            this.thSCI = this.hSCI + fmSCI.getDescent();
            this.wSCI = fmSCI.stringWidth(this.txt);
            if (this.siy / this.six != 1) {
                this.hSCI = (int)Math.round((double)this.hSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
                this.thSCI = (int)Math.round((double)this.thSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
            }
            if ((this.sty & 4) != 0) {
                this.orientationSCI = -this.orientationSCI;
                this.wSCI = -this.wSCI;
            }
            if (this.orientationSCI != 0) {
                double si = Math.sin(Math.toRadians(this.orientation));
                double co = Math.cos(Math.toRadians(this.orientation));
                this.xpSCI = new int[4];
                this.ypSCI = new int[4];
                this.xpSCI[0] = this.xaSCI;
                this.ypSCI[0] = this.yaSCI;
                this.xpSCI[1] = (int)((double)this.xaSCI + (double)this.thSCI * si);
                this.ypSCI[1] = (int)((double)this.yaSCI + (double)this.thSCI * co);
                this.xpSCI[2] = (int)((double)this.xaSCI + (double)this.thSCI * si + (double)this.wSCI * co);
                this.ypSCI[2] = (int)((double)this.yaSCI + (double)this.thSCI * co - (double)this.wSCI * si);
                this.xpSCI[3] = (int)((double)this.xaSCI + (double)this.wSCI * co);
                this.ypSCI[3] = (int)((double)this.yaSCI - (double)this.wSCI * si);
            }
        }
        if (this.orientationSCI != 0 ? GeometricDistances.pointInPolygon(this.xpSCI, this.ypSCI, 4, px, py) : GeometricDistances.pointInRectangle(Math.min(this.xaSCI, this.xaSCI + this.wSCI), this.yaSCI, Math.abs(this.wSCI), this.thSCI, px, py)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = new Vector<ParameterDescription>(10);
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.txt;
        pd.description = Globals.messages.getString("ctrl_text");
        v.add(pd);
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            pd = new ParameterDescription();
            pd.parameter = this.virtualPoint[i];
            pd.description = Globals.messages.getString("ctrl_control") + (i + 1) + ":";
            v.add(pd);
        }
        pd = new ParameterDescription();
        pd.parameter = new LayerInfo(this.getLayer());
        pd.description = Globals.messages.getString("ctrl_layer");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.six);
        pd.description = Globals.messages.getString("ctrl_xsize");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.siy);
        pd.description = Globals.messages.getString("ctrl_ysize");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.o);
        pd.description = Globals.messages.getString("ctrl_angle");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean((this.sty & 4) != 0);
        pd.description = Globals.messages.getString("ctrl_mirror");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean((this.sty & 2) != 0);
        pd.description = Globals.messages.getString("ctrl_italic");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean((this.sty & 1) != 0);
        pd.description = Globals.messages.getString("ctrl_boldface");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Font(this.fontName, 0, 12);
        pd.description = Globals.messages.getString("ctrl_font");
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = 0;
        this.changed = true;
        this.recalcSize = true;
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.txt = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        for (i = 1; i < this.getControlPointNumber() + 1; ++i) {
            pd = v.get(i);
            if (pd.parameter instanceof Point) {
                this.virtualPoint[i - 1] = (Point)pd.parameter;
                continue;
            }
            System.out.println("Warning: unexpected parameter!");
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof LayerInfo) {
            this.setLayer(((LayerInfo)pd.parameter).getLayer());
        } else {
            System.out.println("Warning: unexpected parameter!");
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.six = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.siy = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.o = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 4 : this.sty & 0xFFFFFFFB;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 2 : this.sty & 0xFFFFFFFD;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 1 : this.sty & 0xFFFFFFFE;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Font) {
            this.fontName = ((Font)pd.parameter).getFamily();
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    @Override
    public void rotatePrimitive(boolean bCounterClockWise, int ix, int iy) {
        super.rotatePrimitive(bCounterClockWise, ix, iy);
        int po = this.o / 90;
        if ((this.sty & 4) != 0) {
            boolean bl = bCounterClockWise = !bCounterClockWise;
        }
        if (bCounterClockWise) {
            ++po;
            po %= 4;
        } else {
            po = (po + 3) % 4;
        }
        this.o = 90 * po;
    }

    @Override
    public void mirrorPrimitive(int xPos) {
        super.mirrorPrimitive(xPos);
        this.sty ^= 4;
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public String toString(boolean extensions) {
        CharSequence s;
        String subsFont;
        if (this.fontName.equals("Courier New")) {
            subsFont = "*";
        } else {
            s = new StringBuffer("");
            for (int i = 0; i < this.fontName.length(); ++i) {
                if (this.fontName.charAt(i) != ' ') {
                    s.append(this.fontName.charAt(i));
                    continue;
                }
                s.append("++");
            }
            subsFont = s.toString();
        }
        s = "TY " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.siy + " " + this.six + " " + this.o + " " + this.sty + " " + this.getLayer() + " " + subsFont + " " + this.txt + "\n";
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        exp.exportAdvText(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), (int)(cs.mapXr(this.six, this.six) - cs.mapXr(0.0, 0.0)), (int)(cs.mapYr(this.siy, this.siy) - cs.mapYr(0.0, 0.0)), this.fontName, (this.sty & 1) != 0, (this.sty & 4) != 0, (this.sty & 2) != 0, this.o, this.getLayer(), this.txt);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return -1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return -1;
    }
}

