/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.controllers.EditorActions;
import circuit.controllers.PrimitivesParInterface;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import geom.MapCoordinates;
import graphic.GraphicsInterface;
import java.io.IOException;
import layers.StandardLayers;
import primitives.GraphicPrimitive;
import primitives.PrimitiveAdvText;
import primitives.PrimitiveBezier;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveConnection;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePCBPad;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;

public class ElementsEdtActions {
    protected final DrawingModel P;
    protected final UndoActions ua;
    protected final EditorActions edt;
    public int currentLayer;
    public int[] xpoly;
    public int[] ypoly;
    public String macroKey;
    public int clickNumber;
    public transient GraphicPrimitive primEdit;
    public int actionSelected;
    public boolean successiveMove;
    public static final int NPOLY = 256;
    public int PCB_pad_sizex;
    public int PCB_pad_sizey;
    public int PCB_pad_style;
    public int PCB_pad_drill;
    public int PCB_thickness;
    public static final int NONE = 0;
    public static final int SELECTION = 1;
    public static final int ZOOM = 2;
    public static final int HAND = 3;
    public static final int LINE = 4;
    public static final int TEXT = 5;
    public static final int BEZIER = 6;
    public static final int POLYGON = 7;
    public static final int ELLIPSE = 8;
    public static final int RECTANGLE = 9;
    public static final int CONNECTION = 10;
    public static final int PCB_LINE = 11;
    public static final int PCB_PAD = 12;
    public static final int MACRO = 13;
    public static final int COMPLEXCURVE = 14;
    protected PrimitivesParInterface primitivesParListener;

    public ElementsEdtActions(DrawingModel pp, UndoActions u, EditorActions e) {
        this.P = pp;
        this.ua = u;
        this.edt = e;
        this.xpoly = new int[256];
        this.ypoly = new int[256];
        this.currentLayer = 0;
        this.PCB_thickness = 5;
        this.PCB_pad_sizex = 5;
        this.PCB_pad_sizey = 5;
        this.PCB_pad_drill = 2;
        this.primEdit = null;
        this.primitivesParListener = null;
        this.actionSelected = 1;
    }

    public void setActionSelected(int a) {
        if (a != this.actionSelected) {
            this.clickNumber = 0;
        }
        this.actionSelected = a;
    }

    public void setPrimitivesParListener(PrimitivesParInterface l) {
        this.primitivesParListener = l;
    }

    public void setPCB_pad_sizex(int s) {
        this.PCB_pad_sizex = s;
    }

    public int getPCB_pad_sizex() {
        return this.PCB_pad_sizex;
    }

    public void setPCB_pad_sizey(int s) {
        this.PCB_pad_sizey = s;
    }

    public int getPCB_pad_sizey() {
        return this.PCB_pad_sizey;
    }

    public void setPCB_pad_style(int s) {
        this.PCB_pad_style = s;
    }

    public int getPCB_pad_style() {
        return this.PCB_pad_style;
    }

    public void setPCB_pad_drill(int s) {
        this.PCB_pad_drill = s;
    }

    public int getPCB_pad_drill() {
        return this.PCB_pad_drill;
    }

    public void setPCB_thickness(int s) {
        this.PCB_thickness = s;
    }

    public int getPCB_thickness() {
        return this.PCB_thickness;
    }

    public boolean isEnteringMacro() {
        return this.primEdit instanceof PrimitiveMacro;
    }

    public void setState(int s, String macro) {
        this.actionSelected = s;
        this.clickNumber = 0;
        this.successiveMove = false;
        this.macroKey = macro;
    }

    public void rotateMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.rotatePrimitive(false, this.primEdit.getFirstPoint().x, this.primEdit.getFirstPoint().y);
        }
    }

    public void mirrorMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.mirrorPrimitive(this.primEdit.getFirstPoint().x);
        }
    }

    private void addConnection(int x, int y) {
        PrimitiveConnection g = new PrimitiveConnection(x, y, this.currentLayer, this.P.getTextFont(), this.P.getTextFontSize());
        g.setMacroFont(this.P.getTextFont(), this.P.getTextFontSize());
        this.P.addPrimitive(g, true, this.ua);
    }

    private int addLine(int x, int y, int clickNumber, boolean altButton) {
        int cn = clickNumber;
        this.xpoly[clickNumber] = x;
        this.ypoly[clickNumber] = y;
        if (clickNumber == 2 || altButton) {
            PrimitiveLine g = new PrimitiveLine(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.currentLayer, false, false, 0, 3, 2, 0, this.P.getTextFont(), this.P.getTextFontSize());
            this.P.addPrimitive(g, true, this.ua);
            if (altButton) {
                cn = 0;
            } else {
                cn = 1;
                this.xpoly[1] = this.xpoly[2];
                this.ypoly[1] = this.ypoly[2];
            }
        }
        return cn;
    }

    private void addMacro(int x, int y) {
        try {
            this.edt.setSelectionAll(false);
            int orientation = 0;
            boolean mirror = false;
            if (this.primEdit instanceof PrimitiveMacro) {
                orientation = ((PrimitiveMacro)this.primEdit).getOrientation();
                mirror = ((PrimitiveMacro)this.primEdit).isMirrored();
            }
            this.P.addPrimitive(new PrimitiveMacro(this.P.getLibrary(), this.P.getLayers(), x, y, this.macroKey, "", x + 10, y + 5, "", x + 10, y + 10, this.P.getTextFont(), this.P.getTextFontSize(), orientation, mirror), true, this.ua);
            this.primEdit = null;
        }
        catch (IOException G) {
            System.out.println(G);
        }
    }

    private int addEllipse(int x, int ty, int clickNumber, boolean isCircle) {
        int y = ty;
        int cn = clickNumber;
        if (isCircle) {
            y = this.ypoly[1] + x - this.xpoly[1];
        }
        this.xpoly[clickNumber] = x;
        this.ypoly[clickNumber] = y;
        if (cn == 2) {
            PrimitiveOval g = new PrimitiveOval(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], false, this.currentLayer, 0, this.P.getTextFont(), this.P.getTextFontSize());
            this.P.addPrimitive(g, true, this.ua);
            cn = 0;
        }
        return cn;
    }

    private int addBezier(int x, int y, int clickNumber) {
        int cn = clickNumber;
        this.xpoly[clickNumber] = x;
        this.ypoly[clickNumber] = y;
        if (clickNumber == 4) {
            PrimitiveBezier g = new PrimitiveBezier(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], this.xpoly[3], this.ypoly[3], this.xpoly[4], this.ypoly[4], this.currentLayer, false, false, 0, 3, 2, 0, this.P.getTextFont(), this.P.getTextFontSize());
            this.P.addPrimitive(g, true, this.ua);
            cn = 0;
        }
        return cn;
    }

    private int addRectangle(int x, int ty, int clickNumber, boolean isSquare) {
        int y = ty;
        int cn = clickNumber;
        if (isSquare) {
            y = this.ypoly[1] + x - this.xpoly[1];
        }
        this.xpoly[clickNumber] = x;
        this.ypoly[clickNumber] = y;
        if (cn == 2) {
            PrimitiveRectangle g = new PrimitiveRectangle(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], false, this.currentLayer, 0, this.P.getTextFont(), this.P.getTextFontSize());
            this.P.addPrimitive(g, true, this.ua);
            cn = 0;
        }
        if (cn >= 2) {
            cn = 0;
        }
        return cn;
    }

    private int addPCBLine(int x, int y, int clickNumber, boolean altButton, float thickness) {
        int cn = clickNumber;
        this.xpoly[cn] = x;
        this.ypoly[cn] = y;
        if (cn == 2 || altButton) {
            PrimitivePCBLine g = new PrimitivePCBLine(this.xpoly[1], this.ypoly[1], this.xpoly[2], this.ypoly[2], thickness, this.currentLayer, this.P.getTextFont(), this.P.getTextFontSize());
            this.P.addPrimitive(g, true, this.ua);
            if (altButton) {
                cn = 0;
            } else {
                cn = 1;
                this.xpoly[1] = this.xpoly[2];
                this.ypoly[1] = this.ypoly[2];
            }
        }
        return cn;
    }

    public boolean handleClick(MapCoordinates cs, int x, int y, boolean button3, boolean toggle, boolean doubleClick, boolean isControlDown) {
        boolean repaint = false;
        if (this.clickNumber > 255) {
            this.clickNumber = 255;
        }
        if (this.actionSelected != 13) {
            this.primEdit = null;
        }
        if (button3 && this.actionSelected != 0 && this.actionSelected != 1 && this.actionSelected != 2 && this.actionSelected != 5 && this.primitivesParListener != null) {
            this.primitivesParListener.selectAndSetProperties(x, y);
            return false;
        }
        switch (this.actionSelected) {
            case 0: {
                this.clickNumber = 0;
                break;
            }
            case 1: {
                this.clickNumber = 0;
                if (doubleClick && this.primitivesParListener != null) {
                    this.primitivesParListener.setPropertiesForPrimitive();
                    break;
                }
                if (button3 && this.primitivesParListener != null) {
                    this.primitivesParListener.showPopUpMenu(x, y);
                    break;
                }
                this.edt.handleSelection(cs, x, y, toggle);
                break;
            }
            case 2: {
                if (this.primitivesParListener == null) break;
                this.primitivesParListener.changeZoomByStep(!button3, x, y);
                break;
            }
            case 10: {
                this.addConnection(cs.unmapXsnap(x), cs.unmapXsnap(y));
                repaint = true;
                break;
            }
            case 12: {
                PrimitivePCBPad g = new PrimitivePCBPad(cs.unmapXsnap(x), cs.unmapYsnap(y), this.PCB_pad_sizex, this.PCB_pad_sizey, this.PCB_pad_drill, this.PCB_pad_style, this.currentLayer, this.P.getTextFont(), this.P.getTextFontSize());
                this.P.addPrimitive(g, true, this.ua);
                repaint = true;
                break;
            }
            case 4: {
                if (doubleClick) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.clickNumber = this.addLine(cs.unmapXsnap(x), cs.unmapYsnap(y), ++this.clickNumber, button3);
                repaint = true;
                break;
            }
            case 5: {
                if (doubleClick && this.primitivesParListener != null) {
                    this.primitivesParListener.selectAndSetProperties(x, y);
                    break;
                }
                PrimitiveAdvText newtext = new PrimitiveAdvText(cs.unmapXsnap(x), cs.unmapYsnap(y), 3, 4, this.P.getTextFont(), 0, 0, "String", this.currentLayer);
                this.edt.setSelectionAll(false);
                this.P.addPrimitive(newtext, true, this.ua);
                newtext.setSelected(true);
                repaint = true;
                if (this.primitivesParListener == null) break;
                this.primitivesParListener.setPropertiesForPrimitive();
                break;
            }
            case 6: {
                repaint = true;
                if (button3) {
                    this.clickNumber = 0;
                    break;
                }
                if (doubleClick) {
                    this.successiveMove = false;
                }
                this.clickNumber = this.addBezier(cs.unmapXsnap(x), cs.unmapYsnap(y), ++this.clickNumber);
                break;
            }
            case 7: {
                if (doubleClick) {
                    PrimitivePolygon poly = new PrimitivePolygon(false, this.currentLayer, 0, this.P.getTextFont(), this.P.getTextFontSize());
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        poly.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    this.P.addPrimitive(poly, true, this.ua);
                    this.clickNumber = 0;
                    repaint = true;
                    break;
                }
                ++this.clickNumber;
                if (doubleClick) {
                    this.successiveMove = false;
                }
                if (this.clickNumber == 256) {
                    return false;
                }
                if (this.clickNumber == 256) {
                    return false;
                }
                this.xpoly[this.clickNumber] = cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = cs.unmapYsnap(y);
                break;
            }
            case 14: {
                if (doubleClick) {
                    PrimitiveComplexCurve compc = new PrimitiveComplexCurve(false, false, this.currentLayer, false, false, 0, 3, 2, 0, this.P.getTextFont(), this.P.getTextFontSize());
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        compc.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    this.P.addPrimitive(compc, true, this.ua);
                    this.clickNumber = 0;
                    repaint = true;
                    break;
                }
                ++this.clickNumber;
                if (doubleClick) {
                    this.successiveMove = false;
                }
                if (this.clickNumber == 256) {
                    return false;
                }
                this.xpoly[this.clickNumber] = cs.unmapXsnap(x);
                this.ypoly[this.clickNumber] = cs.unmapYsnap(y);
                break;
            }
            case 8: {
                this.successiveMove = false;
                this.clickNumber = this.addEllipse(cs.unmapXsnap(x), cs.unmapYsnap(y), ++this.clickNumber, isControlDown && this.clickNumber > 0);
                repaint = true;
                break;
            }
            case 9: {
                this.successiveMove = false;
                this.clickNumber = this.addRectangle(cs.unmapXsnap(x), cs.unmapYsnap(y), ++this.clickNumber, isControlDown && this.clickNumber > 0);
                repaint = true;
                break;
            }
            case 11: {
                if (doubleClick) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.clickNumber = this.addPCBLine(cs.unmapXsnap(x), cs.unmapYsnap(y), ++this.clickNumber, button3, this.PCB_thickness);
                repaint = true;
                break;
            }
            case 13: {
                this.successiveMove = false;
                this.addMacro(cs.unmapXsnap(x), cs.unmapYsnap(y));
                repaint = true;
                break;
            }
        }
        return repaint;
    }

    public void drawPrimEdit(GraphicsInterface g, MapCoordinates cs) {
        if (this.primEdit != null) {
            this.primEdit.draw(g, cs, StandardLayers.createEditingLayerArray());
        }
    }

    public void showClicks(GraphicsInterface g, MapCoordinates cs) {
        g.setColor(g.getColor().red());
        g.applyStroke(2.0f, 0);
        for (int i = 1; i <= this.clickNumber; ++i) {
            int x = cs.mapXi(this.xpoly[i], this.ypoly[i], false);
            int y = cs.mapYi(this.xpoly[i], this.ypoly[i], false);
            g.drawLine(x - 15, y, x + 15, y);
            g.drawLine(x, y - 15, x, y + 15);
        }
    }

    public int getSelectionState() {
        return this.actionSelected;
    }

    public void setPrimEdit(GraphicPrimitive gp) {
        this.primEdit = gp;
    }

    public GraphicPrimitive getPrimEdit(GraphicPrimitive gp) {
        return this.primEdit;
    }
}

