/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker.model;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeNode;

public abstract class AbstractMacroTreeNode
implements MacroTreeNode {
    protected Vector childNodes = new Vector();
    protected TreeNode parent;
    protected String label = "";
    protected Icon icon;

    AbstractMacroTreeNode() {
    }

    public Enumeration children() {
        return this.childNodes.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childNodes.get(childIndex);
    }

    public int getChildCount() {
        return this.childNodes.size();
    }

    public int getIndex(TreeNode node) {
        return this.childNodes.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return false;
    }

    public void sortTree() {
        Collections.sort(this.childNodes);
        for (Object n : this.childNodes) {
            ((AbstractMacroTreeNode)n).sortTree();
        }
    }

    public void removeChildNode(TreeNode node) {
        this.childNodes.remove(node);
    }

    public int getIndexAt(TreeNode node) {
        return this.childNodes.indexOf(node);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.label;
    }

    public void clearChildNodes() {
        this.childNodes.clear();
    }
}

