/*
 * Decompiled with CFR 0.152.
 */
package retypar;

import heuser.simpleLogger.SimpleLogger;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import retypar.converter.Converter;
import retypar.retypar;

public class batchMode
extends SimpleLogger {
    private String[] args;
    private boolean AZ = true;
    private boolean az = true;
    private boolean num = true;
    private boolean spec = false;
    private boolean col = true;
    private String format = "";
    private String defaultFileExtension = "";
    private Color bgColor = Color.WHITE;
    private boolean isTransparent = false;
    private int outputFormat = 2;
    private int compression = 0;
    private int scalefactor = 100;
    private Converter conversionAlgo;
    private int threshold = 5;
    private File outputFile;
    private LinkedList inputFiles = new LinkedList();

    public batchMode(String[] stringArray) {
        batchMode.setConsoleOutput(true);
        batchMode.logMsg("\r\n--- retypar 0.9.4 (Jens Heuser, 2005) ---");
        batchMode.logMsg("=== a tool to convert images into ASCII ===\r\n");
        batchMode.setConsoleOutput(true);
        this.args = stringArray;
        retypar.readINI();
        retypar.loadConverters();
        if (!this.verifyArguments()) {
            System.exit(1);
        }
        this.runConversion();
    }

    private boolean verifyArguments() {
        try {
            this.parseArguments();
        }
        catch (Exception exception) {
            batchMode.logError("Wrong arguments. Forgot a parameter value?\n");
        }
        return batchMode.success();
    }

    private void runConversion() {
        String string = "";
        if (this.inputFiles.size() == 0) {
            batchMode.logError("Must specify at least one input file!");
        }
        if (this.format.equals("")) {
            this.setOutputFormat("j");
        }
        if (this.conversionAlgo == null) {
            this.setAlgorithm("mr");
        }
        batchMode.logMsg("Using " + (this.AZ ? "A-Z, " : "") + (this.az ? "a-z, " : "") + (this.num ? "0-9, " : "") + (this.spec ? "special, " : "") + (this.col ? "colors" : ""));
        batchMode.logMsg("Algorithm: " + ((Object)this.conversionAlgo).toString());
        if (this.conversionAlgo.usesThreshold()) {
            batchMode.logMsg("Threshold: " + this.threshold);
        }
        batchMode.logMsg("Output format: " + this.format);
        batchMode.logMsg("Compression ratio: " + this.compression);
        batchMode.logMsg("Scalefactor: " + this.scalefactor + "%");
        batchMode.logMsg("Background color: #" + Integer.toHexString(this.bgColor.getRGB()).substring(2));
        batchMode.logMsg("\r\nConverting: ");
        for (int i = 0; i < this.inputFiles.size(); ++i) {
            File file = (File)this.inputFiles.get(i);
            string = "ASCII of " + file.getName().substring(0, file.getName().lastIndexOf(".") + 1) + this.defaultFileExtension;
            batchMode.logMsg("\t\"" + file.getName() + "\" to \"" + (this.outputFile == null ? string : this.outputFile.getName()) + "\"");
            BufferedImage bufferedImage = retypar.convertImage((File)this.inputFiles.get(i), this.AZ, this.az, this.num, this.spec, this.col, Color.WHITE, this.scalefactor, 0, 0, 0, this.conversionAlgo, this.threshold);
            retypar.stopTimer();
            if (!retypar.storeImage(this.outputFile == null ? new File(string) : this.outputFile, bufferedImage, this.compression, this.outputFormat, this.col, Color.WHITE, this.conversionAlgo.getASCII(), this.conversionAlgo.getColors(), this.isTransparent)) {
                batchMode.logError("Could not write to file!");
                System.exit(1);
            }
            batchMode.logMsgAppend(", " + retypar.getDuration());
        }
    }

    private void parseArguments() {
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].startsWith("-")) {
                switch (this.args[i].charAt(1)) {
                    case 'g': {
                        this.setGranularity(this.args[i + 1]);
                        break;
                    }
                    case 'o': {
                        this.setOutputFile(this.args[i + 1]);
                        break;
                    }
                    case 'x': {
                        this.setOutputFormat(this.args[i + 1]);
                        break;
                    }
                    case 'c': {
                        this.setCompression(this.args[i + 1]);
                        break;
                    }
                    case 's': {
                        this.setScalefactor(this.args[i + 1]);
                        break;
                    }
                    case 'a': {
                        this.setAlgorithm(this.args[i + 1]);
                        break;
                    }
                    case 't': {
                        this.setThreshold(this.args[i + 1]);
                        break;
                    }
                    case 'q': {
                        this.disableLogging();
                        --i;
                        break;
                    }
                    case 'l': {
                        this.setLogFile(this.args[i + 1]);
                        break;
                    }
                    case 'b': {
                        this.setBgColor(this.args[i + 1]);
                        break;
                    }
                    case 'p': {
                        this.isTransparent = true;
                        break;
                    }
                    case 'h': {
                        this.printHelp();
                        System.exit(0);
                        break;
                    }
                    case 'e': {
                        this.printAlgos();
                        System.exit(0);
                        break;
                    }
                    case '?': {
                        this.printHelp();
                        System.exit(0);
                        break;
                    }
                    default: {
                        batchMode.logError("Unknown switch: " + this.args[i]);
                    }
                }
                ++i;
                continue;
            }
            this.setInputFile(this.args[i]);
        }
    }

    private void setGranularity(String string) {
        this.AZ = false;
        this.az = false;
        this.num = false;
        this.spec = false;
        this.col = false;
        while (string.length() > 0) {
            switch (string.charAt(0)) {
                case 'A': {
                    this.AZ = true;
                    break;
                }
                case 'a': {
                    this.az = true;
                    break;
                }
                case '0': {
                    this.num = true;
                    break;
                }
                case 's': {
                    this.spec = true;
                    break;
                }
                case 'c': {
                    this.col = true;
                    break;
                }
                default: {
                    batchMode.logError("Wrong argument in switch '-g': " + string);
                }
            }
            string = string.substring(1);
        }
    }

    private void setInputFile(String string) {
        this.inputFiles.add(new File(string));
        if (!((File)this.inputFiles.getLast()).exists()) {
            batchMode.logError("No such file: " + string);
        }
    }

    private void setOutputFile(String string) {
        this.outputFile = new File(string);
    }

    private void setOutputFormat(String string) {
        switch (string.charAt(0)) {
            case 'j': {
                this.outputFormat = 2;
                this.format = "JPEG";
                this.defaultFileExtension = retypar.EXTENSIONS_TYPE_JPEG[0];
                break;
            }
            case 'g': {
                this.outputFormat = 5;
                this.format = "GIF";
                this.defaultFileExtension = retypar.EXTENSIONS_TYPE_GIF[0];
                break;
            }
            case 't': {
                this.outputFormat = 0;
                this.format = "Text";
                this.defaultFileExtension = retypar.EXTENSIONS_TYPE_TEXT[0];
                break;
            }
            case 'h': {
                this.outputFormat = 1;
                this.format = "HTML";
                this.defaultFileExtension = retypar.EXTENSIONS_TYPE_HTML[0];
                break;
            }
            case 'v': {
                this.outputFormat = 3;
                this.format = "Text video";
                if (this.outputFile != null) break;
                this.setOutputFile("textvideo.txv");
                break;
            }
            default: {
                batchMode.logError("Wrong output format: " + string);
            }
        }
    }

    private void setCompression(String string) {
        try {
            this.compression = Integer.parseInt(string);
        }
        catch (Exception exception) {
            batchMode.logError("Wrong compression ratio: " + string);
        }
        if (this.compression < 0 || this.compression > 100) {
            batchMode.logError("Wrong Compression ratio. Has to be between 0 and 100.");
        }
    }

    private void setScalefactor(String string) {
        try {
            this.scalefactor = Integer.parseInt(string);
        }
        catch (Exception exception) {
            batchMode.logError("Wrong scalefactor: " + string);
        }
        if (this.scalefactor < 0) {
            batchMode.logError("Wrong scale factor. Must not be less than 0.");
        }
    }

    private void disableLogging() {
        batchMode.setConsoleOutput(false);
    }

    private void setLogFile(String string) {
        try {
            batchMode.logToFile(new File(string), true);
        }
        catch (Exception exception) {
            batchMode.logError("Error logging to File '" + string + "'");
        }
    }

    private void setBgColor(String string) {
        if (!string.startsWith("#")) {
            batchMode.logError("Wrong color. Format (hexadecimal): #rrggbb");
        }
        this.bgColor = new Color(Integer.parseInt(string.substring(1, string.length()).toLowerCase(), 16));
    }

    private void setAlgorithm(String string) {
        if (retypar.converters.isEmpty()) {
            batchMode.logError("(FATAL) No conversion algorithms installed!");
        }
        boolean bl = false;
        for (int i = 0; i < retypar.converters.size(); ++i) {
            if (!((Converter)retypar.converters.get(i)).getShortName().equals(string)) continue;
            this.conversionAlgo = (Converter)retypar.converters.get(i);
            bl = true;
        }
        if (!bl) {
            batchMode.logError("Algorithm not found! Check 'java -jar retypar_0.9.4.jar -e'");
        }
    }

    private void setThreshold(String string) {
        try {
            this.threshold = Integer.parseInt(string);
        }
        catch (Exception exception) {
            batchMode.logError("Wrong threshold specified. Use a number!");
        }
    }

    private void printAlgos() {
        System.out.println(batchMode.printAllLog());
        batchMode.logMsg("Installed algorithms:");
        for (int i = 0; i < retypar.converters.size(); ++i) {
            batchMode.logMsg(((Converter)retypar.converters.get(i)).getShortName() + ": " + ((Object)((Converter)retypar.converters.get(i))).toString() + ", by " + ((Converter)retypar.converters.get(i)).getAuthor() + " (" + ((Converter)retypar.converters.get(i)).getWebsite() + ")");
        }
    }

    private void printHelp() {
        System.out.println(batchMode.printAllLog());
        batchMode.logMsg("Usage:\njava -jar retypar.jar input_file {input_file} -g Aa0sc -o output_file -m j|t|h -c compression_ratio -s scale_factor -q\n\n-g: Use uppercase letters (A), lowercase letters (a), numbers (0), special characters (s) and colors (c). Default is 'Aa0c'.\n-o: The output file to write to. If none given, \"ASCII of (input_file)\" is used.\n-x: Export result as JPEG (j), text (t), HTML (h) or text video (v). Only one allowed. Defaults to 'j'.\n-c: Compression ratio of the resulting JPEG file. Default is '0'.\n-s: Scalefactor in percent. Resizes the image before converting when <> '100'. Default is '100'.\n-b: Background color. Hexadecimal, that is '#rrggbb'. Defaults to white (#ffffff).\n-g: make background color transparent (only with GIF images)\n-a: Specify the algorithm to be used. Default is 'mr'. Check 'java -jar retypar_0.9.4.jar -e'\n-e: List all installed conversion algorithms.\n-t: The rendering threshold. Not supported by all algorithms.\n-l: Log to a file. Console output is not disabled, to disable use also '-q'\n-q: Quiet. Disables output to console.\n-h: This help screen.\n-?: Guess what? Again, this help screen.\n\nAll switches are optional. Only a filename has to be given. Wildcars allowed.\nVisit http://www.retypar.de.vu for more information.");
    }

    public String toString() {
        String string = "retypar 0.9.4";
        return string;
    }
}

