/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoChooseFile;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.plugin.JaxoExportPlugin;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLooknFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoExportPanel
implements JaxoLocalized {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoExportPanel.class);
    private JaxoGraph graph;
    private String currentTab = "";
    private final JDialog dialog;
    private final Component parent;
    private final JaxoPreview preview;
    private List<?> exports;
    private JComboBox chooseFileFormat;
    private JTextField chooseFileName;
    private JLabel warningLabel;
    private JaxoExportPlugin oldSelectedExport;
    private JComponent configurationPanelParent;
    private JButton previewButton;
    private JButton exportButton;
    private JButton cancelButton;
    private JLabel fileFormatLabel;
    private JLabel fileNameLabel;
    private boolean newPreviewFrame = true;

    public JaxoExportPanel(Component parentc, List<?> exportl, JaxoPreview p) {
        this.parent = parentc;
        this.exports = exportl;
        this.dialog = JaxoDialogs.newDialog(this.parent, "", false);
        this.preview = p.copy();
        this.preview.setParentComponent(this.dialog);
    }

    public void setNewPreviewFrame(boolean newFrame) {
        this.newPreviewFrame = newFrame;
    }

    public void setExports(List<?> expts) {
        this.exports = new ArrayList(expts);
    }

    @Override
    public void updateLanguage() {
        if (this.previewButton == null) {
            return;
        }
        this.previewButton.setText(LANGUAGE.value("/Preview"));
        this.previewButton.setToolTipText(LANGUAGE.value("/Open_a_preview_window"));
        this.exportButton.setText(LANGUAGE.value("/Export"));
        this.cancelButton.setText(LANGUAGE.value("/Cancel"));
        this.fileFormatLabel.setText(LANGUAGE.label("/File_format"));
        this.fileNameLabel.setText(LANGUAGE.label("/File_name"));
        this.configurationPanelParent.setBorder(this.getExportPanelBorder());
        int nofExports = this.chooseFileFormat.getItemCount();
        for (int i = 0; i < nofExports; ++i) {
            Object o = this.chooseFileFormat.getItemAt(i);
            if (!(o instanceof JaxoExportPlugin)) continue;
            ((JaxoExportPlugin)o).updateLanguage();
        }
        this.dialog.setTitle(JaxoDialogs.windowTitle(LANGUAGE, "/Export"));
    }

    public final void export(JaxoGraph newGraph, String tab) {
        this.graph = newGraph;
        this.currentTab = tab;
        this.setupFileFormatComboBox();
        JPanel optionsPanel = this.getOptionsPanel();
        this.updateSelectedExport();
        this.dialog.getContentPane().removeAll();
        this.dialog.getContentPane().add(optionsPanel);
        this.dialog.getContentPane().add((Component)this.getButtonPanel(), "Last");
        this.updateLanguage();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
    }

    @Deprecated
    public final void export(JaxoGraph newGraph, Dimension d, String tab) {
        this.export(newGraph, tab);
    }

    private JPanel getOptionsPanel() {
        this.chooseFileName = new JTextField(24);
        JPanel optionsPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints labels = new GridBagConstraints();
        GridBagConstraints components = new GridBagConstraints();
        labels.anchor = 22;
        components.fill = 1;
        labels.gridx = 0;
        labels.gridy = 0;
        components.gridx = 1;
        components.gridy = 0;
        this.fileFormatLabel = new JLabel("", 11);
        optionsPanel.add((Component)this.fileFormatLabel, labels);
        optionsPanel.add((Component)this.chooseFileFormat, components);
        ++labels.gridy;
        ++components.gridy;
        JPanel chooseFileNamePanel = JaxoDialogs.newLineBoxLayoutPanel();
        JButton openFileChooser = new JButton("...");
        chooseFileNamePanel.add(this.chooseFileName);
        chooseFileNamePanel.add(openFileChooser);
        openFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.chooseFileName();
            }
        });
        this.fileNameLabel = new JLabel("", 11);
        optionsPanel.add((Component)this.fileNameLabel, labels);
        optionsPanel.add((Component)chooseFileNamePanel, components);
        ++labels.gridy;
        ++components.gridy;
        this.configurationPanelParent = new JPanel(new BorderLayout(), false){
            private static final long serialVersionUID = 7526471155622L;

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        components.gridx = 0;
        components.gridwidth = 2;
        components.weightx = 1.0;
        components.weighty = 1.0;
        optionsPanel.add((Component)this.configurationPanelParent, components);
        components.gridx = 1;
        components.gridwidth = 1;
        components.weighty = 0.0;
        ++labels.gridy;
        ++components.gridy;
        this.warningLabel = new JLabel();
        components.gridx = 0;
        components.gridwidth = 2;
        optionsPanel.add((Component)this.warningLabel, components);
        components.gridx = 1;
        components.gridwidth = 1;
        components.weighty = 0.0;
        ++labels.gridy;
        ++components.gridy;
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "pressed");
        optionsPanel.getActionMap().put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 75264711556227767L;

            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.cancelButtonClicked();
            }
        });
        String f = this.graph.getSaveFileName();
        if ("".equals(f.trim())) {
            this.chooseFileName.setText(JaxoIO.currentDirectoryString() + this.currentTab);
        } else {
            this.chooseFileName.setText(JaxoIO.baseName(f));
        }
        return optionsPanel;
    }

    private JPanel getButtonPanel() {
        this.previewButton = new JButton();
        this.previewButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.preview();
            }
        });
        this.exportButton = new JButton();
        this.exportButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.exportButtonClicked();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoExportPanel.this.cancelButtonClicked();
            }
        });
        JPanel buttonPanel = new JPanel(false);
        buttonPanel.add(this.previewButton);
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    private void setupFileFormatComboBox() {
        DefaultComboBoxModel fileFormats = new DefaultComboBoxModel(){
            private static final long serialVersionUID = 7526471155622777L;

            public void setSelectedItem(Object value) {
                if (value instanceof JaxoExportPlugin) {
                    super.setSelectedItem(value);
                } else {
                    int selectedIndex;
                    int index = this.getIndexOf(value);
                    if (index < (selectedIndex = this.getIndexOf(this.getSelectedItem())) && index > 0) {
                        this.setSelectedItem(this.getElementAt(index - 1));
                    } else if (index > selectedIndex && index < this.getSize() - 1) {
                        this.setSelectedItem(this.getElementAt(index + 1));
                    }
                }
            }
        };
        boolean addSeparator = false;
        for (Object o : this.exports) {
            if (o instanceof List) {
                if (addSeparator) {
                    fileFormats.addElement(new Object());
                }
                Iterator j = ((List)o).iterator();
                while (j.hasNext()) {
                    fileFormats.addElement(j.next());
                }
                addSeparator = true;
                continue;
            }
            if (addSeparator) {
                fileFormats.addElement(new Object());
            }
            fileFormats.addElement(o);
            addSeparator = false;
        }
        this.chooseFileFormat = new JComboBox(fileFormats);
        this.chooseFileFormat.setMaximumRowCount(20);
        this.chooseFileFormat.setSelectedIndex(0);
        this.chooseFileFormat.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                if (JaxoExportPanel.this.oldSelectedExport != JaxoExportPanel.this.chooseFileFormat.getSelectedItem()) {
                    JaxoExportPanel.this.updateSelectedExport();
                    JaxoExportPanel.this.oldSelectedExport = (JaxoExportPlugin)JaxoExportPanel.this.chooseFileFormat.getSelectedItem();
                }
            }
        });
        this.oldSelectedExport = (JaxoExportPlugin)this.chooseFileFormat.getSelectedItem();
        this.chooseFileFormat.setRenderer(new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 7526471155622777L;
            private JSeparator separator = new JSeparator();
            {
                JaxoLooknFeel.registerComponent(this);
                JaxoLooknFeel.registerComponent(this.separator);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
                if (!(value instanceof JaxoExportPlugin)) {
                    return this.separator;
                }
                JaxoExportPlugin e = (JaxoExportPlugin)value;
                return super.getListCellRendererComponent((JList<?>)list, e.getFormatName(), index, selected, focused);
            }
        });
    }

    private CompoundBorder getExportPanelBorder() {
        String title = LANGUAGE.value("/Options");
        return BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), new JaxoTitledBorder(title)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private void chooseFileName() {
        String extension = this.getSelectedExport().getFileExtension();
        String describe = this.getSelectedExport().getFileExtensionDescription();
        JaxoChooseFile c = new JaxoChooseFile(this.parent);
        c.setApproveText(LANGUAGE.value("fileChooser.approveText"));
        if (this.currentTab.length() > 0) {
            c.setDialogTitle(LANGUAGE.message("fileChooser.named%0DialogTitle", this.currentTab));
        } else {
            c.setDialogTitle(LANGUAGE.value("fileChooser.dialogTitle"));
        }
        String fileName = c.chooseFile(new String[]{extension}, describe, this.chooseFileName.getText()).trim();
        if (fileName.length() > 0) {
            this.chooseFileName.setText(fileName);
            this.addExtension();
        }
    }

    private void updateSelectedExport() {
        String warning;
        this.cutExtension();
        this.addExtension();
        JaxoExportPlugin e = this.getSelectedExport();
        this.configurationPanelParent.removeAll();
        JComponent c = e.getConfigurationPanel();
        if (c == null) {
            this.configurationPanelParent.add(new JLabel(" "));
        } else {
            this.configurationPanelParent.add(c);
        }
        this.configurationPanelParent.revalidate();
        this.configurationPanelParent.repaint();
        if (this.dialog.isVisible()) {
            Dimension d1 = this.dialog.getPreferredSize();
            Dimension d2 = this.dialog.getSize();
            d2.width = Math.max(d2.width, d1.width);
            d2.height = Math.max(d2.height, d1.height);
            this.dialog.setSize(d2);
        }
        this.warningLabel.setText((warning = e.getWarningForGraph()) == null ? "<html><p>&nbsp;<p>&nbsp;" : warning);
    }

    private JaxoExportPlugin getSelectedExport() {
        JaxoExportPlugin e = (JaxoExportPlugin)this.chooseFileFormat.getSelectedItem();
        if (e != null) {
            e.setParentComponent(this.dialog);
            e.setShortGraphName(this.currentTab);
            e.setGraph(this.graph);
        }
        return e;
    }

    private void cutExtension() {
        String extension = this.oldSelectedExport.getFileExtension();
        String fileName = this.chooseFileName.getText().trim();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && fileName.substring(index + 1).equals(extension)) {
            fileName = fileName.substring(0, index);
            this.chooseFileName.setText(fileName);
        }
    }

    private void addExtension() {
        String extension = this.getSelectedExport().getFileExtension();
        String fileName = this.chooseFileName.getText();
        String newFileName = JaxoIO.withExtension(fileName.trim(), extension);
        if (!newFileName.equals(fileName)) {
            this.chooseFileName.setText(newFileName);
        }
    }

    private void exportButtonClicked() {
        File f;
        JaxoExportPlugin e = this.getSelectedExport();
        if (e == null) {
            this.dialog.dispose();
            return;
        }
        this.cutExtension();
        this.addExtension();
        String fileName = this.chooseFileName.getText().trim();
        if (this.chooseFileName.getText().length() == 0) {
            this.chooseFileName();
            fileName = this.chooseFileName.getText().trim();
            if (fileName.length() == 0) {
                return;
            }
        }
        if (!JaxoIO.shouldOverwrite(this.dialog, f = new File(fileName))) {
            return;
        }
        this.graph.setSaveFileName(JaxoIO.baseName(f.getAbsolutePath()));
        e.commitConfiguration();
        e.export(this.chooseFileName.getText());
        this.dialog.dispose();
    }

    private void cancelButtonClicked() {
        this.dialog.dispose();
    }

    private void preview() {
        JaxoExportPlugin e = this.getSelectedExport();
        if (e != null) {
            e.commitConfiguration();
            e.preview(this.preview.copy(), !this.newPreviewFrame);
        }
    }
}

