/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class JaxoGlassPane
extends JComponent {
    private static final long serialVersionUID = 75264711556226147L;
    private final JFrame theParent;
    private final JComponent theViewPort;

    public JaxoGlassPane(JFrame parent, JComponent viewPort) {
        this.theParent = parent;
        this.theViewPort = viewPort;
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JaxoGlassPane.this.stopPointMouseAction();
            }
        });
    }

    private void stopPointMouseAction() {
        Action action = this.theViewPort.getActionMap().get("stopPointMouseAction");
        if (action != null) {
            action.actionPerformed(null);
        }
    }

    public boolean contains(int x, int y) {
        Point p = SwingUtilities.convertPoint(this, new Point(x, y), this.theParent.getContentPane());
        Component c = this.theParent.getContentPane().findComponentAt(p);
        if (c == this.theViewPort) {
            return false;
        }
        while (!(c instanceof JScrollPane) && c != null) {
            c = c.getParent();
        }
        return c == null || ((JScrollPane)c).getViewport().getView() != this.theViewPort;
    }
}

