/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.imports;

import java.awt.geom.Point2D;
import net.sf.jaxodraw.io.imports.JaxoAxodraw;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectFactory;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.object.arrow.JaxoDefaultArrow;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoAxodraw4J
extends JaxoAxodraw {
    private static final String[] KNOWN_COMMANDS = new String[]{"\\Bezier", "\\DashBezier", "\\Line", "\\Arc", "\\PhotonArc", "\\Photon", "\\GluonArc", "\\GlueArc", "\\Gluon"};
    private static final int N_OF_COMMANDS = KNOWN_COMMANDS.length;
    private String string = "";
    private int index;

    public JaxoAxodraw4J() {
        this.removePackage("axodraw");
        this.addPackage("axodraw4j");
    }

    public JaxoObject getJaxoObject(String newString) {
        this.string = newString;
        JaxoObject newob = null;
        boolean valid = this.validJaxo4JCommand(this.string);
        if (valid) {
            if (this.index == -10) {
                newob = this.newFBezier();
            } else if (this.index == -9) {
                newob = this.newSBezier();
            } else if (this.index == -8) {
                newob = this.newGBezier();
            } else if (this.index == -7) {
                newob = this.newPBezier();
            } else if (this.index == -6) {
                newob = this.newGlBezier();
            } else if (this.index == -5) {
                newob = this.newA4JLine();
            } else if (this.index == -4) {
                newob = this.newA4JArc();
            } else if (this.index == -3) {
                newob = this.newA4JPLine();
            } else if (this.index == -2) {
                newob = this.newA4JGlLine();
            } else if (this.index == -1) {
                newob = this.newA4JPArc();
            } else if (this.index == 0) {
                newob = this.newA4JGlArc();
            } else if (this.index == 1) {
                newob = this.newVertexT4();
            }
        } else {
            newob = super.getJaxoObject(newString);
        }
        return newob;
    }

    private boolean validJaxo4JCommand(String s) {
        int i;
        for (i = 0; !s.startsWith(KNOWN_COMMANDS[i]) && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (i == N_OF_COMMANDS - 1 && !s.startsWith(KNOWN_COMMANDS[i])) {
            ++i;
        }
        this.index = i;
        if (i == this.getIndex("\\Bezier")) {
            if (s.indexOf("%JaxoID:FBez") > 0) {
                this.index = -10;
            } else if (s.indexOf("%JaxoID:PBez") > 0) {
                this.index = -7;
            } else if (s.indexOf("%JaxoID:GlBez") > 0) {
                this.index = -6;
            } else if (s.indexOf("%JaxoID:SBez") > 0) {
                this.index = -9;
            } else if (s.indexOf("%JaxoID:GBez") > 0) {
                this.index = -8;
            }
        } else if (i == this.getIndex("\\DashBezier")) {
            if (s.indexOf("%JaxoID:SBez") > 0) {
                this.index = -9;
            } else if (s.indexOf("%JaxoID:GBez") > 0) {
                this.index = -8;
            }
        } else if (i == this.getIndex("\\Line")) {
            this.index = s.indexOf("\\Line", 6) > 0 && s.indexOf(37) == -1 ? 1 : -5;
        } else if (i == this.getIndex("\\Arc")) {
            this.index = -4;
        } else if (i == this.getIndex("\\Photon")) {
            this.index = -3;
        } else if (i == this.getIndex("\\Gluon")) {
            this.index = -2;
        } else if (i == this.getIndex("\\PhotonArc")) {
            this.index = -1;
        } else if (i == this.getIndex("\\GluonArc") || i == this.getIndex("\\GlueArc")) {
            this.index = 0;
        }
        return i < N_OF_COMMANDS;
    }

    private int getIndex(String s) {
        int i;
        for (i = 0; KNOWN_COMMANDS[i].compareTo(s) != 0 && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (KNOWN_COMMANDS[i].compareTo(s) == 0) {
            return i;
        }
        return N_OF_COMMANDS;
    }

    protected int[] getEightInts(String str) {
        return this.getEightInts(str, 0);
    }

    protected int[] getEightInts(String str, int fromIndex) {
        int[] ints = new int[8];
        int start = str.indexOf(40, fromIndex);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[4] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[5] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[6] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[7] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getBezierParams(int[] coords) {
        int[] out = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        out[0] = Math.round((float)coords[0] * this.getScaleFactor());
        out[1] = Math.round(this.getBBoxHeight() - (float)coords[1] * this.getScaleFactor());
        out[2] = Math.round((float)coords[2] * this.getScaleFactor());
        out[3] = Math.round(this.getBBoxHeight() - (float)coords[3] * this.getScaleFactor());
        out[4] = Math.round((float)coords[4] * this.getScaleFactor());
        out[5] = Math.round(this.getBBoxHeight() - (float)coords[5] * this.getScaleFactor());
        out[6] = Math.round((float)coords[6] * this.getScaleFactor());
        out[7] = Math.round(this.getBBoxHeight() - (float)coords[7] * this.getScaleFactor());
        return out;
    }

    private String[] getOptions(String str) {
        int start = str.indexOf(91);
        if (start == -1) {
            return new String[0];
        }
        String[] options = new String[20];
        int stop = str.indexOf(93);
        int cindex = str.indexOf(44, start);
        int optnumb = 0;
        while (cindex < stop) {
            options[optnumb] = str.substring(start + 1, cindex);
            start = cindex;
            cindex = str.indexOf(44, start + 1);
            ++optnumb;
        }
        options[optnumb] = str.substring(start + 1, stop);
        String[] result = new String[optnumb + 1];
        System.arraycopy(options, 0, result, 0, optnumb + 1);
        return result;
    }

    private boolean isArrow(String[] options) {
        boolean itis = false;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("arrow")) continue;
            itis = true;
        }
        return itis;
    }

    private boolean isDouble(String[] options) {
        boolean itis = false;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("double")) continue;
            itis = true;
        }
        return itis;
    }

    private static boolean contains(String string, String token) {
        return string.indexOf(token) != -1;
    }

    private float[] getArrowParameters(String[] options) {
        float[] arrowParameters = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 0.0f};
        float[] defaults = this.get4jArrowDefaults(options);
        for (int i = 0; i < options.length; ++i) {
            int start = options[i].indexOf(61);
            int stop = options[i].length();
            if (JaxoAxodraw4J.contains(options[i], "arrowpos")) {
                arrowParameters[0] = Float.parseFloat(options[i].substring(start + 1, stop));
                continue;
            }
            if (JaxoAxodraw4J.contains(options[i], "arrowlength")) {
                arrowParameters[1] = Float.parseFloat(options[i].substring(start + 1, stop));
                continue;
            }
            if (JaxoAxodraw4J.contains(options[i], "arrowwidth")) {
                arrowParameters[2] = Float.parseFloat(options[i].substring(start + 1, stop));
                continue;
            }
            if (JaxoAxodraw4J.contains(options[i], "arrowinset")) {
                arrowParameters[3] = Float.parseFloat(options[i].substring(start + 1, stop));
                continue;
            }
            if (JaxoAxodraw4J.contains(options[i], "arrowscale")) {
                arrowParameters[4] = Float.parseFloat(options[i].substring(start + 1, stop));
                continue;
            }
            if (!JaxoAxodraw4J.contains(options[i], "flip")) continue;
            arrowParameters[5] = 1.0f;
        }
        if (arrowParameters[1] == -1.0f && arrowParameters[2] != -1.0f) {
            arrowParameters[1] = 2.5f * arrowParameters[2];
        }
        if (arrowParameters[2] == -1.0f && arrowParameters[1] != -1.0f) {
            arrowParameters[2] = arrowParameters[1] / 2.5f;
        }
        for (int j = 0; j < arrowParameters.length - 1; ++j) {
            if (arrowParameters[j] == -1.0f) {
                arrowParameters[j] = defaults[j];
            }
            if (arrowParameters[4] == 1.0f) continue;
            arrowParameters[j] = arrowParameters[j] * arrowParameters[4];
        }
        return arrowParameters;
    }

    private float getDashParameter(String[] options) {
        float dashSize = 0.0f;
        for (int i = 0; i < options.length; ++i) {
            int start = options[i].indexOf(61);
            int stop = options[i].length();
            if (!JaxoAxodraw4J.contains(options[i], "dashsize") && !JaxoAxodraw4J.contains(options[i], "dsize")) continue;
            dashSize = Float.parseFloat(options[i].substring(start + 1, stop));
        }
        return dashSize;
    }

    private float getDoubleLineParameter(String[] options) {
        float dlSeparation = -1.0f;
        for (int i = 0; i < options.length; ++i) {
            int start = options[i].indexOf(61);
            int stop = options[i].length();
            if (!JaxoAxodraw4J.contains(options[i], "sep")) continue;
            dlSeparation = Float.parseFloat(options[i].substring(start + 1, stop));
        }
        if (dlSeparation == -1.0f) {
            dlSeparation = JaxoPrefs.getFloatPref("prefDLSEP");
        }
        return dlSeparation;
    }

    private boolean getClockwiseParameter(String[] options) {
        boolean isClock = false;
        for (int i = 0; i < options.length; ++i) {
            if (!JaxoAxodraw4J.contains(options[i], "clock")) continue;
            isClock = true;
        }
        return isClock;
    }

    private JaxoObject newFBezier() {
        int[] pars = this.getBezierParams(this.getEightInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(18);
        this.setBezierPoints(newOb, pars);
        if (this.string.indexOf(91) > 0) {
            this.setArrow(this.getOptions(this.string), newOb);
        } else {
            newOb.setParameter("paintArrow", false);
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        return newOb;
    }

    private JaxoObject newSBezier() {
        float dash;
        int[] pars = this.getBezierParams(this.getEightInts(this.string));
        try {
            dash = Float.parseFloat(this.getOneCurl(this.string)) * this.getScaleFactor();
        }
        catch (StringIndexOutOfBoundsException e) {
            dash = this.getDashParameter(this.getOptions(this.string)) * this.getScaleFactor();
        }
        JaxoObject newOb = JaxoObjectFactory.newObject(21);
        this.setBezierPoints(newOb, pars);
        int arrowPos = this.string.indexOf("\\Line");
        if (arrowPos > 0) {
            this.setArrow(this.getOptions(this.string.substring(arrowPos)), newOb);
        } else {
            newOb.setParameter("paintArrow", false);
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("dash", dash);
        return newOb;
    }

    private JaxoObject newGBezier() {
        float dash;
        int[] pars = this.getBezierParams(this.getEightInts(this.string));
        try {
            dash = Float.parseFloat(this.getOneCurl(this.string)) * this.getScaleFactor();
        }
        catch (StringIndexOutOfBoundsException e) {
            dash = this.getDashParameter(this.getOptions(this.string)) * this.getScaleFactor();
        }
        JaxoObject newOb = JaxoObjectFactory.newObject(22);
        this.setBezierPoints(newOb, pars);
        int arrowPos = this.string.indexOf("\\Line");
        if (arrowPos > 0) {
            this.setArrow(this.getOptions(this.string.substring(arrowPos)), newOb);
        } else {
            newOb.setParameter("paintArrow", false);
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("dash", dash);
        return newOb;
    }

    private JaxoObject newPBezier() {
        int[] pars = this.getEightInts(this.string, this.string.indexOf(37));
        String[] ampwig = this.getTwoCurls(this.string);
        String redshift = this.getOneBrace(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(19);
        this.setBezierPoints(newOb, pars);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0])));
        newOb.setParameter("noFreqStretching", Boolean.parseBoolean(redshift));
        newOb.setParameter("frequencyFromWiggles", Math.round(Float.parseFloat(ampwig[1])));
        return newOb;
    }

    private JaxoObject newGlBezier() {
        int[] pars = this.getEightInts(this.string, this.string.indexOf(37));
        String[] ampwig = this.getTwoCurls(this.string);
        String redshift = this.getOneBrace(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(20);
        this.setBezierPoints(newOb, pars);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0])));
        newOb.setParameter("noFreqStretching", Boolean.parseBoolean(redshift));
        newOb.setParameter("frequencyFromWiggles", Math.round(Float.parseFloat(ampwig[1])));
        return newOb;
    }

    private JaxoObject newA4JLine() {
        String[] options = this.getOptions(this.string);
        boolean isarr = this.isArrow(options);
        boolean isdoub = this.isDouble(options);
        float dsize = this.getDashParameter(options) * this.getScaleFactor();
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        JaxoObject newOb = null;
        if (dsize == 0.0f) {
            newOb = JaxoObjectFactory.newObject(3);
        } else {
            newOb = dsize > 5.0f ? JaxoObjectFactory.newObject(6) : JaxoObjectFactory.newObject(9);
            newOb.setParameter("dash", dsize);
        }
        if (isarr) {
            this.setArrow(options, newOb);
        } else {
            newOb.setParameter("paintArrow", false);
        }
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("relativeWidth", pars[2]);
        newOb.setParameter("relativeHeight", pars[3]);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        return newOb;
    }

    private JaxoObject newA4JArc() {
        String[] options = this.getOptions(this.string);
        boolean isarr = this.isArrow(options);
        boolean isdoub = this.isDouble(options);
        float dsize = this.getDashParameter(options) * this.getScaleFactor();
        boolean clock = this.getClockwiseParameter(options);
        String[] st = this.getArcBrackets(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        int phi2 = Math.round(Float.parseFloat(st[4]));
        JaxoObject newOb = null;
        if (Math.abs(phi1 - phi2) >= 360) {
            if (dsize == 0.0f) {
                newOb = JaxoObjectFactory.newObject(4);
            } else {
                newOb = dsize > 5.0f ? JaxoObjectFactory.newObject(7) : JaxoObjectFactory.newObject(10);
                newOb.setParameter("dash", dsize);
            }
            int[] pars = this.getLoopPars(st, this.string, clock);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter("relativeWidth", pars[2]);
            newOb.setParameter("relativeHeight", pars[3]);
        } else {
            if (dsize == 0.0f) {
                newOb = JaxoObjectFactory.newObject(5);
            } else {
                newOb = dsize > 5.0f ? JaxoObjectFactory.newObject(8) : JaxoObjectFactory.newObject(11);
                newOb.setParameter("dash", dsize);
            }
            this.setArcPoints(st, clock, newOb);
        }
        if (isarr) {
            this.setArrow(options, newOb);
        } else {
            newOb.setParameter("paintArrow", false);
        }
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        return newOb;
    }

    private JaxoObject newA4JPLine() {
        String[] options = this.getOptions(this.string);
        boolean isdoub = this.isDouble(options);
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(12);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("relativeWidth", pars[2]);
        newOb.setParameter("relativeHeight", pars[3]);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]);
        boolean symmetric = (double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001;
        newOb.setParameter("symmetric", symmetric);
        newOb.setParameter("frequencyFromWiggles", (int)Math.floor(nOfWiggles));
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        return newOb;
    }

    private JaxoObject newA4JGlLine() {
        String[] options = this.getOptions(this.string);
        boolean isdoub = this.isDouble(options);
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(15);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("relativeWidth", pars[2]);
        newOb.setParameter("relativeHeight", pars[3]);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]) * this.getScaleFactor();
        newOb.setParameter("frequencyFromWiggles", Math.round(nOfWiggles));
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        return newOb;
    }

    private JaxoObject newA4JPArc() {
        int phi2;
        String[] options = this.getOptions(this.string);
        boolean isdoub = this.isDouble(options);
        boolean clock = this.getClockwiseParameter(options);
        JaxoObject newOb = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, false);
            newOb = JaxoObjectFactory.newObject(13);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter("relativeWidth", -pars[2]);
            newOb.setParameter("relativeHeight", -pars[3]);
        } else {
            newOb = JaxoObjectFactory.newObject(14);
            this.setArcPoints(st, clock, newOb);
            float nOfWiggles = Float.parseFloat(ampwig[1]);
            boolean symmetric = (double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001;
            newOb.setParameter("symmetric", symmetric);
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]);
        if ((double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001) {
            nOfWiggles -= 0.5f;
        }
        newOb.setParameter("frequencyFromWiggles", Math.round(nOfWiggles));
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        return newOb;
    }

    private JaxoObject newA4JGlArc() {
        int phi2;
        String[] options = this.getOptions(this.string);
        boolean isdoub = this.isDouble(options);
        boolean clock = this.getClockwiseParameter(options);
        JaxoObject newOb = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, false);
            newOb = JaxoObjectFactory.newObject(16);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter("relativeWidth", -pars[2]);
            newOb.setParameter("relativeHeight", -pars[3]);
            newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        } else {
            newOb = JaxoObjectFactory.newObject(17);
            this.setArcPoints(st, clock, newOb);
            newOb.setParameter("amp", Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        }
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        float nOfWiggles = Float.parseFloat(ampwig[1]) * this.getScaleFactor();
        newOb.setParameter("frequencyFromWiggles", Math.round(nOfWiggles));
        if (isdoub) {
            float dlsep = this.getDoubleLineParameter(options) * this.getScaleFactor();
            newOb.setParameter("doubleLine", true);
            newOb.setParameter("dLSeparation", dlsep);
        } else {
            newOb.setParameter("doubleLine", false);
            newOb.setParameter("dLSeparation", JaxoPrefs.getFloatPref("prefDLSEP"));
        }
        return newOb;
    }

    private JaxoObject newVertexT4() {
        int[] firstl = this.getFourInts(this.string);
        int[] secondl = this.getFourInts(this.string, this.string.lastIndexOf("\\Line"));
        int[] pars = this.getT4Params(firstl, secondl);
        JaxoObject newOb = JaxoObjectFactory.newObject(339);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("relativeWidth", pars[2]);
        newOb.setParameter("relativeHeight", pars[3]);
        newOb.setParameter("strokeWidth", this.getStroke());
        newOb.setParameter("color", this.getColor());
        return newOb;
    }

    private float[] get4jArrowDefaults(String[] options) {
        float[] defaults = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        float dlsep = 0.0f;
        if (this.isDouble(options)) {
            dlsep = this.getDoubleLineParameter(options);
        }
        defaults[0] = 0.5f;
        defaults[2] = 1.2f * (2.0f + 0.7f * dlsep + this.getStroke());
        defaults[1] = 2.5f * defaults[2];
        defaults[3] = 0.2f;
        defaults[4] = 1.0f;
        defaults[5] = 0.0f;
        return defaults;
    }

    private void setArcPoints(String[] st, boolean clock, JaxoObject newOb) {
        Point2D[] pts = this.getArcPoints(st, clock);
        newOb.setParameter("x", (int)Math.round(pts[0].getX()));
        newOb.setParameter("y", (int)Math.round(pts[0].getY()));
        newOb.setParameter("x2", (int)Math.round(pts[1].getX()));
        newOb.setParameter("y2", (int)Math.round(pts[1].getY()));
        newOb.setParameter("x3", (int)Math.round(pts[2].getX()));
        newOb.setParameter("y3", (int)Math.round(pts[2].getY()));
    }

    private void setArrow(String[] options, JaxoObject newOb) {
        float[] arrowParameters = this.getArrowParameters(options);
        JaxoDefaultArrow arrow = new JaxoDefaultArrow();
        arrow.setArrowLength(arrowParameters[1]);
        arrow.setArrowWidth(arrowParameters[2]);
        arrow.setArrowInset(arrowParameters[3]);
        newOb.setParameter("arrow", JaxoArrow.class, arrow);
        newOb.setParameter("paintArrow", true);
        newOb.setParameter("arrowPosition", arrowParameters[0]);
        if (arrowParameters[5] == 1.0f) {
            newOb.setParameter("flip", true);
        }
    }

    private void setBezierPoints(JaxoObject newOb, int[] pars) {
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("x2", pars[2]);
        newOb.setParameter("y2", pars[3]);
        newOb.setParameter("x3", pars[4]);
        newOb.setParameter("y3", pars[5]);
        newOb.setParameter("x4", pars[6]);
        newOb.setParameter("y4", pars[7]);
    }
}

