/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arrow;

import java.awt.Color;
import java.awt.Stroke;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoUtils;

public abstract class AbstractBaseArrow
implements JaxoArrow {
    private static final long serialVersionUID = 2L;
    private Color color;
    private Color fillColor;
    private boolean filled;
    private transient Stroke stroke;
    private float arrowWidth;
    private float arrowLength;
    private float arrowInset;

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color c) {
        this.fillColor = c;
    }

    public final boolean isFilled() {
        return this.filled;
    }

    public final void setFilled(boolean value) {
        this.filled = value;
    }

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(Stroke newStroke) {
        this.stroke = newStroke;
    }

    public final float getArrowWidth() {
        return this.arrowWidth;
    }

    public final void setArrowWidth(float newWidth) {
        if (newWidth < -1.0E-4f) {
            throw new IllegalArgumentException("Arrow width negative!");
        }
        this.arrowWidth = newWidth < 0.0f ? 0.0f : newWidth;
    }

    public final float getArrowLength() {
        return this.arrowLength;
    }

    public final void setArrowLength(float newLength) {
        if (newLength < -1.0E-4f) {
            throw new IllegalArgumentException("Arrow length negative!");
        }
        this.arrowLength = newLength < 0.0f ? 0.0f : newLength;
    }

    public final float getArrowInset() {
        return this.arrowInset;
    }

    public final void setArrowInset(float newInset) {
        if (newInset < -1.0E-4f || newInset > 1.0001f) {
            throw new IllegalArgumentException("Arrow inset out of range: " + newInset);
        }
        this.arrowInset = newInset < 0.0f ? 0.0f : (newInset > 1.0f ? 1.0f : newInset);
    }

    public JaxoArrow copy() {
        try {
            return (AbstractBaseArrow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean isCopy(JaxoArrow testArrow) {
        boolean equalStroke;
        boolean equalFillColors;
        boolean equalColors;
        boolean isCopy = false;
        if (!(testArrow instanceof AbstractBaseArrow)) {
            return false;
        }
        AbstractBaseArrow baseArrow = (AbstractBaseArrow)testArrow;
        boolean bl = this.getColor() == null ? baseArrow.getColor() == null : (equalColors = this.getColor().equals(baseArrow.getColor()));
        boolean bl2 = this.getFillColor() == null ? baseArrow.getFillColor() == null : (equalFillColors = this.getFillColor().equals(baseArrow.getFillColor()));
        boolean bl3 = this.getStroke() == null ? baseArrow.getStroke() == null : (equalStroke = this.getStroke().equals(baseArrow.getStroke()));
        if (equalColors && equalFillColors && equalStroke && baseArrow.isFilled() == this.isFilled() && JaxoUtils.equal(baseArrow.getArrowWidth(), this.getArrowWidth()) && JaxoUtils.equal(baseArrow.getArrowInset(), this.getArrowInset()) && JaxoUtils.equal(baseArrow.getArrowLength(), this.getArrowLength())) {
            isCopy = true;
        }
        return isCopy;
    }
}

