/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.fill;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoRotationObject;
import net.sf.jaxodraw.object.fill.JaxoFillObject;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoBlob
extends JaxoFillObject
implements JaxoRotationObject {
    private static final long serialVersionUID = 2L;
    private transient Ellipse2D blob = new Ellipse2D.Float();
    private static final int LP4 = 12;
    private int rotationAngle;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.blob = new Ellipse2D.Float();
    }

    public final int getRotationAngle() {
        return this.rotationAngle;
    }

    public final void setRotationAngle(int newangle) {
        Integer old = this.rotationAngle;
        this.rotationAngle = newangle;
        this.firePropertyChange("rotationAngle", old, this.rotationAngle);
    }

    public final void copyFrom(JaxoBlob temp) {
        super.copyFrom(temp);
        this.setRotationAngle(temp.getRotationAngle());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoBlob)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoBlob)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        JaxoBlob temp;
        boolean isCopy = false;
        if (comp instanceof JaxoBlob && (temp = (JaxoBlob)comp).getRotationAngle() == this.getRotationAngle() && super.isCopy(temp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public final void paintVisualAid(JaxoGraphics2D g2) {
        int x = this.getX();
        int y = this.getY();
        g2.drawLine(x - 12, y, x + 12, y);
        g2.drawLine(x, y - 12, x, y + 12);
    }

    public final void paint(JaxoGraphics2D g2) {
        this.updateShape();
        if (this.isFilled()) {
            g2.setColor(this.getFillColor());
            g2.fill(this.getShape());
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getShape());
    }

    public Rectangle getBounds() {
        this.updateShape();
        return this.getStroke().createStrokedShape(this.getShape()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D axes = this.getLaTexAxes(scale);
        if ((int)axes.getX() == 0 && (int)axes.getY() == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        int rotate = this.getLaTexRotation();
        String command = "";
        if (this.isFilled()) {
            if (JaxoColor.isGrayScale(this.getFillColor())) {
                float grayScale = JaxoColor.getGrayScaleFloat(this.getFillColor());
                command = "\\GOval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + D_FORMAT.format(rotate) + ")" + "{" + GRAY_SCALE_FORMAT.format(grayScale) + "}";
            } else {
                String tlc = JaxoColor.isGrayScale(this.getColor()) ? "Gray" : JaxoColor.getColorName(this.getColor());
                String tfc = JaxoColor.getColorName(this.getFillColor());
                command = "\\COval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + D_FORMAT.format(rotate) + ")" + "{" + tlc + "}" + "{" + tfc + "}";
            }
        } else {
            command = "\\Oval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")" + "(" + D_FORMAT.format(rotate) + ")";
        }
        return command;
    }

    public void setPreferences() {
        super.setPreferences();
        this.setRotationAngle(0);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.addCenterSizePanel(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0, 0);
        editPanel.addRotationPanel(this.getRotationAngle(), 0, 1);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 2);
        editPanel.addFillLineColorPanels(this.getColor(), this.getFillColor(), this.isFilled(), 1, 1, 1, 0);
        editPanel.setTitleAndIcon("Blob_parameters", "blob.png");
    }

    private Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        return this.getLaTexLocation(scaleFactor, canvasHeight);
    }

    private Point2D getLaTexAxes(float scaleFactor) {
        Point2D.Float axesVec = new Point2D.Float();
        float wdt = (float)this.getWidth() / scaleFactor;
        float hgt = (float)this.getHeight() / scaleFactor;
        ((Point2D)axesVec).setLocation(wdt, hgt);
        return axesVec;
    }

    private int getLaTexRotation() {
        return -this.rotationAngle;
    }

    private Shape getShape() {
        return this.rotationAngle == 0 ? this.blob : this.getGeneralPath();
    }

    private void updateShape() {
        this.blob.setFrame(-this.getWidth() + this.getX(), -this.getHeight() + this.getY(), 2 * this.getWidth(), 2 * this.getHeight());
        if (this.rotationAngle != 0) {
            GeneralPath p = this.getGeneralPath();
            p.reset();
            p.append(this.blob, false);
            p.transform(AffineTransform.getRotateInstance(Math.toRadians(this.rotationAngle), this.getX(), this.getY()));
        }
    }
}

