/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoParticleObject;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoLineObject
extends JaxoParticleObject {
    public static final int SELECT_P0 = -5;
    private static final long serialVersionUID = 2L;

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoLineObject) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoLineObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoLineObject)o);
    }

    public int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        int selected = super.getGrabbedHandle(clickX, clickY, h);
        if (this.isAroundCenter(clickX, clickY, h)) {
            selected = -5;
        }
        return selected;
    }

    private boolean isAroundCenter(int clickX, int clickY, JaxoHandle h) {
        return h.contains(clickX, clickY, (this.getX() + this.getX2()) / 2, (this.getY() + this.getY2()) / 2);
    }

    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
        h.paint(g2, (this.getX() + this.getX2()) / 2, (this.getY() + this.getY2()) / 2, this.isMarked(), !this.canBeSelected(-5, editMode));
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0 || handle == 1 || handle == -5;
        if (mode == 451) {
            active = handle == 0 || handle == 1;
        }
        return active;
    }

    public final float smallestDistanceTo(int px, int py) {
        int distY;
        int distX;
        float dist2;
        float dist1 = super.smallestDistanceTo(px, py);
        return dist1 < (dist2 = (float)Math.sqrt((distX = px - (this.getX2() + this.getX()) / 2) * distX + (distY = py - (this.getY2() + this.getY()) / 2) * distY)) ? dist1 : dist2;
    }

    public void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        Rectangle bb = this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    public String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            return "%";
        }
        String options = this.getAxo4JOptions(scale);
        return "\\Line" + options + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")";
    }

    protected Point2D getLaTexStartPoint(float scaleFactor, int canvasHeight) {
        return this.getLaTexLocation(scaleFactor, canvasHeight);
    }

    protected Point2D getLaTexEndPoint(float scaleFactor, int canvasHeight) {
        Point2D.Float endVec = new Point2D.Float();
        ((Point2D)endVec).setLocation((float)this.getX2() / scaleFactor, (float)(canvasHeight - this.getY2()) / scaleFactor);
        return endVec;
    }

    protected Point2D getLatexDLOffSet(float scaleFactor) {
        Point2D.Float offSet = new Point2D.Float();
        float lSep = this.getDLSeparation() / scaleFactor;
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        ((Point2D)offSet).setLocation((double)lSep * Math.sin(theta), (double)lSep * Math.cos(theta));
        return offSet;
    }

    public JaxoArrow.Coordinates arrowCoordinates() {
        double length = this.length();
        float arp = this.getArrowPosition();
        double theta = Math.atan2(this.getY2() - this.getY(), this.getX2() - this.getX());
        double x = (double)this.getX() + (double)arp * length * Math.cos(theta);
        double y = (double)this.getY() + (double)arp * length * Math.sin(theta);
        if (this.isFlip()) {
            theta += Math.PI;
        }
        return new JaxoArrow.Coordinates(x, y, theta);
    }

    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D p = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        this.setLocation((int)Math.round(p.getX()), (int)Math.round(p.getY()));
        this.setX2(this.getX() + newRelWidth);
        this.setY2(this.getY() + newRelHeight);
        this.setWiggles(Math.round((float)this.getWiggles() * scale));
        this.setAmp(Math.round((float)this.getAmp() * scale));
    }

    public double length() {
        return Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
    }

    protected abstract GeneralPath getObjectPath();

    protected abstract String getAxo4JOptions(float var1);
}

