/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.vertex.JaxoVertex;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT1
extends JaxoVertex {
    private static final long serialVersionUID = 314159L;
    private transient Ellipse2D vertex = new Ellipse2D.Float();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.vertex = new Ellipse2D.Float();
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT1) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        this.updateVertex();
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.fill(this.vertex);
        g2.draw(this.vertex);
    }

    public Rectangle getBounds() {
        this.updateVertex();
        return this.getStroke().createStrokedShape(this.vertex).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        return "\\Vertex(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "{" + D_FORMAT.format(radius) + "}";
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        this.prepareGenericPanel(editPanel, "vertexT1.png");
    }

    private void updateVertex() {
        double length = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        this.vertex.setFrame(-length + (double)this.getX(), -length + (double)this.getY(), 2.0 * length, 2.0 * length);
    }
}

