/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import javax.swing.ImageIcon;

public final class JaxoUtils {
    public static final String LINE_SEPARATOR;
    private static final Dimension DEFAULT_IMAGE_SIZE;

    private JaxoUtils() {
    }

    public static boolean equal(float a, float b, float epsilon) {
        float eps = epsilon;
        if (JaxoUtils.zero(eps)) {
            eps = 1.0E-5f;
        } else if (eps < 0.0f) {
            throw new IllegalArgumentException("Negative accuracy!");
        }
        boolean equal = false;
        equal = Math.abs(a) < eps ? Math.abs(b) < eps : Math.abs((a - b) / a) < eps;
        return equal;
    }

    public static boolean equal(float a, float b) {
        return JaxoUtils.equal(a, b, 0.001f);
    }

    public static boolean zero(double a) {
        return Math.abs(a) < 0.001;
    }

    public static void drawImageArea(Image m, int x, int y, int width, int height, Graphics g) {
        JaxoUtils.drawImageArea(m, x, y, width, height, g, x, y);
    }

    public static void drawImageArea(Image m, int x, int y, int width, int height, Graphics g, int gx, int gy) {
        int x2 = x + width;
        int y2 = y + height;
        int gx2 = gx + width;
        int gy2 = gy + height;
        g.drawImage(m, gx, gy, gx2, gy2, x, y, x2, y2, null);
    }

    public static ImageIcon newImageIcon(String resourceName) {
        return new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("resources/icons/" + resourceName));
    }

    public static Image newImage(String resourceName) {
        return Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("resources/icons/" + resourceName));
    }

    public static Image getChooserImage(Color iconColor) {
        return JaxoUtils.getChooserImage(iconColor, DEFAULT_IMAGE_SIZE);
    }

    public static Image getChooserImage(Color iconColor, Dimension size) {
        int[] pixels = new int[size.width * size.height];
        Arrays.fill(pixels, iconColor.getRGB());
        MemoryImageSource source = new MemoryImageSource(size.width, size.height, pixels, 0, size.width);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    public static ImageIcon getChooserImageIcon(Color iconColor) {
        return new ImageIcon(JaxoUtils.getChooserImage(iconColor));
    }

    public static ImageIcon getChooserImageIcon(Color iconColor, Dimension size) {
        return new ImageIcon(JaxoUtils.getChooserImage(iconColor, size));
    }

    public static boolean isButton1(MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    public static boolean isButton2(MouseEvent e) {
        return (e.getModifiers() & 8) != 0;
    }

    public static boolean isButton3(MouseEvent e) {
        return (e.getModifiers() & 4) != 0;
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        int max = array.length - 1;
        StringBuffer sb = new StringBuffer("[");
        for (int j = 0; j <= max; ++j) {
            sb.append(String.valueOf(array[j]));
            if (j >= max) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean equals(Object[] expected, Object[] actual) {
        return Arrays.equals(expected, actual);
    }

    public static boolean equivalent(Object[] expected, Object[] actual) {
        Arrays.sort(expected);
        Arrays.sort(actual);
        return JaxoUtils.equals(expected, actual);
    }

    static {
        DEFAULT_IMAGE_SIZE = new Dimension(40, 15);
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

