package com.bluedragontavern.albumgrabber;

import java.io.*;
import java.util.*;

/**
 * Keeps track of interesting statistics and reports them at the end
 */
public class Report
{
	private static Report instance = null;
	private boolean reportRun = false;
	private long startTime;
	private long endTime;
	private int numAlbumsSkipped = 0;
	private int numAlbumsProcessed = 0;
	private int numAlbumsLocated = 0;
	private int numAlbumsStored = 0;
	private int numArtistsSkipped = 0;
	private int numArtistsProcessed = 0;
	private int numArtistsLocated = 0;
	private int numArtistsStored = 0;

	//These are used only when running tests
	private int numArtistsMatched = 0;
	private int numAlbumsMatched = 0;

	/**
	 * Singleton get method
	 */
	public synchronized static Report getInstance()
	{
		if (instance == null)
		{
			instance = new Report();
		}

		return instance;
	}

	/**
	 * Creates a new Cache object.
	 */
	private Report()
	{
	}

	/**
	 * Print out the report!
	 */
	public synchronized void report()
	{
		//Make sure we only run the report once!
		if (reportRun)
		{
			return;
		}

		StringBuffer buffer = new StringBuffer();
		buffer.append("   ***********\n");
		buffer.append("   * Results *\n");
		buffer.append("   ***********\n");
		buffer.append("Time started: " + (new Date(startTime)).toString() +
						  "\n");
		buffer.append("Num albums skipped: " + numAlbumsSkipped + "\n");
		buffer.append("Num albums processed: " + numAlbumsProcessed + "\n");
		buffer.append("Num albums located: " + numAlbumsLocated + "\n");
		buffer.append("Num albums stored: " + numAlbumsStored + "\n");

		//Used for testing
		if (numAlbumsMatched > 0)
		{
			buffer.append("Num albums matched: " + numAlbumsMatched + "\n");
		}

		buffer.append("Num artists skipped: " + numArtistsSkipped + "\n");
		buffer.append("Num artists processed: " + numArtistsProcessed + "\n");
		buffer.append("Num artists located: " + numArtistsLocated + "\n");
		buffer.append("Num artists stored: " + numArtistsStored + "\n");

		//Used for testing
		if (numArtistsMatched > 0)
		{
			buffer.append("Num artists matched: " + numArtistsMatched + "\n");
		}

		buffer.append("Time finished: " + (new Date(endTime)).toString() + "\n");
		buffer.append("Total time: " + (endTime - startTime) / 1000 +
						  " seconds" + "\n");

		//Print buffer to stdout
		System.out.println(buffer.toString());

		//Print buffer to report.txt
		try
		{
			PrintWriter out = new PrintWriter(new BufferedWriter(
				new FileWriter("report.txt")));
			out.print(buffer.toString());
			out.flush();
		}
		catch (Exception ex)
		{
			System.out.println("Could not print to report.txt : " + ex);
		}

		reportRun = true;
	}

	public void setStartTime(long startTime)
	{
		this.startTime = startTime;
	}

	public void setEndTime(long endTime)
	{
		this.endTime = endTime;
	}

	public void incNumAlbumsSkipped()
	{
		++numAlbumsSkipped;
	}

	public void incNumAlbumsProcessed()
	{
		++numAlbumsProcessed;
	}

	public void incNumAlbumsLocated()
	{
		++numAlbumsLocated;
	}

	public void incNumAlbumsStored()
	{
		++numAlbumsStored;
	}

	public void incNumAlbumsMatched()
	{
		++numAlbumsMatched;
	}

	public void incNumArtistsSkipped()
	{
		++numArtistsSkipped;
	}

	public void incNumArtistsProcessed()
	{
		++numArtistsProcessed;
	}

	public void incNumArtistsLocated()
	{
		++numArtistsLocated;
	}

	public void incNumArtistsStored()
	{
		++numArtistsStored;
	}

	public void incNumArtistsMatched()
	{
		++numArtistsMatched;
	}
}