package dks.src.test.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import typecontrol.controls.JdksColorChooser;
import typecontrol.controls.JdksFileChooser;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;

import dks.src.borderEditor.JdksBorderEditorPane;
import dks.src.gradientEditor.JdksGradientEditor;
import dks.src.shadowEditor.JdksShadowEditorPane;
import dks.src.test.FrmMain;
import dks.src.textureEditor.JdksTextureEditorPane;
import dks.src.textureEditor.PanLayer;
import dks.src.warpEditor.JdksWarpEditorPane;
import dks.src.wordart.CWordArt;
import dks.src.wordart.JdksWordArtEditorPane;


/**
 * @author   DKS
 */
public class TestFrmMain extends JFCTestCase {

	private FrmMain _form;
	private JFCTestHelper _helper;

	protected void setUp( ) throws IOException, Exception {
		super.setUp( );

		File file = new File("C:" + File.separator + "test.jpg");
		if (!file.exists()) {
			file.createNewFile();
		}

        _helper = new JFCTestHelper();

        _form = new FrmMain();
        _form.setVisible(true);
        awtSleep();
	}

	protected void tearDown( ) throws Exception {
		_form = null;

		File file = new File("C:" + File.separator + "test.jpg");
		if (file.exists()) {
			file.delete();
		}

		try {
			JFCTestHelper.cleanUp(this);
		} catch (Exception e) {}
        super.tearDown( );
    }

	private JComponent getComponent(Container container, String name) {
		NamedComponentFinder finder = new NamedComponentFinder(JComponent.class, name);
	    JComponent component = (JComponent) finder.find(container, 0);
	    assertNotNull("Le composant " + name + " n'a pas t trouv", component);
	    return component;
	}

	private Property getProperty(PropertySheetPanel table, String propertyName) {
		Property[] properties = table.getProperties();
		for (int i = 0; i < properties.length; i++) {
			if (properties[i].getName().equals(propertyName)) {
				return properties[i];
			} else {
				Property[] subProperties = properties[i].getSubProperties();
				for (int j = 0; j < subProperties.length; j++) {
					if (subProperties[j].getName().equals(propertyName)) {
						return subProperties[j];
					}
				}
			}
		}
		return null;
	}

	public void testWordArt() {
		JTabbedPane mainTabbedPane = (JTabbedPane) getComponent(_form, FrmMain.TAB_MAIN_NAME);
		mainTabbedPane.setSelectedIndex(0);

		PropertySheetPanel tableText = (PropertySheetPanel) getComponent(_form, FrmMain.TAB_WORDART_NAME);
		Property property = getProperty(tableText, JdksWordArtEditorPane.TEXT_PROPERTY_NAME);

		CWordArt model = _form.getModel();

		property.setValue("nouveau texte");
		assertEquals("La modification du texte du wordart n'est pas effective", model.getText(), "nouveau texte");

		property = getProperty(tableText, JdksWordArtEditorPane.FONT_PROPERTY_NAME);
		property.setValue(new Font("Verdana", 18, Font.BOLD));
		assertEquals("La modification du texte du wordart n'est pas effective", model.getFont(), new Font("Verdana", 18, Font.BOLD));

		property = getProperty(tableText, JdksWordArtEditorPane.AUTOSIZEFONT_PROPERTY_NAME);
		property.setValue(Boolean.valueOf(false));
		assertEquals("La modification de l'auto-dimensionnement du texte du wordart n'est pas effective", model.isAutoSizeFont(), false);


		property = getProperty(tableText, JdksWordArtEditorPane.BACKGROUND_COLOR_PROPERTY_NAME);
		property.setValue(new Color(1, 2, 3, 0));
		assertEquals("La modification de la couleur de fond du wordart n'est pas effective", model.getBackgroundColor(), new Color(1, 2, 3, 0));

		property = getProperty(tableText, JdksWordArtEditorPane.BACKGROUND_OPACITY_PROPERTY_NAME);
		property.setValue(Integer.valueOf(128));
		assertEquals("La modification de l'opacit de la couleur de fond du wordart n'est pas effective", model.getBackgroundColor().getAlpha(), 128);

		property = getProperty(tableText, JdksWordArtEditorPane.DIMENSION_WIDTH_PROPERTY_NAME);
		property.setValue(Integer.valueOf(128));
		assertEquals("La modification de la largeur du wordart n'est pas effective", model.getDimension().getWidth(), new Double(128));

		property = getProperty(tableText, JdksWordArtEditorPane.DIMENSION_HEIGHT_PROPERTY_NAME);
		property.setValue(Integer.valueOf(128));
		assertEquals("La modification de la hauteur du wordart n'est pas effective", model.getDimension().getHeight(), new Double(128));

		property = getProperty(tableText, JdksWordArtEditorPane.TOTALSIZE_WIDTH_PROPERTY_NAME);
		property.setValue(Integer.valueOf(64));
		assertEquals("La modification de la largeur de l'image n'est pas effective", model.getTotalSize().getWidth(), new Double(64));

		property = getProperty(tableText, JdksWordArtEditorPane.TOTALSIZE_HEIGHT_PROPERTY_NAME);
		property.setValue(Integer.valueOf(63));
		assertEquals("La modification de la hauteur de l'image n'est pas effective", model.getTotalSize().getHeight(), new Double(63));

		property = getProperty(tableText, JdksWordArtEditorPane.DIMENSION_STRETCH_PROPERTY_NAME);
		property.setValue(Boolean.valueOf(false));
		assertEquals("La modification du stretching du wordart n'est pas effective", model.isStretch(), false);

		mainTabbedPane.setSelectedIndex(1);
		PropertySheetPanel tableBorder = (PropertySheetPanel) getComponent(_form, FrmMain.TAB_BORDER_NAME);
		property = getProperty(tableBorder, JdksBorderEditorPane.PROPERTY_COLOR_NAME);
		property.setValue(new Color(1, 2, 3, 4));
		assertEquals("La modification de la couleur de la bordure n'est pas effective", model.getBorder().getColor(), new Color(1, 2, 3, 4));

		property = getProperty(tableBorder, JdksBorderEditorPane.PROPERTY_WIDTH_NAME);
		property.setValue(4);
		assertEquals("La modification de la largeur de la bordure n'est pas effective", model.getBorder().getWidth(), 4);

		property = getProperty(tableBorder, JdksBorderEditorPane.PROPERTY_VISIBLE_NAME);
		property.setValue(false);
		assertEquals("La modification de la visibilit de la bordure n'est pas effective", model.getBorder().isVisible(), false);

		mainTabbedPane.setSelectedIndex(2);
		JTabbedPane tableTexture = (JTabbedPane) getComponent(_form, FrmMain.PAN_TEXTURE_NAME);

		tableTexture.setSelectedIndex(0);
		JTabbedPane tableBackgroundTexture = (JTabbedPane) getComponent(tableTexture, FrmMain.PAN_BACKGROUND_NAME);
		JdksColorChooser colorProperty = (JdksColorChooser) getComponent(tableBackgroundTexture, FrmMain.PAN_BACKGROUND_NAME + PanLayer.TAB_COLOR_NAME);
		colorProperty.setValue("RGB(1,2,3,4)");
		assertEquals("La modification de la couleur d'arrire plan n'est pas effective", model.getTexture().getBackgroundLayer().getColor(), new Color(1, 2, 3, 4));

		tableBackgroundTexture.setSelectedIndex(1);
		JButton buttonAddColor = (JButton) getComponent(tableTexture, JdksGradientEditor.BTN_ADD_COLOR_NAME);
		JButton buttonRemoveColor = (JButton) getComponent(tableTexture, JdksGradientEditor.BTN_REMOVE_COLOR_NAME);
		JdksGradientEditor gradientEditor = (JdksGradientEditor) getComponent(tableBackgroundTexture, FrmMain.PAN_BACKGROUND_NAME + PanLayer.DKS_GRADIENT_NAME);
		PropertySheetPanel backgroundGradientEditor = (PropertySheetPanel) getComponent(gradientEditor, JdksGradientEditor.TAB_COLOR_NAME);

		property = getProperty(backgroundGradientEditor, JdksGradientEditor.ANGLE_PROPERTY_NAME);
		property.setValue(10);
		assertEquals("La modification de l'angle du dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().getAngle(), 10);

		property = getProperty(backgroundGradientEditor, JdksGradientEditor.RADIAL_PROPERTY_NAME);
		property.setValue(false);
		assertEquals("La modification de la radialit du dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().isRadial(), false);

		property = getProperty(backgroundGradientEditor, JdksGradientEditor.SUBPROPERTY_POSITION_NAME + "0");
		property.setValue(10);
		assertEquals("La modification de la position de la couleur du dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().get(0).getPosition(), 10);

		property = getProperty(backgroundGradientEditor, JdksGradientEditor.SUBPROPERTY_COLOR_NAME + "0");
		property.setValue(new Color(1, 2, 3, 4));
		assertEquals("La modification de la couleur du dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().get(0).getColor(), new Color(1, 2, 3, 4));

		assertEquals("Le nombre de couleurs du dgrad n'est pas correct", model.getTexture().getBackgroundLayer().getGradient().size(), 2);
		_helper.enterClickAndLeave(new MouseEventData(this, buttonAddColor));
		assertEquals("L'ajout d'une couleur au dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().size(), 3);
		_helper.enterClickAndLeave(new MouseEventData(this, buttonRemoveColor));
		assertEquals("La suppression d'une couleur au dgrad n'est pas effective", model.getTexture().getBackgroundLayer().getGradient().size(), 2);

		tableBackgroundTexture.setSelectedIndex(2);
		JdksFileChooser fileProperty = (JdksFileChooser) getComponent(tableBackgroundTexture, FrmMain.PAN_BACKGROUND_NAME + PanLayer.TAB_IMAGE_NAME);
		fileProperty.setValue("C:\\test.jpg");
		assertEquals("La modification de l'image d'arrire plan n'est pas effective", model.getTexture().getBackgroundLayer().getImageFileName(), "C:\\test.jpg");

		tableTexture.setSelectedIndex(1);
		JTabbedPane tableForegroundTexture = (JTabbedPane) getComponent(tableTexture, FrmMain.PAN_FOREGROUND_NAME);
		colorProperty = (JdksColorChooser) getComponent(tableForegroundTexture, FrmMain.PAN_FOREGROUND_NAME + PanLayer.TAB_COLOR_NAME);
		colorProperty.setValue("RGB(1,2,3,4)");
		assertEquals("La modification de la couleur d'avant plan n'est pas effective", model.getTexture().getForegroundLayer().getColor(), new Color(1, 2, 3, 4));

		tableForegroundTexture.setSelectedIndex(1);
		buttonAddColor = (JButton) getComponent(tableTexture, JdksGradientEditor.BTN_ADD_COLOR_NAME);
		buttonRemoveColor = (JButton) getComponent(tableTexture, JdksGradientEditor.BTN_REMOVE_COLOR_NAME);
		gradientEditor = (JdksGradientEditor) getComponent(tableForegroundTexture, FrmMain.PAN_FOREGROUND_NAME + PanLayer.DKS_GRADIENT_NAME);
		PropertySheetPanel foregroundGradientEditor = (PropertySheetPanel) getComponent(gradientEditor, JdksGradientEditor.TAB_COLOR_NAME);

		property = getProperty(foregroundGradientEditor, JdksGradientEditor.ANGLE_PROPERTY_NAME);
		property.setValue(10);
		assertEquals("La modification de l'angle du dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().getAngle(), 10);

		property = getProperty(foregroundGradientEditor, JdksGradientEditor.RADIAL_PROPERTY_NAME);
		property.setValue(false);
		assertEquals("La modification de la radialit du dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().isRadial(), false);

		property = getProperty(foregroundGradientEditor, JdksGradientEditor.SUBPROPERTY_POSITION_NAME + "0");
		property.setValue(10);
		assertEquals("La modification de la position de la couleur du dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().get(0).getPosition(), 10);

		property = getProperty(foregroundGradientEditor, JdksGradientEditor.SUBPROPERTY_COLOR_NAME + "0");
		property.setValue(new Color(1, 2, 3, 4));
		assertEquals("La modification de la couleur du dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().get(0).getColor(), new Color(1, 2, 3, 4));

		assertEquals("Le nombre de couleurs du dgrad n'est pas correct", model.getTexture().getForegroundLayer().getGradient().size(), 2);
		_helper.enterClickAndLeave(new MouseEventData(this, buttonAddColor));
		assertEquals("L'ajout d'une couleur au dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().size(), 3);
		_helper.enterClickAndLeave(new MouseEventData(this, buttonRemoveColor));
		assertEquals("La suppression d'une couleur au dgrad n'est pas effective", model.getTexture().getForegroundLayer().getGradient().size(), 2);

		tableForegroundTexture.setSelectedIndex(2);
		fileProperty = (JdksFileChooser) getComponent(tableForegroundTexture, FrmMain.PAN_FOREGROUND_NAME + PanLayer.TAB_IMAGE_NAME);
		fileProperty.setValue("C:\\test.jpg");
		assertEquals("La modification de l'image d'avant plan n'est pas effective", model.getTexture().getForegroundLayer().getImageFileName(), "C:\\test.jpg");

		tableTexture.setSelectedIndex(2);
		PropertySheetPanel texturePropertiesEditor = (PropertySheetPanel) getComponent(tableTexture, FrmMain.TAB_TEXTURE_NAME);

		property = getProperty(texturePropertiesEditor, JdksTextureEditorPane.PROPERTY_WIDTH);
		property.setValue(10);
		assertEquals("La modification de la largeur de la texture n'est pas effective", model.getTexture().getWidth(), 10);

		property = getProperty(texturePropertiesEditor, JdksTextureEditorPane.PROPERTY_HEIGHT);
		property.setValue(20);
		assertEquals("La modification de la hauteur de la texture n'est pas effective", model.getTexture().getHeight(), 20);

		property = getProperty(texturePropertiesEditor, JdksTextureEditorPane.PROPERTY_MASK);
		File file = new File("C:" + File.separator + "test.jpg");
		property.setValue(file);
		assertEquals("La modification de l'image du masque de la texture n'est pas effective", model.getTexture().getMaskFileName(), "C:\\test.jpg");

		property = getProperty(texturePropertiesEditor, JdksTextureEditorPane.PROPERTY_TEXTURE);
		property.setValue(file);
		assertEquals("La modification de l'image de la texture n'est pas effective", model.getTexture().getTextureFileName(), "C:\\test.jpg");

		mainTabbedPane.setSelectedIndex(3);
		JPanel panWarp = (JPanel) getComponent(_form, FrmMain.TAB_WARP_NAME);
		JButton buttonAddLine = (JButton) getComponent(panWarp, FrmMain.BTN_ADD_LINE_NAME);
		JButton buttonRemoveLine = (JButton) getComponent(panWarp, FrmMain.BTN_REMOVE_LINE_NAME);
		JButton buttonAddColumn = (JButton) getComponent(panWarp, FrmMain.BTN_ADD_COLUMN_NAME);
		JButton buttonRemoveColumn = (JButton) getComponent(panWarp, FrmMain.BTN_REMOVE_COLUMN_NAME);
		JdksWarpEditorPane warpEditor = (JdksWarpEditorPane) getComponent(_form, FrmMain.PAN_WARP_EDITOR_NAME);

		_helper.enterClickAndLeave(new MouseEventData(this, buttonAddColumn));
		assertEquals("La modification du nombre de colonnes n'est pas effective", model.getWarp().getColNumber(), 5);
		warpEditor.reloadModel();
		Property propertyColumnNumber = getProperty(warpEditor, JdksWarpEditorPane.PROPERTY_POINTS_NUMBER_X);
		assertEquals("La modification du nombre de colonnes n'est pas effective", propertyColumnNumber.getValue(), 5);

		_helper.enterClickAndLeave(new MouseEventData(this, buttonRemoveColumn));
		assertEquals("La suppression de colonnes n'est pas effective", model.getWarp().getColNumber(), 4);
		warpEditor.reloadModel();
		propertyColumnNumber = getProperty(warpEditor, JdksWarpEditorPane.PROPERTY_POINTS_NUMBER_X);
		assertEquals("La suppression de colonnes n'est pas effective", propertyColumnNumber.getValue(), 4);

		_helper.enterClickAndLeave(new MouseEventData(this, buttonAddLine));
		assertEquals("La modification du nombre de lignes n'est pas effective", model.getWarp().getLineNumber(), 5);
		warpEditor.reloadModel();
		Property propertyLineNumber = getProperty(warpEditor, JdksWarpEditorPane.PROPERTY_POINTS_NUMBER_Y);
		assertEquals("La modification du nombre de lignes n'est pas effective", propertyLineNumber.getValue(), 5);

		_helper.enterClickAndLeave(new MouseEventData(this, buttonRemoveLine));
		assertEquals("La suppression de lignes n'est pas effective", model.getWarp().getLineNumber(), 4);
		warpEditor.reloadModel();
		propertyLineNumber = getProperty(warpEditor, JdksWarpEditorPane.PROPERTY_POINTS_NUMBER_Y);
		assertEquals("La suppression de lignes n'est pas effective", propertyLineNumber.getValue(), 4);

		property = getProperty(warpEditor, JdksWarpEditorPane.PROPERTY_ACTIVE_NAME);
		property.setValue(false);
		System.out.println(model.getWarp().isActive());
		assertEquals("La modification de l'activit du warp n'est pas effective", model.getWarp().isActive(), false);

		mainTabbedPane.setSelectedIndex(4);
		PropertySheetPanel shadowEditor = (PropertySheetPanel) getComponent(_form, FrmMain.TAB_SHADOW_NAME);
		property = getProperty(shadowEditor, JdksShadowEditorPane.ANGLE_PROPERTY_NAME);
		property.setValue(20);
		assertEquals("La modification de l'angle de l'ombre n'est pas effective", model.getShadow().getAngle(), 20);

		property = getProperty(shadowEditor, JdksShadowEditorPane.COLOR_PROPERTY_NAME);
		property.setValue(new Color(1, 2, 3, 4));
		assertEquals("La modification de la couleur de l'ombre n'est pas effective", model.getShadow().getColor(), new Color(1, 2, 3, 4));

		property = getProperty(shadowEditor, JdksShadowEditorPane.DISTANCE_PROPERTY_NAME);
		property.setValue(30);
		assertEquals("La modification de la distance de l'ombre n'est pas effective", model.getShadow().getDistance(), 30);

		property = getProperty(shadowEditor, JdksShadowEditorPane.OPACITY_PROPERTY_NAME);
		property.setValue(0.25f);
		assertEquals("La modification de l'opacit de l'ombre n'est pas effective", model.getShadow().getOpacity(), 0.25f);

		property = getProperty(shadowEditor, JdksShadowEditorPane.SIZE_PROPERTY_NAME);
		property.setValue(2);
		assertEquals("La modification de la taille de l'ombre n'est pas effective", model.getShadow().getSize(), 2);

		property = getProperty(shadowEditor, JdksShadowEditorPane.VISIBLE_PROPERTY_NAME);
		property.setValue(false);
		assertEquals("La modification de la visibilit de l'ombre n'est pas effective", model.getShadow().isVisible(), false);
	}
}
