package typecontrol.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

import typecontrol.CTypeControl;
import typecontrol.IdksTypeControl;

public class JdksCheckBox extends JComponent implements IdksTypeControl {

	public static final String CHK_SELECTED = "True";
	public static final String CHK_NOT_SELECTED = "False";
	
	private static final long serialVersionUID = 1L;

	private GUI _gui;
	private ActionListen _actionListener;
	private JCheckBox _chkControl;
	private CTypeControl _typeControl;
	
	public JdksCheckBox(String label, String info) {
		_typeControl = new CTypeControl();
		initialize(label, info);
	}
	
	public JdksCheckBox(String label) {
		_typeControl = new CTypeControl();
		initialize(label, "");
	}
	
	private void initialize(String label, String info) {
		setLabel(label);
		setInfo(info);
		_actionListener = new ActionListen();
		_gui = new GUI();
	}

	public Color getBackground() {
		if (_gui != null) {
			return _gui.getChkControl().getBackground();
		} else {
			return Color.white;
		}
	}
	
	public void setBackground(Color background) {
		_gui.getChkControl().setBackground(background);
	}
	
	public void setNormalBackground(Color background) {}
	
	public String getValue() {
		if (_gui.getChkControl().isSelected()) {
			return CHK_SELECTED;
		} else {
			return CHK_NOT_SELECTED;
		}
	}

	public void setValue(String value) {
		if (value.equals("True")) {
			_gui.getChkControl().setSelected(true);
		} else {
			_gui.getChkControl().setSelected(false);
		}
	}
	
	public void setInfo(String info) {
		_typeControl.setInfo(info);
		if (_gui != null) {
			_gui.rebuildGUI();
		}
	}
	
	public void setLabel(String label) {
		_typeControl.setLabel(label);
		if (_gui != null) {
			_gui.rebuildGUI();
		}
	}
	
	public void setEnabled(Boolean enabled) {
		_gui.getChkControl().setEnabled(enabled);
	}
	
	public boolean isEnabled() {
		if (_gui != null) {
			return _gui.getChkControl().isEnabled();
		} else {
			return true;
		}
	}
		
	private void chkControl_Click() {
		_typeControl.raiseChangeListener(this);
	}
	
	private class GUI {
		protected static final String CHK_CONTROL_NAME = "chkControl";
		
		private JPanel _panButtons;
		
		public GUI() {
			rebuildGUI();
		}
		
		protected void rebuildGUI() {
			setLayout(new BorderLayout());
			removeAll();
			if (_typeControl.getLabel() != null && !_typeControl.getLabel().equals("")) {
				add(_typeControl.getLabLabel(), BorderLayout.WEST);
			}
			
			add(getChkControl(), BorderLayout.CENTER);

			_panButtons = null;
			add(getPanButtons(), BorderLayout.EAST);
			updateUI();
		}
				
		protected JPanel getPanButtons() {
			if (_panButtons == null) {
				_panButtons = new JPanel();
				_panButtons.setLayout(new BorderLayout());
				if (_typeControl.getInfo() != null && !_typeControl.getInfo().equals("")) {
					_panButtons.add(_typeControl.getBtnInfo(), BorderLayout.EAST);
				}
			}
			return _panButtons;
		}

		protected JCheckBox getChkControl() {
			if (_chkControl == null) {
				_chkControl = new JCheckBox();
				_chkControl.setName(CHK_CONTROL_NAME);
				_chkControl.addActionListener(_actionListener);
			}
			return _chkControl;
		}
	}
	
	private class ActionListen implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(GUI.CHK_CONTROL_NAME)) {
				chkControl_Click();
			}	
		}
	}

	public void addChangeListener(ChangeListener changeListener) {
		if (_typeControl != null) {
			_typeControl.addChangeListener(changeListener);
		}
	}

	public JButton getBtnInfo() {
		return _typeControl.getBtnInfo();
	}

	public Color getFocusBackground() {
		return _typeControl.getFocusBackground();
	}

	public String getInfo() {
		return _typeControl.getInfo();
	}

	public String getLabel() {
		return _typeControl.getLabel();
	}

	public JLabel getLabLabel() {
		return _typeControl.getLabLabel();
	}

	public void raiseChangeListener(IdksTypeControl source) {
		_typeControl.raiseChangeListener(source);
	}

	public void removeChangeListener(ChangeListener changeListener) {
		_typeControl.removeChangeListener(changeListener);
	}

	public void setFocusBackground(Color focusBackground) {
		_typeControl.setFocusBackground(focusBackground);
	}

	public void setLabelAlignment(int alignment) {
		_typeControl.setLabelAlignment(alignment);
	}

	public void setLabelWidth(int width) {
		_typeControl.setLabelWidth(width);
	}

}
