/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.stamppagetor.ImageCache;

public class ImageSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -8593612347003196803L;
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String OK_COMMAND = "Ok";
    private JButton cancelButton = null;
    private JButton okButton = null;
    private JList listControl = null;
    private final ImageCache images;
    private String selectedFile = null;

    public ImageSelectionDialog(JFrame jFrame, ImageCache imageCache) {
        super(jFrame, "Select image", true);
        this.images = imageCache;
    }

    public void showDialog() {
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setResizable(true);
        this.setVisible(true);
    }

    public String getSelection() {
        return this.selectedFile;
    }

    JButton getOKButton() {
        return this.okButton;
    }

    private Container createContentPane() {
        int n;
        this.cancelButton = new JButton(CANCEL_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton(OK_COMMAND);
        this.okButton.setActionCommand(OK_COMMAND);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        Object[] objectArray = this.images.getImageIds().toArray();
        ImageIcon[] imageIconArray = new ImageIcon[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            imageIconArray[n] = this.images.getThumbIcon((String)objectArray[n]);
        }
        this.listControl = new JList<ImageIcon>(imageIconArray);
        this.listControl.setSelectionMode(0);
        this.listControl.setLayoutOrientation(2);
        this.listControl.setVisibleRowCount(-1);
        this.listControl.addListSelectionListener(this);
        n = objectArray.length <= 25 ? 200 + objectArray.length * 20 : 800;
        JScrollPane jScrollPane = new JScrollPane(this.listControl);
        jScrollPane.setPreferredSize(new Dimension(n, n));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(jScrollPane);
        this.listControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ImageSelectionDialog.this.getOKButton().doClick();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.cancelButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        return container;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ImageIcon imageIcon;
        String string = actionEvent.getActionCommand();
        if (string.equals(CANCEL_COMMAND)) {
            this.selectedFile = null;
            this.setVisible(false);
        } else if (string.equals(OK_COMMAND) && (imageIcon = (ImageIcon)this.listControl.getSelectedValue()) != null) {
            this.selectedFile = imageIcon.getDescription();
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.okButton.setEnabled(this.listControl.getSelectedValue() != null);
    }
}

