/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.pdf;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.stamppagetor.pdf.PDFGraphics2D;
import org.stamppagetor.pdf.PDFObject;
import org.stamppagetor.pdf.PDFObjectCatalog;
import org.stamppagetor.pdf.PDFObjectContent;
import org.stamppagetor.pdf.PDFObjectFont;
import org.stamppagetor.pdf.PDFObjectOutlines;
import org.stamppagetor.pdf.PDFObjectPage;
import org.stamppagetor.pdf.PDFObjectPages;
import org.stamppagetor.pdf.PDFObjectResources;
import org.stamppagetor.pdf.PDFObjectXObject;

public class PDFDocument {
    private Vector<PDFObject> objects = new Vector();

    public void create(OutputStream outputStream, Pageable pageable, Printable printable, PageFormat pageFormat) throws IOException, PrinterException {
        int n;
        int n2 = pageable.getNumberOfPages();
        PDFObjectCatalog pDFObjectCatalog = new PDFObjectCatalog();
        PDFObjectPages pDFObjectPages = new PDFObjectPages();
        pDFObjectCatalog.setPages(pDFObjectPages);
        PDFObjectFont pDFObjectFont = new PDFObjectFont("Helvetica", 1);
        PDFObjectFont pDFObjectFont2 = new PDFObjectFont("Helvetica-Oblique", 2);
        PDFObjectFont pDFObjectFont3 = new PDFObjectFont("Helvetica-Bold", 3);
        this.objects.add(pDFObjectCatalog);
        this.objects.add(new PDFObjectOutlines());
        this.objects.add(pDFObjectPages);
        this.objects.add(pDFObjectFont);
        this.objects.add(pDFObjectFont2);
        this.objects.add(pDFObjectFont3);
        for (n = 0; n < n2; ++n) {
            PDFObjectPage pDFObjectPage = new PDFObjectPage(pageFormat);
            pDFObjectPages.addPage(pDFObjectPage);
            pDFObjectPage.setParent(pDFObjectPages);
            PDFObjectContent pDFObjectContent = new PDFObjectContent();
            PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(pageFormat);
            printable.print(pDFGraphics2D, pageFormat, n);
            pDFObjectContent.append(pDFGraphics2D.getContent());
            pDFObjectPage.setContent(pDFObjectContent);
            this.objects.add(pDFObjectPage);
            this.objects.add(pDFObjectContent);
            PDFObjectResources pDFObjectResources = new PDFObjectResources();
            pDFObjectResources.addFont(pDFObjectFont);
            pDFObjectResources.addFont(pDFObjectFont2);
            pDFObjectResources.addFont(pDFObjectFont3);
            this.objects.add(pDFObjectResources);
            pDFObjectPage.setResources(pDFObjectResources);
            Vector<PDFObjectXObject> vector = pDFGraphics2D.getImagesData();
            for (int i = 0; i < vector.size(); ++i) {
                pDFObjectResources.addImage(vector.elementAt(i));
                this.objects.add(vector.elementAt(i));
            }
        }
        n = 0;
        n = this.writeHeader(outputStream, n);
        n = this.writeBody(outputStream, n);
        n = this.writeXref(outputStream, n);
        n = this.writeTrailer(outputStream, n);
    }

    private int writeHeader(OutputStream outputStream, int n) throws IOException {
        outputStream.write("%PDF-1.3\r".getBytes());
        outputStream.write(37);
        outputStream.write(130);
        outputStream.write(216);
        outputStream.write(186);
        outputStream.write(251);
        outputStream.write(13);
        return 15;
    }

    private int writeBody(OutputStream outputStream, int n) throws IOException {
        int n2;
        int n3 = this.objects.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.objects.elementAt(n2).setIndex(n2 + 1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n += this.objects.elementAt(n2).write(outputStream, n);
        }
        return n;
    }

    private int writeXref(OutputStream outputStream, int n) throws IOException {
        int n2 = this.objects.size();
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("xref\r0 ");
        stringBuilder.append(n2);
        stringBuilder.append(" \r");
        stringBuilder.append("0000000000 65535 f \r");
        for (int i = 0; i < n2; ++i) {
            PDFObject pDFObject = this.objects.elementAt(i);
            stringBuilder.append(String.format("%010d 00000 n \r", new Integer(pDFObject.getOffset())));
        }
        byte[] byArray = stringBuilder.toString().getBytes();
        outputStream.write(byArray);
        return n;
    }

    private int writeTrailer(OutputStream outputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("trailer\r");
        stringBuilder.append("<<\r");
        stringBuilder.append("/Size " + this.objects.size() + "\r");
        stringBuilder.append("/Root 1 0 R\r");
        stringBuilder.append(">>\r");
        stringBuilder.append("startxref\r");
        stringBuilder.append(n);
        stringBuilder.append("\r");
        stringBuilder.append("%%EOF\r");
        byte[] byArray = stringBuilder.toString().getBytes();
        outputStream.write(byArray);
        return n;
    }
}

