/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;

public class StackReverser
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.getStackSize() == 1) {
            IJ.error("Flip Z", "This command requires a stack");
            return;
        }
        if (imp.isHyperStack()) {
            IJ.error("Flip Z", "This command does not currently work with hyperstacks.");
            return;
        }
        this.flipStack(imp);
    }

    public void flipStack(ImagePlus imp) {
        int n;
        ImageStack stack = imp.getStack();
        ImageStack stack2 = imp.createEmptyStack();
        while ((n = stack.getSize()) > 0) {
            stack2.addSlice(stack.getSliceLabel(n), stack.getProcessor(n));
            stack.deleteLastSlice();
        }
        imp.setStack(null, stack2);
    }
}

