/*
 * Decompiled with CFR 0.152.
 */
package org.bric.gui.preferences;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.bric.utils.Utils;

public class PreferencesFrame
extends JFrame {
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JComboBox jComboBox5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSpinner jSpinner1;
    private JTabbedPane jTabbedPane1;

    public PreferencesFrame() {
        this.initComponents();
        this.initialize();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jComboBox5 = new JComboBox();
        this.jSeparator4 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jSeparator3 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBox4 = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jTabbedPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setTabPlacement(2);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder(0));
        this.jLabel1.setText("Language");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"English"}));
        this.jLabel2.setText("Appearence");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"System Default"}));
        this.jLabel4.setText("Default output type");
        this.jLabel4.setToolTipText("if output type is \"same as first\" and export doesn't support initial file type");
        this.jComboBox5.setModel(new DefaultComboBoxModel<String>(new String[]{"JPG", "JPEG", "PNG", "GIF", "BMP", "TIF", "TIFF", "PGM", "PBM", "PNM", "PPM"}));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jSeparator2).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, -2, 166, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 140, Short.MAX_VALUE).addComponent(this.jComboBox2, -2, 165, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 104, Short.MAX_VALUE).addComponent(this.jComboBox5, -2, 165, -2))).addContainerGap()).addComponent(this.jSeparator4));
        jPanel2Layout.linkSize(0, this.jComboBox1, this.jComboBox2);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox5, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator4, -2, 13, -2).addContainerGap(78, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder(0));
        this.jLabel3.setText("Import/Export window close after (ms)");
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Generate Thumbnails");
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("Collect Metadata");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("on import");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.jRadioButton2.setText("on demand");
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setSelected(true);
        this.jRadioButton4.setText("on demand");
        this.buttonGroup2.add(this.jRadioButton3);
        this.jRadioButton3.setText("on import");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addComponent(this.jCheckBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton4)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2))).addGap(0, 83, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSpinner1, -2, 80, -2))).addContainerGap()).addComponent(this.jSeparator3));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jSpinner1, -2, -1, -2)).addContainerGap(122, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Thumbnails", this.jPanel1);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder(0));
        this.jLabel5.setText("Threads per process on import");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.jLabel6.setText("Threads per process on export");
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBox3, -2, 101, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addComponent(this.jComboBox4, -2, 101, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBox3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBox4, -2, -1, -2)).addContainerGap(169, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Advanced", this.jPanel4);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 466, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        layout.linkSize(0, this.jButton1, this.jButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.saveChanges();
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PreferencesFrame().setVisible(true);
            }
        });
    }

    private void restart() {
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = null;
        try {
            currentJar = new File(PreferencesFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!currentJar.getName().endsWith(".jar")) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-jar");
        command.add(currentJar.getPath());
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            builder.start();
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.exit(0);
    }

    private void saveChanges() {
        Utils.prefs.putInt("sleepValue", Integer.parseInt(this.jSpinner1.getValue().toString()));
        Utils.prefs.putBoolean("thumbnail", this.jCheckBox2.isSelected());
        Utils.prefs.putBoolean("metadata", this.jCheckBox3.isSelected());
        Utils.prefs.putInt("importNumThreads", this.jComboBox3.getSelectedIndex());
        Utils.prefs.putInt("exportNumThreads", this.jComboBox4.getSelectedIndex());
        int thumbnailWay = this.jRadioButton1.isSelected() ? 0 : 1;
        Utils.prefs.putInt("thumbWay", thumbnailWay);
        int metadataWay = this.jRadioButton3.isSelected() ? 0 : 1;
        Utils.prefs.putInt("metaWay", metadataWay);
        Utils.prefs.put("defaultFileType", this.jComboBox5.getSelectedItem().toString());
    }

    private void initialize() {
        Utils.centerWindow(this);
        int sleepValue = Utils.prefs.getInt("sleepValue", 500);
        SpinnerNumberModel time = new SpinnerNumberModel(sleepValue, 0, 10000, 1);
        this.jSpinner1.setModel(time);
        this.jCheckBox2.setSelected(Utils.prefs.getBoolean("thumbnail", true));
        this.jCheckBox3.setSelected(Utils.prefs.getBoolean("metadata", true));
        this.jComboBox3.setSelectedIndex(Utils.prefs.getInt("importNumThreads", 0));
        this.jComboBox4.setSelectedIndex(Utils.prefs.getInt("exportNumThreads", 0));
        this.jRadioButton1.setSelected(Utils.prefs.getInt("thumbWay", 0) == 0);
        this.jRadioButton2.setSelected(Utils.prefs.getInt("thumbWay", 0) == 1);
        this.jRadioButton3.setSelected(Utils.prefs.getInt("metaWay", 0) == 0);
        this.jRadioButton4.setSelected(Utils.prefs.getInt("metaWay", 0) == 1);
        this.jComboBox5.setSelectedItem(Utils.prefs.get("defaultFileType", "jpg"));
    }
}

