/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raf.FujiMakerNote;
import it.tidalwave.imageio.raf.FujiRawData;
import it.tidalwave.imageio.raf.FujiTable1;
import it.tidalwave.imageio.raf.RAFHeaderProcessor;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.tiff.ThumbnailLoader;
import java.awt.Dimension;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class RAFMetadata
extends TIFFMetadataSupport {
    private static final long serialVersionUID = 1795868418676854749L;

    public RAFMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
    }

    protected void postInit(@Nonnull RAWImageInputStream iis) {
        FujiRawData fujiRawData = ((RAFHeaderProcessor)this.headerProcessor).getFujiRawData();
        IFD exif = this.getExifIFD();
        this.thumbnailLoaders.add(new ThumbnailLoader(iis, fujiRawData.getJPEGImageOffset() + 12, fujiRawData.getJPEGImageLength(), exif.getPixelXDimension(), exif.getPixelYDimension()));
    }

    @CheckForNull
    public FujiMakerNote getFujiMakerNote() {
        return (FujiMakerNote)this.getMakerNote();
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isPhotometricInterpretationAvailable();
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isJPEGInterchangeFormatAvailable();
    }

    @Nonnull
    public FujiRawData getFujiRawData() {
        return ((RAFHeaderProcessor)this.headerProcessor).getFujiRawData();
    }

    @Nonnull
    protected Dimension getImageSize() {
        FujiTable1 fujiTable1 = this.getFujiRawData().getFujiTable1();
        return new Dimension(fujiTable1.getRotatedWidth(), fujiTable1.getRotatedHeight());
    }
}

