/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.cr2;

import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.ColorConversionOperation;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CR2ColorConversionOperation
extends ColorConversionOperation {
    private static final Logger logger = CR2ColorConversionOperation.getLogger(CR2ColorConversionOperation.class);
    private final Map<String, ColorMatrix> matrixMapByModel = new HashMap<String, ColorMatrix>();

    public CR2ColorConversionOperation() {
        this.matrixMapByModel.put("CANON EOS-1D", CR2ColorConversionOperation.get(new int[]{6806, -179, -1020, -8097, 16415, 1687, -3267, 4236, 7690}));
        this.matrixMapByModel.put("CANON EOS-1D MARK II", CR2ColorConversionOperation.get(new int[]{6264, -582, -724, -8312, 15948, 2504, -1744, 1919, 8664}));
        this.matrixMapByModel.put("CANON EOS-1D MARK II N", CR2ColorConversionOperation.get(new int[]{6240, -466, -822, -8180, 15825, 2500, -1801, 1938, 8042}));
        this.matrixMapByModel.put("CANON EOS-1D MARK III", CR2ColorConversionOperation.get(new int[]{6291, -540, -976, -8350, 16145, 2311, -1714, 1858, 7326}));
        this.matrixMapByModel.put("CANON EOS-1DS", CR2ColorConversionOperation.get(new int[]{4374, 3631, -1743, -7520, 15212, 2472, -2892, 3632, 8161}));
        this.matrixMapByModel.put("CANON EOS-1DS MARK II", CR2ColorConversionOperation.get(new int[]{6517, -602, -867, -8180, 15926, 2378, -1618, 1771, 7633}));
        this.matrixMapByModel.put("CANON EOS-1DS MARK III", CR2ColorConversionOperation.get(new int[]{5859, -211, -930, -8255, 16017, 2353, -1732, 1887, 7448}));
        this.matrixMapByModel.put("CANON EOS 5D", CR2ColorConversionOperation.get(new int[]{6347, -479, -972, -8297, 15954, 2480, -1968, 2131, 7649}));
        this.matrixMapByModel.put("CANON EOS 5D MARK II", CR2ColorConversionOperation.get(new int[]{4716, 603, -830, -7798, 15474, 2480, -1496, 1937, 6651}));
        this.matrixMapByModel.put("CANON EOS 10D DIGITAL", CR2ColorConversionOperation.get(new int[]{8197, -2000, -1118, -6714, 14335, 2592, -2536, 3178, 8266}));
        this.matrixMapByModel.put("CANON EOS 20Da", CR2ColorConversionOperation.get(new int[]{14155, -5065, -1382, -6550, 14633, 2039, -1623, 1824, 6561}));
        this.matrixMapByModel.put("CANON EOS 20D", CR2ColorConversionOperation.get(new int[]{6599, -537, -891, -8071, 15783, 2424, -1983, 2234, 7462}));
        this.matrixMapByModel.put("CANON EOS 30D", CR2ColorConversionOperation.get(new int[]{6257, -303, -1000, -7880, 15621, 2396, -1714, 1904, 7046}));
        this.matrixMapByModel.put("CANON EOS 40D", CR2ColorConversionOperation.get(new int[]{6071, -747, -856, -7653, 15365, 2441, -2025, 2553, 7315}));
        this.matrixMapByModel.put("CANON EOS 50D", CR2ColorConversionOperation.get(new int[]{4920, 616, -593, -6493, 13964, 2784, -1774, 3178, 7005}));
        this.matrixMapByModel.put("CANON EOS 350D DIGITAL", CR2ColorConversionOperation.get(new int[]{6018, -617, -965, -8645, 15881, 2975, -1530, 1719, 7642}));
        this.matrixMapByModel.put("CANON EOS 400D DIGITAL", CR2ColorConversionOperation.get(new int[]{7054, -1501, -990, -8156, 15544, 2812, -1278, 1414, 7796}));
        this.matrixMapByModel.put("CANON EOS 450D", CR2ColorConversionOperation.get(new int[]{5784, -262, -821, -7539, 15064, 2672, -1982, 2681, 7427}));
        this.matrixMapByModel.put("CANON EOS 1000D", CR2ColorConversionOperation.get(new int[]{6771, -1139, -977, -7818, 15123, 2928, -1244, 1437, 7533}));
    }

    @Nonnull
    private static ColorMatrix get(@Nonnull int[] values) {
        return CR2ColorConversionOperation.getMatrix(values, 1.0E-4);
    }

    @CheckForNull
    protected ColorMatrix getColorMatrixXYZ(@Nonnull PipelineArtifact artifact) {
        String model = ((TIFFMetadataSupport)artifact.getRAWMetadata()).getPrimaryIFD().getModel().toUpperCase().trim();
        ColorMatrix matrix = this.matrixMapByModel.get(model);
        logger.fine("getColorMatrixXYZ(%s) - model: %s, returning %s", artifact, model, matrix);
        return matrix;
    }
}

