/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.cr2;

import it.tidalwave.imageio.cr2.CR2Metadata;
import it.tidalwave.imageio.cr2.CR2SensorInfo;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import javax.annotation.Nonnull;

public class CR2SizeOperation
extends SizeOperation {
    private static final Logger logger = CR2SizeOperation.getLogger(CR2SizeOperation.class);

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        logger.fine("getCrop()", new Object[0]);
        Insets crop = super.getCrop(artifact);
        int rotation = this.normalizedAngle(artifact.getRotation());
        logger.finer(">>>> rotation: %d, crop: %s", rotation, crop);
        CR2Metadata metadata = (CR2Metadata)artifact.getRAWMetadata();
        CR2SensorInfo sensorInfo = metadata.getCanonMakerNote().getSensorInfo();
        crop.left = sensorInfo.getCropLeft();
        crop.top = sensorInfo.getCropTop();
        crop.right = sensorInfo.getWidth() - 1 - sensorInfo.getCropRight();
        crop.bottom = sensorInfo.getHeight() - 1 - sensorInfo.getCropBottom();
        logger.fine(">>>> returning crop: %s", crop);
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        logger.fine("getSize()", new Object[0]);
        CR2Metadata metadata = (CR2Metadata)artifact.getRAWMetadata();
        CR2SensorInfo sensorInfo = metadata.getCanonMakerNote().getSensorInfo();
        return new Dimension(sensorInfo.getCropRight() - sensorInfo.getCropLeft() + 1, sensorInfo.getCropBottom() - sensorInfo.getCropTop() + 1);
    }
}

