/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grelf.Maths;
import net.grelf.MeasuredValue;
import net.grelf.MixedUnitsException;
import net.grelf.Util;

public class Angle
implements Cloneable,
Comparable<Angle>,
Serializable {
    public static final double TWO_PI = Math.PI * 2;
    public static final double FOUR_PI = Math.PI * 4;
    public static final char DEGREE_SYMBOL = '\u00b0';
    protected MeasuredValue valueRadians;

    public double getDegrees() {
        return StrictMath.toDegrees(this.valueRadians.getValue());
    }

    public double getHours() {
        return StrictMath.toDegrees(this.valueRadians.getValue()) / 15.0;
    }

    public double getRadians() {
        return this.valueRadians.getValue();
    }

    public double getStdErrDegrees() {
        return StrictMath.toDegrees(this.valueRadians.getStdErr());
    }

    public double getStdErrHours() {
        return StrictMath.toDegrees(this.valueRadians.getStdErr()) / 15.0;
    }

    public double getStdErrRadians() {
        return this.valueRadians.getStdErr();
    }

    private Angle(MeasuredValue measuredValue) {
        this.valueRadians = measuredValue;
    }

    public Angle(double d, Units units) {
        this(d, 0.0, units);
    }

    public Angle(double d, double d2, Units units) {
        switch (units) {
            case DEGREES: {
                this.valueRadians = new MeasuredValue(StrictMath.toRadians(d), StrictMath.toRadians(d2), Units.RADIANS);
                break;
            }
            case HOURS: {
                this.valueRadians = new MeasuredValue(StrictMath.toRadians(d * 15.0), StrictMath.toRadians(d2 * 15.0), Units.RADIANS);
                break;
            }
            case RADIANS: {
                this.valueRadians = new MeasuredValue(d, d2, Units.RADIANS);
            }
        }
    }

    public static Angle parseAngle(String string) throws NumberFormatException {
        double d;
        Pattern pattern = Pattern.compile("^[+-]?\\d{1,4}\\.\\d*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && (d = Double.parseDouble(string)) < 10000.0 && d > -10000.0) {
            return new Angle(d, Units.DEGREES);
        }
        Pattern pattern2 = Pattern.compile("^([+-]?)(\\d*).?(\\d{2}).?(\\d{2}(\\.\\d*)?)s?$");
        Matcher matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            String string2;
            int n = 1;
            String string3 = matcher2.group(1);
            if (null != string3 && 0 < string3.length() && string3.charAt(0) == '-') {
                n = -1;
            }
            if (null != (string2 = matcher2.group(2))) {
                int n2 = Integer.parseInt(string2);
                String string4 = matcher2.group(3);
                if (null != string4) {
                    int n3 = Integer.parseInt(string4);
                    String string5 = matcher2.group(4);
                    if (null != string5) {
                        double d2 = Double.parseDouble(string5);
                        return new Angle((double)n * ((double)n2 + (double)n3 / 60.0 + d2 / 3600.0), Units.DEGREES);
                    }
                }
            }
        }
        throw new NumberFormatException(string + " is not a valid angle");
    }

    public double cos() {
        return StrictMath.cos(this.getRadians());
    }

    public double sin() {
        return StrictMath.sin(this.getRadians());
    }

    public double tan() {
        return StrictMath.tan(this.getRadians());
    }

    public static Angle acos(double d) {
        return new Angle(StrictMath.acos(d), 0.0, Units.RADIANS);
    }

    public static Angle asin(double d) {
        return new Angle(StrictMath.asin(d), 0.0, Units.RADIANS);
    }

    public static Angle atan(double d) {
        return new Angle(StrictMath.atan(d), 0.0, Units.RADIANS);
    }

    public static Angle atan2(double d, double d2) {
        return new Angle(StrictMath.atan2(d, d2), 0.0, Units.RADIANS);
    }

    public Angle in360() {
        double d = this.getRadians() % (Math.PI * 2);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return new Angle(d, this.getStdErrRadians(), Units.RADIANS);
    }

    public Angle add(Angle angle) {
        try {
            return new Angle(this.valueRadians.add(angle.valueRadians));
        }
        catch (MixedUnitsException mixedUnitsException) {
            Util.warning("Error", "Mixed units in Angle.add");
            return null;
        }
    }

    public Angle subtract(Angle angle) {
        try {
            return new Angle(this.valueRadians.subtract(angle.valueRadians));
        }
        catch (MixedUnitsException mixedUnitsException) {
            Util.warning("Error", "Mixed units in Angle.subtract");
            return null;
        }
    }

    public Angle multiply(double d) {
        return new Angle(this.valueRadians.multiply(d));
    }

    public Angle difference(Angle angle) {
        double d = Maths.in360(this.getDegrees() - angle.getDegrees());
        if (d > 180.0) {
            d -= 360.0;
        }
        return new Angle(d, Units.DEGREES);
    }

    @Override
    public int compareTo(Angle angle) {
        Angle angle2 = this.difference(angle);
        if (null == angle2) {
            throw new NullPointerException("Mixed units in Angle.compareTo (other)");
        }
        double d = angle2.getDegrees();
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static Maths.Statistics angleStatistics(Collection<Angle> collection) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        for (Angle angle : collection) {
            dArray[n] = angle.getDegrees();
            ++n;
        }
        return Maths.angleStatistics(dArray);
    }

    public static Maths.Statistics angleStatistics(Angle ... angleArray) {
        double[] dArray = new double[angleArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = angleArray[i].getDegrees();
        }
        return Maths.angleStatistics(dArray);
    }

    public Angle clone() {
        return new Angle(this.valueRadians);
    }

    public String toString() {
        return this.valueRadians.toString();
    }

    public String toString(Units units) {
        switch (units) {
            case DEGREES: {
                return new MeasuredValue(this.getDegrees(), this.getStdErrDegrees(), units).toString();
            }
            case HOURS: {
                return new MeasuredValue(this.getHours(), this.getStdErrHours(), units).toString();
            }
        }
        return this.valueRadians.toString();
    }

    public int hashCode() {
        return this.valueRadians.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Angle angle = (Angle)object;
        return this.valueRadians.equals(angle.valueRadians);
    }

    public static enum Units implements net.grelf.Units,
    Serializable
    {
        ARCMINUTES("'"),
        ARCSECONDS("\""),
        DEGREES("\u00b0"),
        HOURS("h"),
        RADIANS(""),
        TIMEMINUTES("m"),
        TIMESECONDS("s");

        private String symbol;

        private Units(String string2) {
            this.symbol = string2;
        }

        @Override
        public Units createUnitsFromName(String string) {
            for (Units units : Units.values()) {
                if (!units.toString().equalsIgnoreCase(string)) continue;
                return units;
            }
            return null;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public List<String> getNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Units units : Units.values()) {
                arrayList.add(units.toString());
            }
            return arrayList;
        }
    }
}

