/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.util.Collection;
import java.util.Iterator;

public class Maths {
    public static final double DEGREES_PER_RADIAN = 57.29577951308232;
    public static final double RADIANS_PER_DEGREE = Math.PI / 180;
    public static final double SQRT2 = Math.sqrt(2.0);

    private Maths() {
    }

    public static double angleMean(double ... dArray) {
        Statistics statistics = Maths.angleStatistics(dArray);
        return statistics.mean;
    }

    public static double angleDifference(double d, double d2) {
        double d3 = d - d2;
        if (d3 > 180.0) {
            return d3 - 360.0;
        }
        if (d3 < -180.0) {
            return d3 + 360.0;
        }
        return d3;
    }

    public static Statistics angleStatistics(double ... dArray) {
        Statistics statistics = new Statistics();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        for (double d6 : dArray) {
            if (Double.POSITIVE_INFINITY == d3) {
                d3 = d6;
            }
            ++n;
            double d7 = Maths.angleDifference(d6, d3);
            d4 += d7;
            d5 += d7 * d7;
            if (d7 < d) {
                d = d7;
                continue;
            }
            if (!(d7 > d2)) continue;
            d2 = d7;
        }
        statistics.n = n;
        statistics.min = Maths.in360(d3 + d);
        statistics.max = Maths.in360(d3 + d2);
        statistics.mean = Maths.in360(d3 + d4 / (double)n);
        statistics.stdDev = StrictMath.sqrt(d5 / (double)n - statistics.mean * statistics.mean);
        return statistics;
    }

    public static Statistics angleStatistics(Collection<Double> collection) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        Iterator<Double> iterator = collection.iterator();
        while (iterator.hasNext()) {
            double d;
            dArray[n] = d = iterator.next().doubleValue();
            ++n;
        }
        return Maths.angleStatistics(dArray);
    }

    public static double in360(double d) {
        double d2 = d % 360.0;
        if (d2 >= 0.0) {
            return d2;
        }
        return d2 + 360.0;
    }

    public static double acosDegs(double d) {
        return Maths.toDegrees(StrictMath.acos(d));
    }

    public static double asinDegs(double d) {
        return Maths.toDegrees(StrictMath.asin(d));
    }

    public static double asinh(double d) {
        return StrictMath.log(d + StrictMath.sqrt(d * d + 1.0));
    }

    public static double atan2Degs(double d, double d2) {
        return Maths.toDegrees(StrictMath.atan2(d, d2));
    }

    public static double sinDegs(double d) {
        return StrictMath.sin(Maths.toRadians(d));
    }

    public static double cosDegs(double d) {
        return StrictMath.cos(Maths.toRadians(d));
    }

    public static double tanDegs(double d) {
        return StrictMath.tan(Maths.toRadians(d));
    }

    public static double toDegrees(double d) {
        return d * 57.29577951308232;
    }

    public static double toRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static double erf(double d) {
        double d2 = 1.0 / (1.0 + 0.5 * StrictMath.abs(d));
        double d3 = 1.0 - d2 * StrictMath.exp(-d * d - 1.26551223 + d2 * (1.00002368 + d2 * (0.37409196 + d2 * (0.09678418 + d2 * (-0.18628806 + d2 * (0.27886807 + d2 * (-1.13520398 + d2 * (1.48851587 + d2 * (-0.82215223 + d2 * 0.17087277)))))))));
        if (d >= 0.0) {
            return d3;
        }
        return -d3;
    }

    public static double erf2(double d) {
        double d2 = 1.0 / (1.0 + 0.47047 * StrictMath.abs(d));
        double d3 = d2 * (0.3480242 + d2 * (-0.0958798 + d2 * 0.7478556));
        double d4 = 1.0 - d3 * StrictMath.exp(-d * d);
        if (d >= 0.0) {
            return d4;
        }
        return -d4;
    }

    public static double phi(double d) {
        return 0.5 * (1.0 + Maths.erf(d / SQRT2));
    }

    public static class Statistics {
        public int n;
        public double min;
        public double mean;
        public double max;
        public double stdDev;
    }
}

