/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;
import net.grelf.Angle;

public class Dec
extends Angle
implements Cloneable,
Serializable {
    private static final DecimalFormat DF1 = new DecimalFormat("0");
    private static final DecimalFormat DF2 = new DecimalFormat("00");
    private static final DecimalFormat DF2_1 = new DecimalFormat("00.0");

    public byte getDegree() {
        byte by = (byte)StrictMath.floor(this.getDegrees());
        if (by < 0) {
            by = (byte)(by + 1);
        }
        return by;
    }

    public byte getMinute() {
        double d = this.getDegrees() * 60.0;
        int n = (int)Math.floor(d);
        if (n < 0) {
            ++n;
        }
        return (byte)(n % 60);
    }

    public float getSecond() {
        double d = this.getDegrees();
        double d2 = Math.abs(d * 60.0);
        double d3 = Math.floor(d2);
        double d4 = d2 - d3;
        float f = (float)d4 * 60.0f;
        return d < 0.0 ? -f : f;
    }

    public Dec(double d, double d2, double d3, double d4) {
        super(d + d2 / 60.0 + d3 / 3600.0, d4, Angle.Units.DEGREES);
    }

    public Dec(double d, double d2, double d3) {
        this(d, d2, d3, 0.0);
    }

    public Dec(double d, double d2) {
        super(d, d2, Angle.Units.DEGREES);
    }

    public Dec(double d) {
        this(d, 0.0, 0.0);
    }

    public Dec(Angle angle) {
        this(angle.getDegrees(), angle.getStdErrDegrees());
    }

    public static Dec parseDec(String string) throws NumberFormatException {
        Angle angle = Angle.parseAngle(string);
        double d = angle.getDegrees();
        if (d > 90.0 || d < -90.0) {
            throw new NumberFormatException(string + " is not a valid declination");
        }
        return new Dec(angle);
    }

    public double toDegrees() {
        return this.getDegrees();
    }

    @Override
    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        Dec dec = (Dec)object;
        return this.valueRadians.equals(dec.valueRadians);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Dec clone() {
        return new Dec(this);
    }

    @Override
    public String toString() {
        String string = this.getDegrees() > 0.0 ? "+" : "-";
        return string + DF2.format(Math.abs(this.getDegree())) + "d" + DF2.format(Math.abs(this.getMinute())) + "m" + DF2_1.format(Math.abs(this.getSecond())) + "s";
    }
}

