/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.astro.JulianDate;

public class JulianDateDialogue
extends AbstractDialogue
implements ActionListener {
    private JLabel dateLabel = new JLabel("Calendar date and time");
    private JTextField dateY = new JTextField(8);
    private JLabel dateYLabel = new JLabel(" y ");
    private JTextField dateN = new JTextField(4);
    private JLabel dateNLabel = new JLabel(" m ");
    private JTextField dateD = new JTextField(4);
    private JLabel dateDLabel = new JLabel(" d ");
    private JTextField dateH = new JTextField(4);
    private JLabel dateHLabel = new JLabel(" h ");
    private JTextField dateM = new JTextField(4);
    private JLabel dateMLabel = new JLabel(" m ");
    private JTextField dateS = new JTextField(4);
    private JLabel dateSLabel = new JLabel(" s ");
    private JLabel tzLabel = new JLabel("Time zone offset hours");
    private JTextField tz = new JTextField(8);
    private JLabel jdLabel = new JLabel("Julian date");
    private JTextField jd = new JTextField(24);
    private JButton calcButton = new JButton("Convert");
    private JButton clearButton = new JButton("Clear");
    private JButton nowButton = new JButton("Now");
    private JButton closeButton = new JButton("Close");
    private static final double IMPOSSIBLE_TZ = -1000.0;

    public JulianDateDialogue() {
        this((Frame)null);
    }

    public JulianDateDialogue(Frame frame) {
        super(frame, "Julian date", false);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.placeControl(container, this.dateLabel, 0, 0, 11, 1);
        this.placeControl(container, this.dateY, 0, 1, 1, 1);
        this.placeControl(container, this.dateYLabel, 1, 1, 1, 1);
        this.placeControl(container, this.dateN, 2, 1, 1, 1);
        this.placeControl(container, this.dateNLabel, 3, 1, 1, 1);
        this.placeControl(container, this.dateD, 4, 1, 1, 1);
        this.placeControl(container, this.dateDLabel, 5, 1, 1, 1);
        this.placeControl(container, this.dateH, 6, 1, 1, 1);
        this.placeControl(container, this.dateHLabel, 7, 1, 1, 1);
        this.placeControl(container, this.dateM, 8, 1, 1, 1);
        this.placeControl(container, this.dateMLabel, 9, 1, 1, 1);
        this.placeControl(container, this.dateS, 10, 1, 1, 1);
        this.placeControl(container, this.dateSLabel, 11, 1, 1, 1);
        this.placeControl(container, this.tzLabel, 0, 2, 11, 1);
        this.placeControl(container, this.tz, 0, 3, 11, 1);
        this.placeControl(container, this.jdLabel, 0, 4, 11, 1);
        this.placeControl(container, this.jd, 0, 5, 11, 1);
        this.placeControl(container, this.calcButton, 0, 6, 4, 1);
        this.calcButton.setActionCommand("calc");
        this.calcButton.addActionListener(this);
        this.placeControl(container, this.clearButton, 4, 6, 4, 1);
        this.clearButton.setActionCommand("clear");
        this.clearButton.addActionListener(this);
        this.placeControl(container, this.nowButton, 8, 6, 4, 1);
        this.nowButton.setActionCommand("now");
        this.nowButton.addActionListener(this);
        this.placeControl(container, this.closeButton, 12, 6, 4, 1);
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        this.setNow();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setLocation(200, 200);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("calc")) {
            if (0 == this.dateY.getText().length()) {
                this.convertJulianToCalendar();
            } else {
                this.convertCalendarToJulian();
            }
        } else if (string.equals("clear")) {
            this.dateY.setText("");
            this.dateN.setText("");
            this.dateD.setText("");
            this.dateH.setText("");
            this.dateM.setText("");
            this.dateS.setText("");
            this.jd.setText("");
        } else if (string.equals("now")) {
            this.setNow();
        } else if (string.equals("close")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setNow() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.setCalendarFields(gregorianCalendar);
        this.jd.setText(new JulianDate(gregorianCalendar).toString());
    }

    private void setCalendarFields(Calendar calendar) {
        this.dateY.setText("" + calendar.get(1));
        this.dateN.setText("" + (calendar.get(2) + 1));
        this.dateD.setText("" + calendar.get(5));
        this.dateH.setText("" + calendar.get(11));
        this.dateM.setText("" + calendar.get(12));
        this.dateS.setText("" + calendar.get(13));
    }

    private double getTimeZoneOffsetHours() {
        try {
            String string = this.tz.getText();
            if (string.length() > 0) {
                return Double.parseDouble(string);
            }
            return 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning(this, "Error", (Object)"Invalid character(s) in time zone field");
            return -1000.0;
        }
    }

    private void convertJulianToCalendar() {
        double d = this.getTimeZoneOffsetHours();
        if (-1000.0 != d) {
            try {
                JulianDate julianDate = new JulianDate(Double.parseDouble(this.jd.getText()) - d);
                this.setCalendarFields(julianDate.toGregorianCalendar());
            }
            catch (NumberFormatException numberFormatException) {
                Util.warning(this, "Error", (Object)"Invalid character(s) in Julian date field");
            }
        }
    }

    private void convertCalendarToJulian() {
        double d = this.getTimeZoneOffsetHours();
        if (-1000.0 != d) {
            try {
                int n = (int)Math.floor(d);
                int n2 = (int)Math.floor((d - (double)n) * 60.0);
                JulianDate julianDate = new JulianDate(new GregorianCalendar(Integer.parseInt(this.dateY.getText()), Integer.parseInt(this.dateN.getText()) - 1, Integer.parseInt(this.dateD.getText()), Integer.parseInt(this.dateH.getText()) + n, Integer.parseInt(this.dateM.getText()) + n2, Integer.parseInt(this.dateS.getText())));
                this.jd.setText(julianDate.toString());
            }
            catch (NumberFormatException numberFormatException) {
                Util.warning(this, "Error", (Object)"Invalid character(s) in calendar field(s)");
            }
        }
    }
}

