/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.HelpMenu;

public class MagnitudeBands {
    private String[] bands;

    public String getBand(int n) {
        if (null == this.bands) {
            return null;
        }
        return this.bands[n];
    }

    public int getNBands() {
        if (null == this.bands) {
            return 0;
        }
        return this.bands.length;
    }

    public MagnitudeBands(int n) {
        this.bands = new String[n];
        if (n == 1) {
            this.bands[0] = "V";
        } else if (n == 3) {
            this.bands[0] = "R";
            this.bands[1] = "V";
            this.bands[2] = "B";
        } else {
            Util.logWarning("Attempt to construct MagnitudeBands for {0}-band image", n);
        }
    }

    public void showDialogue(Frame frame) {
        new MagnitudeBandsDialogue(this.bands, frame);
    }

    private static class MagnitudeBandsDialogue
    extends AbstractDialogue
    implements ActionListener {
        private JLabel imageKind;
        private JLabel heading;
        private JLabel[] labels;
        private JTextField[] fields;
        private JLabel note;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");
        private JButton helpButton = new JButton("Help");
        private String[] bands;

        public MagnitudeBandsDialogue(String[] stringArray, Frame frame) {
            super(frame, "Magnitude wavebands", false);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            this.bands = stringArray;
            int n = this.bands.length;
            this.labels = new JLabel[n];
            this.fields = new JTextField[n];
            this.note = new JLabel("Note: will use V if a band is unavailable");
            int n2 = 0;
            if (1 == n) {
                this.imageKind = new JLabel("Monochrome image");
                this.labels[0] = new JLabel("Reference star wavelength band to use");
                this.fields[0] = new JTextField(this.bands[0], 5);
                this.placeControl(container, this.imageKind, 0, 0, 2, 1);
                this.placeControl(container, this.labels[0], 0, 1, 2, 1);
                this.placeControl(container, this.fields[0], 2, 1, 1, 1);
                this.placeControl(container, this.note, 0, 2, 3, 1);
                n2 = 3;
            } else if (3 == n) {
                this.imageKind = new JLabel("RGB image");
                this.heading = new JLabel("Reference star wavelength bands to use");
                this.labels[0] = new JLabel("for RED channel of image");
                this.fields[0] = new JTextField(this.bands[0], 5);
                this.labels[1] = new JLabel("for GREEN channel of image");
                this.fields[1] = new JTextField(this.bands[1], 5);
                this.labels[2] = new JLabel("for BLUE channel of image");
                this.fields[2] = new JTextField(this.bands[2], 5);
                this.placeControl(container, this.imageKind, 0, 0, 2, 1);
                this.placeControl(container, this.heading, 0, 1, 3, 1);
                n2 = 2;
                for (int i = 0; i < 3; ++i) {
                    this.placeControl(container, this.labels[i], 0, n2, 2, 1);
                    this.placeControl(container, this.fields[i], 2, n2, 1, 1);
                    ++n2;
                }
                this.placeControl(container, this.note, 0, n2, 2, 1);
                ++n2;
            } else {
                Util.logWarning("Attempt to use MagnitudeBandsDialogue for {0}-band image", n);
                return;
            }
            this.placeControl(container, this.okButton, 0, n2, 1, 1);
            this.okButton.setActionCommand("ok");
            this.okButton.addActionListener(this);
            this.placeControl(container, this.cancelButton, 1, n2, 1, 1);
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(this);
            this.placeControl(container, this.helpButton, 2, n2, 1, 1);
            this.helpButton.setActionCommand("help");
            this.helpButton.addActionListener(this);
            this.pack();
            this.setResizable(false);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok")) {
                for (int i = 0; i < this.bands.length; ++i) {
                    this.bands[i] = this.fields[i].getText();
                }
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("cancel")) {
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("help")) {
                HelpMenu.help("pages/mag_bands.html");
            }
        }
    }
}

