/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.grelf.OutOfRangeException;
import net.grelf.Util;
import net.grelf.astro.Dec;
import net.grelf.astro.Epoch;
import net.grelf.astro.ProperMotion;
import net.grelf.astro.RA;
import net.grelf.astro.SimbadGateway;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.SkyPointDialogue;
import net.grelf.astro.Star;

public class SkyPointPane
extends JComponent
implements ActionListener {
    private Star star = null;
    private SkyPointDialogue parentDialogue = null;
    private boolean inApplet = false;
    private static final DecimalFormat DF1 = new DecimalFormat("0.0");
    private static final DecimalFormat DF2 = new DecimalFormat("0.00");
    private static final DecimalFormat DF4 = new DecimalFormat("0.0000");
    private JLabel objLabel = new JLabel("Object name");
    private JTextField objId = new JTextField(8);
    private JLabel objNoteLabel = new JLabel("(Object may be anything outside the solar system)");
    private JButton dataButton = new JButton("Get data");
    private JLabel raLabel = new JLabel("RA (0h0m0s..23h59m59.99s)");
    private JTextField raH = new JTextField(8);
    private JLabel raHLabel = new JLabel(" h ");
    private JTextField raM = new JTextField(8);
    private JLabel raMLabel = new JLabel(" m ");
    private JTextField raS = new JTextField(8);
    private JLabel raSLabel = new JLabel(" s ");
    private JTextField raDeg = new JTextField(8);
    private JLabel raDegLabel = new JLabel(" degrees ");
    private JLabel decLabel = new JLabel("Dec (-90\u00b00'0\"..+90\u00b00'0\")");
    private JTextField decD = new JTextField(8);
    private JLabel decDLabel = new JLabel(" \u00b0 ");
    private JTextField decM = new JTextField(8);
    private JLabel decMLabel = new JLabel(" ' ");
    private JTextField decS = new JTextField(8);
    private JLabel decSLabel = new JLabel(" \" ");
    private JTextField decDeg = new JTextField(8);
    private JLabel decDegLabel = new JLabel(" degrees ");
    private JLabel epochLabel = new JLabel("Epoch ");
    private JComboBox epochJB = new JComboBox<String>(new String[]{"J", "B"});
    private JTextField epochField = new JTextField("2000", 8);
    private JLabel pmraLabel = new JLabel("Proper motion in RA (arcsec/yr)");
    private JTextField pmra = new JTextField(8);
    private JLabel pmdecLabel = new JLabel("Proper motion in Dec (arcsec/yr)");
    private JTextField pmdec = new JTextField(8);
    private JLabel spacer0Label = new JLabel(" ");
    private JLabel spacer1Label = new JLabel(" ");
    private JLabel spacer2Label = new JLabel(" ");
    private JLabel spacer3Label = new JLabel(" ");
    private JLabel spacer4Label = new JLabel(" ");
    private JButton convertButton = new JButton("Convert to/from degrees");
    private JButton epochButton = new JButton("Change epoch");
    private JButton closeButton = new JButton("Close");
    private JTextArea textarea = new JTextArea(10, 30);

    public SkyPointPane(SkyPointDialogue skyPointDialogue) {
        this(false);
        this.parentDialogue = skyPointDialogue;
    }

    public SkyPointPane(boolean bl) {
        this.inApplet = bl;
        this.star = new Star();
        SkyPointPane skyPointPane = this;
        skyPointPane.setLayout(new GridBagLayout());
        this.placeControl(skyPointPane, this.objLabel, 0, 0, 2, 1);
        this.placeControl(skyPointPane, this.objId, 2, 0, 3, 1);
        this.dataButton.setActionCommand("data");
        this.dataButton.addActionListener(this);
        this.placeControl(skyPointPane, this.dataButton, 6, 0, 2, 1);
        this.placeControl(skyPointPane, this.objNoteLabel, 0, 1, 6, 1);
        this.placeControl(skyPointPane, this.spacer0Label, 0, 2, 6, 1);
        this.placeControl(skyPointPane, this.raLabel, 0, 3, 6, 1);
        this.placeControl(skyPointPane, this.raH, 0, 4, 1, 1);
        this.placeControl(skyPointPane, this.raHLabel, 1, 4, 1, 1);
        this.placeControl(skyPointPane, this.raM, 2, 4, 1, 1);
        this.placeControl(skyPointPane, this.raMLabel, 3, 4, 1, 1);
        this.placeControl(skyPointPane, this.raS, 4, 4, 1, 1);
        this.placeControl(skyPointPane, this.raSLabel, 5, 4, 1, 1);
        this.placeControl(skyPointPane, this.raDeg, 6, 4, 1, 1);
        this.placeControl(skyPointPane, this.raDegLabel, 7, 4, 1, 1);
        this.placeControl(skyPointPane, this.spacer1Label, 0, 5, 6, 1);
        this.placeControl(skyPointPane, this.decLabel, 0, 6, 6, 1);
        this.placeControl(skyPointPane, this.decD, 0, 7, 1, 1);
        this.placeControl(skyPointPane, this.decDLabel, 1, 7, 1, 1);
        this.placeControl(skyPointPane, this.decM, 2, 7, 1, 1);
        this.placeControl(skyPointPane, this.decMLabel, 3, 7, 1, 1);
        this.placeControl(skyPointPane, this.decS, 4, 7, 1, 1);
        this.placeControl(skyPointPane, this.decSLabel, 5, 7, 1, 1);
        this.placeControl(skyPointPane, this.decDeg, 6, 7, 1, 1);
        this.placeControl(skyPointPane, this.decDegLabel, 7, 7, 2, 1);
        this.placeControl(skyPointPane, this.spacer2Label, 0, 8, 6, 1);
        this.convertButton.setActionCommand("convert");
        this.convertButton.addActionListener(this);
        this.placeControl(skyPointPane, this.convertButton, 6, 9, 2, 1);
        this.placeControl(skyPointPane, this.epochLabel, 0, 10, 1, 1);
        this.placeControl(skyPointPane, this.epochJB, 2, 10, 1, 1);
        this.placeControl(skyPointPane, this.epochField, 4, 10, 1, 1);
        this.placeControl(skyPointPane, this.spacer3Label, 0, 11, 6, 1);
        this.placeControl(skyPointPane, this.pmraLabel, 0, 12, 3, 1);
        this.placeControl(skyPointPane, this.pmra, 4, 12, 1, 1);
        this.placeControl(skyPointPane, this.pmdecLabel, 0, 13, 3, 1);
        this.placeControl(skyPointPane, this.pmdec, 4, 13, 1, 1);
        this.epochButton.setActionCommand("epoch");
        this.epochButton.addActionListener(this);
        this.placeControl(skyPointPane, this.epochButton, 6, 13, 2, 1);
        if (null != this.parentDialogue) {
            this.closeButton.setActionCommand("close");
            this.closeButton.addActionListener(this);
            this.placeControl(skyPointPane, this.closeButton, 6, 16, 2, 1);
        }
        this.placeControl(skyPointPane, this.spacer4Label, 0, 17, 6, 1);
        JScrollPane jScrollPane = new JScrollPane(this.textarea);
        this.placeControl(skyPointPane, jScrollPane, 0, 18, 8, 1);
        this.objId.requestFocusInWindow();
    }

    protected void placeControl(Container container, JComponent jComponent, int n, int n2, int n3, int n4) {
        this.placeControl(container, jComponent, n, n2, n3, n4, 2);
    }

    protected void placeControl(Container container, JComponent jComponent, int n, int n2, int n3, int n4, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.ipady = 6;
        container.add((Component)jComponent, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            if (null != this.parentDialogue) {
                this.parentDialogue.dispose();
            }
        } else if (string.equals("convert")) {
            this.convert();
        } else if (string.equals("data")) {
            this.star = this.inApplet ? SimbadGateway.getInstance().getStarFromId(this.objId.getText(), "http://britastro.org/~computing/php/simbadi.php?obj=", this.textarea) : SimbadGateway.getInstance().getStarFromId(this.objId.getText(), null, null);
            this.updateFields();
        } else if (string.equals("epoch")) {
            this.changeEpoch();
        }
    }

    private void convert() {
        double d;
        double d2;
        double d3;
        RA rA = null;
        Dec dec = null;
        Epoch epoch = null;
        try {
            if (this.raH.getText().length() > 0) {
                d3 = Double.parseDouble(this.raH.getText());
                d2 = 0.0;
                d = 0.0;
                if (this.raM.getText().length() > 0) {
                    d2 = Double.parseDouble(this.raM.getText());
                }
                if (this.raS.getText().length() > 0) {
                    d = Double.parseDouble(this.raS.getText());
                }
                if (d3 < 0.0 || d3 >= 24.0) {
                    throw new OutOfRangeException("RA hours");
                }
                if (d2 < 0.0 || d2 >= 60.0) {
                    throw new OutOfRangeException("RA minutes");
                }
                if (d < 0.0 || d >= 60.0) {
                    throw new OutOfRangeException("RA seconds");
                }
                rA = new RA(d3, d2, d);
            } else if (this.raDeg.getText().length() > 0) {
                rA = new RA(Double.parseDouble(this.raDeg.getText()));
            } else {
                Util.warning(this, "Error", (Object)"Either hours or degrees must have a value for RA");
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning(this, "Error", (Object)"Non-numerical data entered into an RA field");
        }
        catch (OutOfRangeException outOfRangeException) {
            Util.warning(this, "Error", (Object)outOfRangeException.toString());
        }
        try {
            if (this.decD.getText().length() > 0) {
                d3 = Double.parseDouble(this.decD.getText());
                d2 = 0.0;
                d = 0.0;
                if (this.decM.getText().length() > 0) {
                    d2 = Double.parseDouble(this.decM.getText());
                }
                if (this.decS.getText().length() > 0) {
                    d = Double.parseDouble(this.decS.getText());
                }
                if (d3 < -90.0 || d3 > 90.0) {
                    throw new OutOfRangeException("Dec degrees");
                }
                if (d2 < 0.0 || d2 >= 60.0) {
                    throw new OutOfRangeException("Dec arc-minutes");
                }
                if (d < 0.0 || d >= 60.0) {
                    throw new OutOfRangeException("Dec arc-seconds");
                }
                if (d3 < 0.0 || this.decD.getText().charAt(0) == '-') {
                    d2 = -d2;
                    d = -d;
                }
                dec = new Dec(d3, d2, d);
            } else if (this.decDeg.getText().length() > 0) {
                dec = new Dec(Double.parseDouble(this.decDeg.getText()));
            } else {
                Util.warning(this, "Error", (Object)"Either of the degrees fields must have a value for Dec");
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning(this, "Error", (Object)"Non-numerical data entered into a Dec field");
        }
        catch (OutOfRangeException outOfRangeException) {
            Util.warning(this, "Error", (Object)outOfRangeException.toString());
        }
        try {
            char c = ((String)this.epochJB.getSelectedItem()).charAt(0);
            epoch = new Epoch(c, Float.parseFloat(this.epochField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning(this, "Error", (Object)"Invalid data in the Epoch field");
        }
        try {
            double d4 = Double.parseDouble(this.pmra.getText());
            d2 = Double.parseDouble(this.pmdec.getText());
            this.star.setProperMotion(new ProperMotion(d4, d2));
        }
        catch (NumberFormatException numberFormatException) {
            Util.warning(this, "Error", (Object)"Invalid data in a proper motion field");
        }
        if (null == rA || null == dec || null == epoch) {
            Util.warning(this, "Error", (Object)"Cannot convert");
        } else {
            this.star.setPosition(new SkyPoint(rA, dec, epoch));
            this.updateFields();
        }
    }

    private void changeEpoch() {
        this.convert();
        String string = Util.askString("New epoch?", "");
        if (null != string && string.length() > 0) {
            try {
                char c = string.toUpperCase().charAt(0);
                switch (c) {
                    case 'B': 
                    case 'J': {
                        string = string.substring(1);
                        break;
                    }
                    default: {
                        c = 'J';
                    }
                }
                float f = Float.parseFloat(string);
                SkyPoint skyPoint = this.star.getPosition();
                ProperMotion properMotion = this.star.getProperMotion();
                double d = properMotion.getPmRA_arcsecPerYr();
                double d2 = properMotion.getPmDec_arcsecPerYr();
                if (d != 0.0 || d2 != 0.0) {
                    RA rA = skyPoint.getRA();
                    Dec dec = skyPoint.getDec();
                    Epoch epoch = skyPoint.getEquinox();
                    double d3 = f - epoch.getYear();
                    rA = new RA(rA.toDegrees() + d3 * d / 3600.0);
                    dec = new Dec(dec.toDegrees() + d3 * d2 / 3600.0);
                    skyPoint = new SkyPoint(rA, dec, epoch);
                }
                skyPoint.changeEquinox(new Epoch(c, f));
                this.star.setPosition(skyPoint);
                this.updateFields();
            }
            catch (NumberFormatException numberFormatException) {
                Util.warning(this, "Error", (Object)"Invalid new epoch: cannot convert");
            }
        } else {
            Util.warning(this, "Error", (Object)"No new epoch entered: cannot convert");
        }
    }

    private void updateFields() {
        SkyPoint skyPoint = this.star.getPosition();
        RA rA = skyPoint.getRA();
        Dec dec = skyPoint.getDec();
        Epoch epoch = skyPoint.getEquinox();
        this.raH.setText("" + rA.getHour());
        this.raM.setText("" + rA.getMinute());
        this.raS.setText("" + DF2.format(rA.getSecond()));
        this.raDeg.setText("" + DF4.format(rA.toDegrees()));
        byte by = dec.getDegree();
        byte by2 = dec.getMinute();
        double d = dec.getSecond();
        if (by2 < 0) {
            by2 = -by2;
        }
        if (d < 0.0) {
            d = -d;
        }
        String string = "";
        if (by == 0 && dec.toString().charAt(0) == '-') {
            string = "-";
        }
        this.decD.setText(string + by);
        this.decM.setText("" + by2);
        this.decS.setText("" + DF1.format(d));
        this.decDeg.setText("" + DF4.format(dec.toDegrees()));
        if ('B' == epoch.getType()) {
            this.epochJB.setSelectedIndex(1);
        } else {
            this.epochJB.setSelectedIndex(0);
        }
        this.epochField.setText(DF2.format(epoch.getYear()));
        ProperMotion properMotion = this.star.getProperMotion();
        this.pmra.setText(DF4.format(properMotion.getPmRA_arcsecPerYr()));
        this.pmdec.setText(DF4.format(properMotion.getPmDec_arcsecPerYr()));
    }
}

